/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.overseer;

import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.PerReplicaStatesOps;

public class ZkWriteCommand {
    public final String name;
    public final DocCollection collection;
    public final boolean noop;
    public final boolean persistCollState;
    public final PerReplicaStatesOps ops;

    public ZkWriteCommand(String name, DocCollection collection, PerReplicaStatesOps replicaOps, boolean persistCollState) {
        boolean isPerReplicaState = collection.isPerReplicaState();
        this.name = name;
        this.collection = collection;
        this.noop = false;
        this.ops = isPerReplicaState ? replicaOps : null;
        this.persistCollState = isPerReplicaState ? persistCollState : true;
    }

    public ZkWriteCommand(String name, DocCollection collection) {
        this.name = name;
        this.collection = collection;
        this.noop = false;
        this.persistCollState = true;
        this.ops = collection != null && collection.isPerReplicaState() ? PerReplicaStatesOps.touchChildren() : null;
    }

    protected ZkWriteCommand() {
        this.noop = true;
        this.name = null;
        this.collection = null;
        this.ops = null;
        this.persistCollState = true;
    }

    public static ZkWriteCommand noop() {
        return new ZkWriteCommand();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + (this.noop ? "no-op" : this.name + "=" + this.collection);
    }
}

