/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.derby.iapi.jdbc.BrokeredCallableStatement;
import org.apache.derby.iapi.jdbc.BrokeredCallableStatement40;
import org.apache.derby.iapi.jdbc.BrokeredConnection30;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement40;
import org.apache.derby.iapi.jdbc.BrokeredStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatement40;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;
import org.apache.derby.iapi.jdbc.EngineConnection40;
import org.apache.derby.iapi.jdbc.FailedProperties40;

public class BrokeredConnection40
extends BrokeredConnection30
implements EngineConnection40 {
    public BrokeredConnection40(BrokeredConnectionControl brokeredConnectionControl) throws SQLException {
        super(brokeredConnectionControl);
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        try {
            return this.getRealConnection().createArrayOf(string, objectArray);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            return this.getRealConnection().createBlob();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            return this.getRealConnection().createClob();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            return this.getRealConnection().createNClob();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            return this.getRealConnection().createSQLXML();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        try {
            return this.getRealConnection().createStruct(string, objectArray);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final boolean isValid(int n) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        try {
            return this.getRealConnection().isValid(n);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        try {
            this.getRealConnection().setClientInfo(string, string2);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            this.notifyException(sQLClientInfoException);
            throw sQLClientInfoException;
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), new FailedProperties40(FailedProperties40.makeProperties(string, string2)).getProperties());
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.getRealConnection().setClientInfo(properties);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            this.notifyException(sQLClientInfoException);
            throw sQLClientInfoException;
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), new FailedProperties40(properties).getProperties());
        }
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        try {
            return this.getRealConnection().getClientInfo(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            return this.getRealConnection().getClientInfo();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final BrokeredStatement newBrokeredStatement(BrokeredStatementControl brokeredStatementControl) throws SQLException {
        try {
            return new BrokeredStatement40(brokeredStatementControl);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final BrokeredPreparedStatement newBrokeredStatement(BrokeredStatementControl brokeredStatementControl, String string, Object object) throws SQLException {
        try {
            return new BrokeredPreparedStatement40(brokeredStatementControl, string, object);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final BrokeredCallableStatement newBrokeredStatement(BrokeredStatementControl brokeredStatementControl, String string) throws SQLException {
        try {
            return new BrokeredCallableStatement40(brokeredStatementControl, string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            return this.getRealConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final boolean isWrapperFor(Class<?> clazz) throws SQLException {
        try {
            if (this.getRealConnection().isClosed()) {
                throw this.noCurrentConnection();
            }
            return clazz.isInstance(this);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public final <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            if (this.getRealConnection().isClosed()) {
                throw this.noCurrentConnection();
            }
            try {
                return clazz.cast(this);
            }
            catch (ClassCastException classCastException) {
                throw this.getExceptionFactory().getSQLException("XJ128.S", null, null, new Object[]{clazz});
            }
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (!this.isClosed) {
            ((EngineConnection40)this.getRealConnection()).abort(executor);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            return ((EngineConnection40)this.getRealConnection()).getNetworkTimeout();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        try {
            ((EngineConnection40)this.getRealConnection()).setNetworkTimeout(executor, n);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }
}

