/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Preconditions {
    public static void checkArgument(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl Object object) {
        if (!bl) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string, int n) {
        if (!bl) {
            throw new IllegalArgumentException(Preconditions.format(string, n));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string, long l) {
        if (!bl) {
            throw new IllegalArgumentException(Preconditions.format(string, l));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string, @NullableDecl Object object) {
        if (!bl) {
            throw new IllegalArgumentException(Preconditions.format(string, object));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string, @NullableDecl Object object, int n) {
        if (!bl) {
            throw new IllegalArgumentException(Preconditions.format(string, object, n));
        }
    }

    public static void checkArgument(boolean bl, @NullableDecl String string, @NullableDecl Object object, @NullableDecl Object object2) {
        if (!bl) {
            throw new IllegalArgumentException(Preconditions.format(string, object, object2));
        }
    }

    public static void checkState(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean bl, @NullableDecl Object object) {
        if (!bl) {
            throw new IllegalStateException(String.valueOf(object));
        }
    }

    public static void checkState(boolean bl, @NullableDecl String string, @NullableDecl Object object) {
        if (!bl) {
            throw new IllegalStateException(Preconditions.format(string, object));
        }
    }

    @CanIgnoreReturnValue
    public static Object checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    @CanIgnoreReturnValue
    public static Object checkNotNull(Object object, @NullableDecl Object object2) {
        if (object == null) {
            throw new NullPointerException(String.valueOf(object2));
        }
        return object;
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int n, int n2) {
        return Preconditions.checkElementIndex(n, n2, "index");
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int n, int n2, @NullableDecl String string) {
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(n, n2, string));
        }
        return n;
    }

    private static String badElementIndex(int n, int n2, @NullableDecl String string) {
        if (n < 0) {
            return Preconditions.format("%s (%s) must not be negative", string, n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("negative size: " + n2);
        }
        return Preconditions.format("%s (%s) must be less than size (%s)", string, n, n2);
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int n, int n2) {
        return Preconditions.checkPositionIndex(n, n2, "index");
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int n, int n2, @NullableDecl String string) {
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(n, n2, string));
        }
        return n;
    }

    private static String badPositionIndex(int n, int n2, @NullableDecl String string) {
        if (n < 0) {
            return Preconditions.format("%s (%s) must not be negative", string, n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("negative size: " + n2);
        }
        return Preconditions.format("%s (%s) must not be greater than size (%s)", string, n, n2);
    }

    public static void checkPositionIndexes(int n, int n2, int n3) {
        if (n < 0 || n2 < n || n2 > n3) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(n, n2, n3));
        }
    }

    private static String badPositionIndexes(int n, int n2, int n3) {
        if (n < 0 || n > n3) {
            return Preconditions.badPositionIndex(n, n3, "start index");
        }
        if (n2 < 0 || n2 > n3) {
            return Preconditions.badPositionIndex(n2, n3, "end index");
        }
        return Preconditions.format("end index (%s) must not be less than start index (%s)", n2, n);
    }

    static String format(@NullableDecl String string, Object ... objectArray) {
        int n;
        Object[] objectArray2;
        string = String.valueOf(string);
        if (objectArray == null) {
            Object[] objectArray3 = new Object[1];
            objectArray2 = objectArray3;
            objectArray3[0] = "(Object[])null";
        } else {
            objectArray2 = objectArray;
        }
        objectArray = objectArray2;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16 * objectArray.length);
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length && (n = string.indexOf("%s", n2)) != -1) {
            stringBuilder.append(string, n2, n);
            stringBuilder.append(objectArray[n3++]);
            n2 = n + 2;
        }
        stringBuilder.append(string, n2, string.length());
        if (n3 < objectArray.length) {
            stringBuilder.append(" [");
            stringBuilder.append(objectArray[n3++]);
            while (n3 < objectArray.length) {
                stringBuilder.append(", ");
                stringBuilder.append(objectArray[n3++]);
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }
}

