/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bt747.j2se.app.map;

import gps.log.GPSRecord;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public final class BT747TrackRenderer {
    private static final BT747TrackRenderer instance = new BT747TrackRenderer();
    private Color color = Color.BLUE;

    public static BT747TrackRenderer getInstance() {
        return instance;
    }

    public final void paintTrack(Graphics2D graphics2D, JXMapViewer jXMapViewer, Collection<GPSRecord> collection) {
        if (collection.size() > 0) {
            Rectangle2D rectangle2D = jXMapViewer.getViewportBounds();
            double d = ((Rectangle)rectangle2D).getX();
            rectangle2D = new Rectangle2D.Double(d, ((Rectangle)rectangle2D).getY(), ((Rectangle)rectangle2D).getWidth(), ((Rectangle)rectangle2D).getHeight());
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(1.5f));
            graphics2D.setPaint(this.color);
            GeneralPath generalPath = new GeneralPath(1, collection.size());
            Point2D point2D = null;
            boolean bl = true;
            boolean bl2 = false;
            double d2 = 0.0;
            double d3 = 0.0;
            for (GPSRecord gPSRecord : collection) {
                float f;
                if (!gPSRecord.hasPosition()) continue;
                Point2D point2D2 = jXMapViewer.getTileFactory().geoToPixel(new GeoPosition(gPSRecord.getLatitude(), gPSRecord.getLongitude()), jXMapViewer.getZoom());
                boolean bl3 = true;
                if (rectangle2D.contains(point2D2)) {
                    d2 = rectangle2D.getX();
                    d3 = rectangle2D.getY();
                } else {
                    bl3 = false;
                }
                if (point2D != null && !bl2 && bl3) {
                    float f2 = (float)(point2D.getX() - d2);
                    f = (float)(point2D.getY() - d3);
                    if (bl) {
                        generalPath.moveTo(f2, f);
                        bl = false;
                    } else {
                        generalPath.lineTo(f2, f);
                    }
                }
                if (bl3) {
                    point2D = null;
                }
                if (bl3 || bl2) {
                    point2D = null;
                    float f3 = (float)(point2D2.getX() - d2);
                    f = (float)(point2D2.getY() - d3);
                    if (bl) {
                        generalPath.moveTo(f3, f);
                        bl = false;
                    } else {
                        generalPath.lineTo(f3, f);
                    }
                }
                if (bl2 && !bl3 && point2D == null) {
                    graphics2D.draw(generalPath);
                    generalPath = new GeneralPath(1, collection.size());
                    bl = true;
                }
                point2D = point2D2;
                bl2 = bl3;
            }
            graphics2D.draw(generalPath);
            graphics2D.setStroke(stroke);
        }
    }

    public final void setColor(Color color) {
        this.color = color;
    }
}

