/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
if (typeof document !== 'undefined' && !document.elementsFromPoint) {
    document.elementsFromPoint = elementsFromPoint;
}
/*tslint:disable*/
/**
 * Polyfill for `elementsFromPoint`
 *
 * https://developer.mozilla.org/en-US/docs/Web/API/Document/elementsFromPoint
 * https://gist.github.com/iddan/54d5d9e58311b0495a91bf06de661380
 * https://gist.github.com/oslego/7265412
 * @param {?} x
 * @param {?} y
 * @return {?}
 */
export function elementsFromPoint(x, y) {
    /** @type {?} */
    var elements = [];
    /** @type {?} */
    var previousPointerEvents = [];
    /** @type {?} */
    var current;
    // TODO: window.getComputedStyle should be used with inferred type (Element)
    /** @type {?} */
    var i;
    /** @type {?} */
    var d;
    //if (document === undefined) return elements;
    // get all elements via elementFromPoint, and remove them from hit-testing in order
    while ((current = document.elementFromPoint(x, y)) && elements.indexOf(current) === -1 && current != null) {
        // push the element and its current style
        elements.push(current);
        previousPointerEvents.push({
            value: current.style.getPropertyValue('pointer-events'),
            priority: current.style.getPropertyPriority('pointer-events')
        });
        // add "pointer-events: none", to get to the underlying element
        current.style.setProperty('pointer-events', 'none', 'important');
    }
    // restore the previous pointer-events values
    for (i = previousPointerEvents.length; (d = previousPointerEvents[--i]);) {
        elements[i].style.setProperty('pointer-events', d.value ? d.value : '', d.priority);
    }
    // return our results
    return elements;
}
//# sourceMappingURL=data:application/json;base64,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