/*
 * Decompiled with CFR 0.152.
 */
package org.grails.encoder;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.grails.encoder.Encoder;
import org.grails.encoder.EncodingState;
import org.grails.encoder.EncodingStateImpl;
import org.grails.encoder.EncodingStateRegistry;
import org.grails.encoder.StreamingEncoder;
import org.grails.encoder.impl.BasicCodecLookup;
import org.grails.encoder.impl.NoneEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultEncodingStateRegistry
implements EncodingStateRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEncodingStateRegistry.class);
    private Map<Encoder, Map<Long, WeakReference<CharSequence>>> encodedCharSequencesForEncoder = new HashMap<Encoder, Map<Long, WeakReference<CharSequence>>>();
    public static final StreamingEncoder NONE_ENCODER = BasicCodecLookup.NONE_ENCODER;

    private long calculateKey(CharSequence charSequence) {
        int contentHashCode = charSequence.hashCode();
        int identityHashCode = System.identityHashCode(charSequence);
        return (long)contentHashCode << 32 | (long)identityHashCode & 0xFFFFFFFFL;
    }

    private Map<Long, WeakReference<CharSequence>> getEncodedCharSequencesForEncoder(Encoder encoder) {
        Map<Long, WeakReference<CharSequence>> encodedCharSequences = this.encodedCharSequencesForEncoder.get(encoder);
        if (encodedCharSequences == null) {
            encodedCharSequences = new HashMap<Long, WeakReference<CharSequence>>();
            this.encodedCharSequencesForEncoder.put(encoder, encodedCharSequences);
        }
        return encodedCharSequences;
    }

    @Override
    public EncodingState getEncodingStateFor(CharSequence string) {
        Long key = this.calculateKey(string);
        Set<Encoder> result = null;
        for (Map.Entry<Encoder, Map<Long, WeakReference<CharSequence>>> entry : this.encodedCharSequencesForEncoder.entrySet()) {
            WeakReference<CharSequence> charSequenceReference = entry.getValue().get(key);
            if (charSequenceReference == null || string != charSequenceReference.get()) continue;
            if (result == null) {
                result = Collections.singleton(entry.getKey());
                continue;
            }
            if (result.size() == 1) {
                result = new HashSet<Encoder>(result);
            }
            result.add(entry.getKey());
        }
        return result != null ? new EncodingStateImpl(result, null) : EncodingStateImpl.UNDEFINED_ENCODING_STATE;
    }

    @Override
    public boolean isEncodedWith(Encoder encoder, CharSequence string) {
        return this.getEncodedCharSequencesForEncoder(encoder).containsKey(this.calculateKey(string));
    }

    @Override
    public void registerEncodedWith(Encoder encoder, CharSequence escaped) {
        WeakReference<CharSequence> previousValue = this.getEncodedCharSequencesForEncoder(encoder).put(this.calculateKey(escaped), new WeakReference<CharSequence>(escaped));
        if (previousValue != null && previousValue.get() != escaped) {
            LOG.warn("Hash collision for encoded value between '{}' and '{}', encoder is {}", new Object[]{escaped, previousValue.get(), encoder});
        }
    }

    @Override
    public boolean shouldEncodeWith(Encoder encoderToApply, CharSequence string) {
        if (DefaultEncodingStateRegistry.isNoneEncoder(encoderToApply)) {
            return false;
        }
        EncodingState encodingState = this.getEncodingStateFor(string);
        return DefaultEncodingStateRegistry.shouldEncodeWith(encoderToApply, encodingState);
    }

    public static boolean shouldEncodeWith(Encoder encoderToApply, EncodingState currentEncodingState) {
        if (DefaultEncodingStateRegistry.isNoneEncoder(encoderToApply)) {
            return false;
        }
        if (currentEncodingState != null && currentEncodingState.getEncoders() != null) {
            for (Encoder encoder : currentEncodingState.getEncoders()) {
                if (!DefaultEncodingStateRegistry.isPreviousEncoderSafeOrEqual(encoderToApply, encoder)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNoneEncoder(Encoder encoderToApply) {
        return encoderToApply == null || encoderToApply == NONE_ENCODER || encoderToApply.getClass() == NoneEncoder.class;
    }

    public static boolean isPreviousEncoderSafeOrEqual(Encoder encoderToApply, Encoder previousEncoder) {
        return previousEncoder == encoderToApply || !encoderToApply.isApplyToSafelyEncoded() && previousEncoder.isSafe() && encoderToApply.isSafe() || previousEncoder.getCodecIdentifier().isEquivalent(encoderToApply.getCodecIdentifier());
    }
}

