/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import org.apache.tomcat.dbcp.dbcp.AbandonedTrace;
import org.apache.tomcat.dbcp.dbcp.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp.DelegatingResultSet;
import org.apache.tomcat.util.compat.JreCompat;

public class DelegatingDatabaseMetaData
extends AbandonedTrace
implements DatabaseMetaData {
    protected DatabaseMetaData _meta;
    protected DelegatingConnection _conn = null;

    public DelegatingDatabaseMetaData(DelegatingConnection delegatingConnection, DatabaseMetaData databaseMetaData) {
        this._conn = delegatingConnection;
        this._meta = databaseMetaData;
    }

    public DatabaseMetaData getDelegate() {
        return this._meta;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        DatabaseMetaData databaseMetaData = this.getInnermostDelegate();
        if (databaseMetaData == null) {
            return false;
        }
        if (object instanceof DelegatingDatabaseMetaData) {
            DelegatingDatabaseMetaData delegatingDatabaseMetaData = (DelegatingDatabaseMetaData)object;
            return databaseMetaData.equals(delegatingDatabaseMetaData.getInnermostDelegate());
        }
        return databaseMetaData.equals(object);
    }

    public int hashCode() {
        DatabaseMetaData databaseMetaData = this.getInnermostDelegate();
        if (databaseMetaData == null) {
            return 0;
        }
        return databaseMetaData.hashCode();
    }

    public DatabaseMetaData getInnermostDelegate() {
        DatabaseMetaData databaseMetaData = this._meta;
        while (databaseMetaData != null && databaseMetaData instanceof DelegatingDatabaseMetaData) {
            if (this != (databaseMetaData = ((DelegatingDatabaseMetaData)databaseMetaData).getDelegate())) continue;
            return null;
        }
        return databaseMetaData;
    }

    protected void handleException(SQLException sQLException) throws SQLException {
        if (this._conn == null) {
            throw sQLException;
        }
        this._conn.handleException(sQLException);
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        try {
            return this._meta.allProceduresAreCallable();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        try {
            return this._meta.allTablesAreSelectable();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        try {
            return this._meta.dataDefinitionCausesTransactionCommit();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        try {
            return this._meta.dataDefinitionIgnoredInTransactions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean deletesAreDetected(int n) throws SQLException {
        try {
            return this._meta.deletesAreDetected(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        try {
            return this._meta.doesMaxRowSizeIncludeBlobs();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getAttributes(string, string2, string3, string4));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getBestRowIdentifier(string, string2, string3, n, bl));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        try {
            return this._meta.getCatalogSeparator();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        try {
            return this._meta.getCatalogTerm();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getCatalogs());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getColumnPrivileges(string, string2, string3, string4));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getColumns(string, string2, string3, string4));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._conn;
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getCrossReference(string, string2, string3, string4, string5, string6));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        try {
            return this._meta.getDatabaseMajorVersion();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        try {
            return this._meta.getDatabaseMinorVersion();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        try {
            return this._meta.getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        try {
            return this._meta.getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        try {
            return this._meta.getDefaultTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getDriverMajorVersion() {
        return this._meta.getDriverMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return this._meta.getDriverMinorVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        try {
            return this._meta.getDriverName();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getDriverVersion() throws SQLException {
        try {
            return this._meta.getDriverVersion();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getExportedKeys(string, string2, string3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        try {
            return this._meta.getExtraNameCharacters();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        try {
            return this._meta.getIdentifierQuoteString();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getImportedKeys(string, string2, string3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getIndexInfo(string, string2, string3, bl, bl2));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        try {
            return this._meta.getJDBCMajorVersion();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        try {
            return this._meta.getJDBCMinorVersion();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        try {
            return this._meta.getMaxBinaryLiteralLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        try {
            return this._meta.getMaxCatalogNameLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        try {
            return this._meta.getMaxCharLiteralLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        try {
            return this._meta.getMaxColumnNameLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        try {
            return this._meta.getMaxColumnsInGroupBy();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        try {
            return this._meta.getMaxColumnsInIndex();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        try {
            return this._meta.getMaxColumnsInOrderBy();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        try {
            return this._meta.getMaxColumnsInSelect();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        try {
            return this._meta.getMaxColumnsInTable();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxConnections() throws SQLException {
        try {
            return this._meta.getMaxConnections();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        try {
            return this._meta.getMaxCursorNameLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        try {
            return this._meta.getMaxIndexLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        try {
            return this._meta.getMaxProcedureNameLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        try {
            return this._meta.getMaxRowSize();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        try {
            return this._meta.getMaxSchemaNameLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        try {
            return this._meta.getMaxStatementLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxStatements() throws SQLException {
        try {
            return this._meta.getMaxStatements();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        try {
            return this._meta.getMaxTableNameLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        try {
            return this._meta.getMaxTablesInSelect();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        try {
            return this._meta.getMaxUserNameLength();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        try {
            return this._meta.getNumericFunctions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getPrimaryKeys(string, string2, string3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getProcedureColumns(string, string2, string3, string4));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        try {
            return this._meta.getProcedureTerm();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getProcedures(string, string2, string3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this._meta.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        try {
            return this._meta.getSQLKeywords();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public int getSQLStateType() throws SQLException {
        try {
            return this._meta.getSQLStateType();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        try {
            return this._meta.getSchemaTerm();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getSchemas());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        try {
            return this._meta.getSearchStringEscape();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getStringFunctions() throws SQLException {
        try {
            return this._meta.getStringFunctions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getSuperTables(string, string2, string3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getSuperTypes(string, string2, string3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        try {
            return this._meta.getSystemFunctions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getTablePrivileges(string, string2, string3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getTableTypes());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getTables(string, string2, string3, stringArray));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        try {
            return this._meta.getTimeDateFunctions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getTypeInfo());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getUDTs(string, string2, string3, nArray));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getURL() throws SQLException {
        try {
            return this._meta.getURL();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public String getUserName() throws SQLException {
        try {
            return this._meta.getUserName();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getVersionColumns(string, string2, string3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public boolean insertsAreDetected(int n) throws SQLException {
        try {
            return this._meta.insertsAreDetected(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        try {
            return this._meta.isCatalogAtStart();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this._meta.isReadOnly();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        try {
            return this._meta.locatorsUpdateCopy();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        try {
            return this._meta.nullPlusNonNullIsNull();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        try {
            return this._meta.nullsAreSortedAtEnd();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        try {
            return this._meta.nullsAreSortedAtStart();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        try {
            return this._meta.nullsAreSortedHigh();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        try {
            return this._meta.nullsAreSortedLow();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean othersDeletesAreVisible(int n) throws SQLException {
        try {
            return this._meta.othersDeletesAreVisible(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean othersInsertsAreVisible(int n) throws SQLException {
        try {
            return this._meta.othersInsertsAreVisible(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        try {
            return this._meta.othersUpdatesAreVisible(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean ownDeletesAreVisible(int n) throws SQLException {
        try {
            return this._meta.ownDeletesAreVisible(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean ownInsertsAreVisible(int n) throws SQLException {
        try {
            return this._meta.ownInsertsAreVisible(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        try {
            return this._meta.ownUpdatesAreVisible(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        try {
            return this._meta.storesLowerCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        try {
            return this._meta.storesLowerCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        try {
            return this._meta.storesMixedCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return this._meta.storesMixedCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        try {
            return this._meta.storesUpperCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        try {
            return this._meta.storesUpperCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        try {
            return this._meta.supportsANSI92EntryLevelSQL();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        try {
            return this._meta.supportsANSI92FullSQL();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        try {
            return this._meta.supportsANSI92IntermediateSQL();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        try {
            return this._meta.supportsAlterTableWithAddColumn();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        try {
            return this._meta.supportsAlterTableWithDropColumn();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        try {
            return this._meta.supportsBatchUpdates();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        try {
            return this._meta.supportsCatalogsInDataManipulation();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        try {
            return this._meta.supportsCatalogsInIndexDefinitions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        try {
            return this._meta.supportsCatalogsInPrivilegeDefinitions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        try {
            return this._meta.supportsCatalogsInProcedureCalls();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        try {
            return this._meta.supportsCatalogsInTableDefinitions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        try {
            return this._meta.supportsColumnAliasing();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        try {
            return this._meta.supportsConvert();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsConvert(int n, int n2) throws SQLException {
        try {
            return this._meta.supportsConvert(n, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        try {
            return this._meta.supportsCoreSQLGrammar();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        try {
            return this._meta.supportsCorrelatedSubqueries();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        try {
            return this._meta.supportsDataDefinitionAndDataManipulationTransactions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        try {
            return this._meta.supportsDataManipulationTransactionsOnly();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        try {
            return this._meta.supportsDifferentTableCorrelationNames();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        try {
            return this._meta.supportsExpressionsInOrderBy();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        try {
            return this._meta.supportsExtendedSQLGrammar();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        try {
            return this._meta.supportsFullOuterJoins();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        try {
            return this._meta.supportsGetGeneratedKeys();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        try {
            return this._meta.supportsGroupBy();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        try {
            return this._meta.supportsGroupByBeyondSelect();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        try {
            return this._meta.supportsGroupByUnrelated();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        try {
            return this._meta.supportsIntegrityEnhancementFacility();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        try {
            return this._meta.supportsLikeEscapeClause();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        try {
            return this._meta.supportsLimitedOuterJoins();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        try {
            return this._meta.supportsMinimumSQLGrammar();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        try {
            return this._meta.supportsMixedCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            return this._meta.supportsMixedCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        try {
            return this._meta.supportsMultipleOpenResults();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        try {
            return this._meta.supportsMultipleResultSets();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        try {
            return this._meta.supportsMultipleTransactions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        try {
            return this._meta.supportsNamedParameters();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        try {
            return this._meta.supportsNonNullableColumns();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        try {
            return this._meta.supportsOpenCursorsAcrossCommit();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        try {
            return this._meta.supportsOpenCursorsAcrossRollback();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        try {
            return this._meta.supportsOpenStatementsAcrossCommit();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        try {
            return this._meta.supportsOpenStatementsAcrossRollback();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        try {
            return this._meta.supportsOrderByUnrelated();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        try {
            return this._meta.supportsOuterJoins();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        try {
            return this._meta.supportsPositionedDelete();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        try {
            return this._meta.supportsPositionedUpdate();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        try {
            return this._meta.supportsResultSetConcurrency(n, n2);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsResultSetHoldability(int n) throws SQLException {
        try {
            return this._meta.supportsResultSetHoldability(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsResultSetType(int n) throws SQLException {
        try {
            return this._meta.supportsResultSetType(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        try {
            return this._meta.supportsSavepoints();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        try {
            return this._meta.supportsSchemasInDataManipulation();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        try {
            return this._meta.supportsSchemasInIndexDefinitions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        try {
            return this._meta.supportsSchemasInPrivilegeDefinitions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        try {
            return this._meta.supportsSchemasInProcedureCalls();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        try {
            return this._meta.supportsSchemasInTableDefinitions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        try {
            return this._meta.supportsSelectForUpdate();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        try {
            return this._meta.supportsStatementPooling();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        try {
            return this._meta.supportsStoredProcedures();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        try {
            return this._meta.supportsSubqueriesInComparisons();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        try {
            return this._meta.supportsSubqueriesInExists();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        try {
            return this._meta.supportsSubqueriesInIns();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        try {
            return this._meta.supportsSubqueriesInQuantifieds();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        try {
            return this._meta.supportsTableCorrelationNames();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        try {
            return this._meta.supportsTransactionIsolationLevel(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        try {
            return this._meta.supportsTransactions();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        try {
            return this._meta.supportsUnion();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        try {
            return this._meta.supportsUnionAll();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean updatesAreDetected(int n) throws SQLException {
        try {
            return this._meta.updatesAreDetected(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        try {
            return this._meta.usesLocalFilePerTable();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        try {
            return this._meta.usesLocalFiles();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isAssignableFrom(this.getClass()) || this._meta.isWrapperFor(clazz);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        if (clazz.isAssignableFrom(this._meta.getClass())) {
            return clazz.cast(this._meta);
        }
        return this._meta.unwrap(clazz);
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        try {
            return this._meta.getRowIdLifetime();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getSchemas(string, string2));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        try {
            return this._meta.autoCommitFailureClosesAllResultSets();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        try {
            return this._meta.supportsStoredFunctionsUsingCallSyntax();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getClientInfoProperties());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getFunctions(string, string2, string3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        this._conn.checkOpen();
        try {
            return DelegatingResultSet.wrapResultSet(this._conn, this._meta.getFunctionColumns(string, string2, string3, string4));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        this._conn.checkOpen();
        try {
            return JreCompat.getInstance().getPseudoColumns(this._meta, string, string2, string3, string4);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        this._conn.checkOpen();
        try {
            return JreCompat.getInstance().generatedKeyAlwaysReturned(this._meta);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            throw new AssertionError();
        }
    }
}

