/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.icons.Icons;

public abstract class FilterComponent
implements CommonConstants {
    public static FilterComponent create(boolean bl, boolean bl2) {
        return new Impl(bl, bl2);
    }

    public abstract JComponent getComponent();

    public abstract void setFilterValue(String var1);

    public abstract String getFilterValue();

    public abstract void addFilterType(String var1, int var2);

    public abstract void setFilterType(int var1);

    public abstract int getFilterType();

    public abstract void setFilter(String var1, int var2);

    public abstract void setHint(String var1);

    public abstract String getHint();

    public abstract void addChangeListener(ChangeListener var1);

    public abstract void removeChangeListener(ChangeListener var1);

    public static String[] getFilterValues(String string) {
        return string == null ? null : string.trim().split(" +");
    }

    protected FilterComponent() {
    }

    private static class Impl
    extends FilterComponent {
        private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.components.Bundle");
        private static final String STRING_FILTER_CONTAINS = messages.getString("FilterComponent_FilterContains");
        private static final String STRING_FILTER_NOT_CONTAINS = messages.getString("FilterComponent_FilterNotContains");
        private static final String STRING_FILTER_REGEXP = messages.getString("FilterComponent_FilterRegexp");
        private static final String FILTER_TYPE_TOOLTIP = messages.getString("FilterComponent_FilterTypeToolTip");
        private static final String FILTER_TOOLTIP = messages.getString("FilterComponent_FilterValueToolTip");
        private static final String SUBMIT_TOOLTIP = messages.getString("FilterComponent_SetFilterButtonToolTip");
        private static final String CLEAR_TOOLTIP = messages.getString("FilterComponent_ClearFilterButtonToolTip");
        private static final String ACCESS_NAME = messages.getString("FilterComponent_AccessName");
        private static final String ACCESS_DESCR = messages.getString("FilterComponent_AccessDescr");
        private static final String FILTER_HINT = messages.getString("FilterComponent_FilterHint");
        private static final String FILTER_EMPTY = "";
        private final Set<ChangeListener> listeners = new HashSet<ChangeListener>();
        private final List<String> filterTypeNames = new ArrayList<String>();
        private final List<Integer> filterTypes = new ArrayList<Integer>();
        private final boolean toLowerCase;
        private String filterValue = "";
        private int filterType = 0;
        private String filterHint;
        private final JComponent component;
        private final FilterCombo filterCombo;
        private boolean suppressEvents = false;

        Impl(boolean bl, boolean bl2) {
            this.toLowerCase = bl2;
            this.filterCombo = new FilterCombo();
            this.filterCombo.setToolTipText(FILTER_TOOLTIP);
            this.component = new JPanel(new BorderLayout()){

                @Override
                public void setBounds(int n, int n2, int n3, int n4) {
                    if (UIUtils.isAquaLookAndFeel()) {
                        n3 += 2;
                    }
                    super.setBounds(n, n2, n3, n4);
                }
            };
            this.component.setOpaque(false);
            if (UIUtils.isWindowsLookAndFeel() || UIUtils.isMetalLookAndFeel()) {
                Insets insets = this.filterCombo.getInsets();
                this.component.setBorder(BorderFactory.createEmptyBorder(0, -insets.left, 0, -insets.right));
            } else if (UIUtils.isGTKLookAndFeel()) {
                this.component.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
            }
            this.component.add((Component)this.filterCombo, "Center");
            if (bl) {
                this.addFilterType(STRING_FILTER_CONTAINS, 20);
                this.addFilterType(STRING_FILTER_NOT_CONTAINS, 25);
                this.addFilterType(STRING_FILTER_REGEXP, 50);
            }
        }

        @Override
        public JComponent getComponent() {
            return this.component;
        }

        @Override
        public void setFilterValue(String string) {
            String string2 = string = string == null ? string : string.trim();
            if (this.filterValue.equals(string)) {
                return;
            }
            this.filterValue = string;
            this.filterCombo.setText(string);
        }

        @Override
        public String getFilterValue() {
            return this.toLowerCase && this.isCaseInsensitiveFilter() ? this.filterValue.toLowerCase() : this.filterValue;
        }

        private boolean isCaseInsensitiveFilter() {
            return this.filterType == 20 || this.filterType == 25;
        }

        @Override
        public void addFilterType(String string, int n) {
            this.filterTypeNames.add(string);
            this.filterTypes.add(n);
            if (this.filterType == 0) {
                this.setFilterType(n);
            }
        }

        @Override
        public void setFilterType(int n) {
            if (n != 0) {
                this.filterTypeChanged(n);
            }
        }

        @Override
        public int getFilterType() {
            return this.getFilterValue().isEmpty() ? 0 : this.filterType;
        }

        @Override
        public void setFilter(String string, int n) {
            if (this.filterValue.equals(string) && this.filterType == n) {
                return;
            }
            this.suppressEvents = true;
            try {
                this.setFilterType(n);
                this.setFilterValue(string);
            }
            finally {
                this.suppressEvents = false;
            }
            this.fireChange();
        }

        @Override
        public void setHint(String string) {
            if (this.filterHint != null && this.filterHint.equals(string)) {
                return;
            }
            this.filterHint = string;
            this.setHintImpl();
        }

        private void setHintImpl() {
            String string = this.filterTypeNames.get(this.filterTypes.indexOf(this.filterType));
            this.filterCombo.setHint(MessageFormat.format(FILTER_HINT, this.filterHint, string));
        }

        @Override
        public String getHint() {
            return this.filterHint;
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        private void filterValueChanged(String string) {
            if (this.filterValue.equals(string)) {
                return;
            }
            this.filterValue = string;
            this.fireChange();
        }

        private void filterTypeChanged(int n) {
            if (this.filterType == n) {
                return;
            }
            this.filterType = n;
            this.setHintImpl();
            this.fireChange();
        }

        private void fireChange() {
            if (this.suppressEvents) {
                return;
            }
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener changeListener : this.listeners) {
                changeListener.stateChanged(changeEvent);
            }
        }

        private void submitFilter() {
            String string = this.filterCombo.getText();
            this.filterCombo.addItem(string);
            this.filterCombo.setSelectedItem(string);
        }

        private void clearFilter() {
            this.filterCombo.setSelectedItem(FILTER_EMPTY);
        }

        private void showPopup() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            for (int i = 0; i < this.filterTypeNames.size(); ++i) {
                final int n = this.filterTypes.get(i);
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.filterTypeNames.get(i)){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        Impl.this.setFilterType(n);
                    }
                };
                jRadioButtonMenuItem.setSelected(n == this.filterType);
                jPopupMenu.add(jRadioButtonMenuItem);
            }
            jPopupMenu.show(this.filterCombo, 0, this.filterCombo.getHeight() - this.filterCombo.getInsets().bottom);
        }

        private static class IconButton
        extends JButton {
            public IconButton(Icon icon) {
                super(icon);
                this.setOpaque(false);
                this.setRolloverEnabled(true);
                this.setMargin(new Insets(0, 0, 0, 0));
                this.setBorderPainted(false);
                this.setContentAreaFilled(false);
                this.setRequestFocusEnabled(false);
                this.setDefaultCapable(false);
                this.setCursor(Cursor.getDefaultCursor());
            }
        }

        private final class FilterComboEditor
        extends JTextField
        implements ComboBoxEditor {
            private final IconButton filterButton;
            private final IconButton confirmButton;
            private final IconButton clearButton;
            private final JPanel buttonsPanel;
            private final JLabel hintLabel;

            public FilterComboEditor(ComboBoxEditor comboBoxEditor) {
                this.filterButton = new IconButton(Icons.getIcon((String)"GeneralIcons.Filter")){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        Impl.this.showPopup();
                    }

                    @Override
                    public String getToolTipText() {
                        int n = Impl.this.filterTypes.indexOf(Impl.this.filterType);
                        return n != -1 ? MessageFormat.format(FILTER_TYPE_TOOLTIP, Impl.this.filterTypeNames.get(n)) : null;
                    }
                };
                this.filterButton.setRolloverIcon(Icons.getIcon((String)"GeneralIcons.FilterHighl"));
                this.filterButton.setToolTipText(Impl.FILTER_EMPTY);
                this.confirmButton = new IconButton(Icons.getIcon((String)"GeneralIcons.SetFilter")){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        Impl.this.submitFilter();
                    }
                };
                this.confirmButton.setRolloverIcon(Icons.getIcon((String)"GeneralIcons.SetFilterHighl"));
                this.confirmButton.setToolTipText(SUBMIT_TOOLTIP);
                this.clearButton = new IconButton(Icons.getIcon((String)"GeneralIcons.ClearFilter")){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        Impl.this.clearFilter();
                    }
                };
                this.clearButton.setRolloverIcon(Icons.getIcon((String)"GeneralIcons.ClearFilterHighl"));
                this.clearButton.setToolTipText(CLEAR_TOOLTIP);
                this.buttonsPanel = new JPanel(new BorderLayout(0, 0));
                this.buttonsPanel.setOpaque(false);
                this.buttonsPanel.add((Component)this.confirmButton, "West");
                this.buttonsPanel.add((Component)this.clearButton, "East");
                this.getAccessibleContext().setAccessibleName(ACCESS_NAME);
                this.getAccessibleContext().setAccessibleDescription(ACCESS_DESCR);
                this.setLayout(null);
                this.add(this.filterButton);
                this.add(this.buttonsPanel);
                this.tweakAppearance((JComponent)comboBoxEditor.getEditorComponent());
                this.hintLabel = new JLabel(){

                    @Override
                    protected void paintBorder(Graphics graphics) {
                    }
                };
                this.hintLabel.setOpaque(false);
                this.hintLabel.setEnabled(false);
                this.hintLabel.setBorder(this.getBorder());
                this.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        FilterComboEditor.this.textChanged();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        FilterComboEditor.this.textChanged();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        FilterComboEditor.this.textChanged();
                    }
                });
                this.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        FilterComboEditor.this.repaint();
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        FilterComboEditor.this.repaint();
                    }
                });
                this.textChanged();
            }

            private void tweakAppearance(JComponent jComponent) {
                this.setName("ComboBox.textField");
                if (UIUtils.isNimbusLookAndFeel() || UIUtils.isAquaLookAndFeel()) {
                    this.filterButton.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 4));
                } else if (UIUtils.isWindowsLookAndFeel()) {
                    this.filterButton.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 1));
                } else {
                    this.filterButton.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 2));
                }
                this.confirmButton.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 4));
                this.clearButton.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 4));
                int n = this.filterButton.getPreferredSize().width + 2;
                if (UIUtils.isGTKLookAndFeel()) {
                    n -= 4;
                } else if (UIUtils.isAquaLookAndFeel()) {
                    n -= 8;
                }
                int n2 = this.buttonsPanel.getPreferredSize().width + 2;
                if (UIUtils.isAquaLookAndFeel()) {
                    n2 += 10;
                } else if (UIUtils.isWindowsLookAndFeel()) {
                    n2 -= 2;
                }
                Border border = BorderFactory.createEmptyBorder(0, n, 0, n2);
                if (UIUtils.isNimbusLookAndFeel()) {
                    this.setBorder(border);
                } else {
                    this.setBorder(jComponent.getBorder());
                    UIUtils.addBorder(this, border);
                }
                if (UIUtils.isMetalLookAndFeel()) {
                    this.setPreferredSize(jComponent.getPreferredSize());
                }
            }

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (!this.isFocusOwner() && this.getText().isEmpty()) {
                    this.hintLabel.paint(graphics);
                }
            }

            @Override
            public void setBounds(int n, int n2, int n3, int n4) {
                int n5 = UIUtils.isAquaLookAndFeel() ? 14 : 0;
                super.setBounds(n, n2, n3 + n5, n4);
                this.hintLabel.setBounds(n, n2, n3 + n5, n4);
            }

            @Override
            public void doLayout() {
                Dimension dimension = this.filterButton.getPreferredSize();
                this.filterButton.setBounds(0, 0, dimension.width, this.getHeight());
                int n = UIUtils.isAquaLookAndFeel() ? 14 : 0;
                int n2 = UIUtils.isAquaLookAndFeel() ? 5 + n : 0;
                dimension = this.buttonsPanel.getPreferredSize();
                this.buttonsPanel.setBounds(this.getWidth() - dimension.width - n2, 0, dimension.width, this.getHeight());
            }

            @Override
            public void processKeyEvent(KeyEvent keyEvent) {
                super.processKeyEvent(keyEvent);
                if (keyEvent.getID() != 401) {
                    return;
                }
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    Impl.this.submitFilter();
                } else if (n == 27) {
                    Impl.this.clearFilter();
                } else if (n == 525 || n == 121 && keyEvent.getModifiers() == 1) {
                    Impl.this.showPopup();
                }
            }

            @Override
            public boolean isOptimizedDrawingEnabled() {
                return false;
            }

            public void setHint(String string) {
                this.hintLabel.setText(string);
                this.repaint();
            }

            @Override
            public Component getEditorComponent() {
                return this;
            }

            @Override
            public void setItem(Object object) {
                this.setText(object == null ? Impl.FILTER_EMPTY : object.toString());
            }

            @Override
            public Object getItem() {
                return this.getText();
            }

            @Override
            public void selectAll() {
                super.selectAll();
                this.requestFocus();
            }

            @Override
            public void addActionListener(ActionListener actionListener) {
                super.addActionListener(actionListener);
            }

            @Override
            public void removeActionListener(ActionListener actionListener) {
                super.removeActionListener(actionListener);
            }

            public void textChanged() {
                String string = this.getText();
                this.confirmButton.setVisible(!string.equals(Impl.this.filterValue));
                this.clearButton.setVisible(!string.isEmpty());
            }
        }

        private final class FilterCombo
        extends JComboBox {
            public FilterCombo() {
                super(new DefaultComboBoxModel());
                this.setEditor(new FilterComboEditor(this.getEditor()));
                this.setEditable(true);
            }

            public void setHint(String string) {
                this.getEditorImpl().setHint(string);
            }

            public String getText() {
                return this.getEditorImpl().getItem().toString().trim();
            }

            public void setText(String string) {
                this.getEditorImpl().setItem(string);
            }

            @Override
            public void setSelectedItem(final Object object) {
                super.setSelectedItem(object);
                final FilterComboEditor filterComboEditor = this.getEditorImpl();
                filterComboEditor.setItem(object);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!FilterCombo.this.isPopupVisible()) {
                            filterComboEditor.requestFocusInWindow();
                            Impl.this.filterValueChanged(object.toString());
                            filterComboEditor.textChanged();
                        }
                    }
                });
            }

            @Override
            public Object getSelectedItem() {
                Object object = super.getSelectedItem();
                return object == null ? Impl.FILTER_EMPTY : object;
            }

            public void addItem(Object object) {
                String string;
                String string2 = string = object == null ? null : object.toString();
                if (string == null || string.isEmpty()) {
                    return;
                }
                DefaultComboBoxModel defaultComboBoxModel = this.getModelImpl();
                Object object2 = defaultComboBoxModel.getSelectedItem();
                int n = defaultComboBoxModel.getIndexOf(string);
                if (n > 0) {
                    defaultComboBoxModel.removeElement(string);
                }
                if (n != 0) {
                    defaultComboBoxModel.insertElementAt(string, 0);
                }
                defaultComboBoxModel.setSelectedItem(object2);
            }

            public DefaultComboBoxModel getModelImpl() {
                return (DefaultComboBoxModel)super.getModel();
            }

            public FilterComboEditor getEditorImpl() {
                return (FilterComboEditor)super.getEditor();
            }
        }
    }
}

