/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.cache.Content;
import org.apache.felix.framework.cache.ContentDirectoryContent;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.WeakZipFileFactory;

public class JarContent
implements Content {
    private static final int BUFSIZE = 4096;
    private static final transient String EMBEDDED_DIRECTORY = "-embedded";
    private static final transient String LIBRARY_DIRECTORY = "-lib";
    private final Logger m_logger;
    private final Map m_configMap;
    private final WeakZipFileFactory m_zipFactory;
    private final Object m_revisionLock;
    private final File m_rootDir;
    private final File m_file;
    private final WeakZipFileFactory.WeakZipFile m_zipFile;
    private final boolean m_isZipFileOwner;
    private Map m_nativeLibMap;

    public JarContent(Logger logger, Map configMap, WeakZipFileFactory zipFactory, Object revisionLock, File rootDir, File file, WeakZipFileFactory.WeakZipFile zipFile) {
        this.m_logger = logger;
        this.m_configMap = configMap;
        this.m_zipFactory = zipFactory;
        this.m_revisionLock = revisionLock;
        this.m_rootDir = rootDir;
        this.m_file = file;
        if (zipFile == null) {
            try {
                this.m_zipFile = this.m_zipFactory.create(this.m_file);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to open JAR file, probably deleted: " + ex.getMessage());
            }
        } else {
            this.m_zipFile = zipFile;
        }
        this.m_isZipFileOwner = zipFile == null;
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public void close() {
        try {
            if (this.m_isZipFileOwner) {
                this.m_zipFile.close();
            }
        }
        catch (Exception ex) {
            this.m_logger.log(1, "JarContent: Unable to close JAR file.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasEntry(String name) throws IllegalStateException {
        try {
            ZipEntry ze = this.m_zipFile.getEntry(name);
            boolean bl = ze != null;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public Enumeration<String> getEntries() {
        EntriesEnumeration e = new EntriesEnumeration(this.m_zipFile.entries());
        return e.hasMoreElements() ? e : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getEntryAsBytes(String name) throws IllegalStateException {
        InputStream is = null;
        ByteArrayOutputStream baos = null;
        try {
            ZipEntry ze = this.m_zipFile.getEntry(name);
            if (ze == null) {
                byte[] byArray = null;
                return byArray;
            }
            is = this.m_zipFile.getInputStream(ze);
            if (is == null) {
                byte[] byArray = null;
                return byArray;
            }
            baos = new ByteArrayOutputStream(4096);
            byte[] buf = new byte[4096];
            int n = 0;
            while ((n = is.read(buf, 0, buf.length)) >= 0) {
                baos.write(buf, 0, n);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            this.m_logger.log(1, "JarContent: Unable to read bytes for file " + name + " in ZIP file " + this.m_file.getAbsolutePath(), ex);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    @Override
    public InputStream getEntryAsStream(String name) throws IllegalStateException, IOException {
        InputStream is = null;
        try {
            ZipEntry ze = this.m_zipFile.getEntry(name);
            if (ze == null) {
                return null;
            }
            is = this.m_zipFile.getInputStream(ze);
            if (is == null) {
                return null;
            }
        }
        catch (Exception ex) {
            return null;
        }
        return is;
    }

    @Override
    public URL getEntryAsURL(String name) {
        try {
            return new URL("jar:" + this.m_file.toURI().toURL().toExternalForm() + "!/" + name);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Content getEntryAsContent(String entryName) {
        if (entryName.equals(".")) {
            return new JarContent(this.m_logger, this.m_configMap, this.m_zipFactory, this.m_revisionLock, this.m_rootDir, this.m_file, this.m_zipFile);
        }
        entryName = entryName.startsWith("/") ? entryName.substring(1) : entryName;
        File embedDir = new File(this.m_rootDir, this.m_file.getName() + EMBEDDED_DIRECTORY);
        ZipEntry ze = this.m_zipFile.getEntry(entryName);
        if (ze != null && ze.isDirectory()) {
            File extractDir = new File(embedDir, entryName);
            Object object = this.m_revisionLock;
            synchronized (object) {
                if (!BundleCache.getSecureAction().fileExists(extractDir) && !BundleCache.getSecureAction().mkdirs(extractDir)) {
                    this.m_logger.log(1, "Unable to extract embedded directory.");
                }
            }
            return new ContentDirectoryContent(this, entryName);
        }
        if (ze != null && ze.getName().endsWith(".jar")) {
            File extractJar = new File(embedDir, entryName);
            Object object = this.m_revisionLock;
            synchronized (object) {
                try {
                    this.extractEmbeddedJar(entryName);
                }
                catch (Exception ex) {
                    this.m_logger.log(1, "Unable to extract embedded JAR file.", ex);
                }
            }
            return new JarContent(this.m_logger, this.m_configMap, this.m_zipFactory, this.m_revisionLock, extractJar.getParentFile(), extractJar, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEntryAsNativeLibrary(String entryName) {
        String result = null;
        entryName = entryName.startsWith("/") ? entryName.substring(1) : entryName;
        File libDir = new File(this.m_rootDir, this.m_file.getName() + LIBRARY_DIRECTORY);
        ZipEntry ze = this.m_zipFile.getEntry(entryName);
        if (ze != null && !ze.isDirectory()) {
            Object object = this.m_revisionLock;
            synchronized (object) {
                Integer libCount;
                if (this.m_nativeLibMap == null) {
                    this.m_nativeLibMap = new HashMap();
                }
                libCount = (libCount = (Integer)this.m_nativeLibMap.get(entryName)) == null ? new Integer(0) : new Integer(libCount + 1);
                this.m_nativeLibMap.put(entryName, libCount);
                File libFile = new File(libDir, libCount.toString() + File.separatorChar + entryName);
                if (!BundleCache.getSecureAction().fileExists(libFile)) {
                    if (!BundleCache.getSecureAction().fileExists(libFile.getParentFile()) && !BundleCache.getSecureAction().mkdirs(libFile.getParentFile())) {
                        this.m_logger.log(1, "Unable to create library directory.");
                    } else {
                        InputStream is = null;
                        try {
                            is = new BufferedInputStream(this.m_zipFile.getInputStream(ze), BundleCache.BUFSIZE);
                            if (is == null) {
                                throw new IOException("No input stream: " + entryName);
                            }
                            BundleCache.copyStreamToFile(is, libFile);
                            String command = (String)this.m_configMap.get("org.osgi.framework.command.execpermission");
                            if (command != null) {
                                Properties props = new Properties();
                                props.setProperty("abspath", libFile.toString());
                                command = Util.substVars(command, "command", null, props);
                                Process p = BundleCache.getSecureAction().exec(command);
                                Thread stdOut = new Thread(new DevNullRunnable(p.getInputStream()));
                                Thread stdErr = new Thread(new DevNullRunnable(p.getErrorStream()));
                                stdOut.setDaemon(true);
                                stdErr.setDaemon(true);
                                stdOut.start();
                                stdErr.start();
                                p.waitFor();
                                stdOut.join();
                                stdErr.join();
                            }
                            result = BundleCache.getSecureAction().getAbsolutePath(libFile);
                        }
                        catch (Exception ex) {
                            this.m_logger.log(1, "Extracting native library.", ex);
                        }
                        finally {
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (IOException ex) {}
                        }
                    }
                } else {
                    result = BundleCache.getSecureAction().getAbsolutePath(libFile);
                }
            }
        }
        return result;
    }

    public String toString() {
        return "JAR " + this.m_file.getPath();
    }

    public File getFile() {
        return this.m_file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractEmbeddedJar(String jarPath) throws Exception {
        jarPath = jarPath.length() > 0 && jarPath.charAt(0) == '/' ? jarPath.substring(1) : jarPath;
        File embedDir = new File(this.m_rootDir, this.m_file.getName() + EMBEDDED_DIRECTORY);
        File jarFile = new File(embedDir, jarPath);
        if (!BundleCache.getSecureAction().fileExists(jarFile)) {
            InputStream is = null;
            try {
                ZipEntry ze = this.m_zipFile.getEntry(jarPath);
                if (ze == null) {
                    return;
                }
                if (!ze.isDirectory()) {
                    File jarDir = jarFile.getParentFile();
                    if (!BundleCache.getSecureAction().fileExists(jarDir) && !BundleCache.getSecureAction().mkdirs(jarDir)) {
                        throw new IOException("Unable to create embedded JAR directory.");
                    }
                    is = new BufferedInputStream(this.m_zipFile.getInputStream(ze), BundleCache.BUFSIZE);
                    if (is == null) {
                        throw new IOException("No input stream: " + jarPath);
                    }
                    BundleCache.copyStreamToFile(is, jarFile);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    private static class DevNullRunnable
    implements Runnable {
        private final InputStream m_in;

        public DevNullRunnable(InputStream in) {
            this.m_in = in;
        }

        @Override
        public void run() {
            try {
                try {
                    while (this.m_in.read() != -1) {
                    }
                }
                finally {
                    this.m_in.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class EntriesEnumeration
    implements Enumeration<String> {
        private final Enumeration m_enumeration;

        public EntriesEnumeration(Enumeration enumeration) {
            this.m_enumeration = enumeration;
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_enumeration.hasMoreElements();
        }

        @Override
        public String nextElement() {
            return ((ZipEntry)this.m_enumeration.nextElement()).getName();
        }
    }
}

