/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.utils.JavaTypeEnhancementState;
import org.jetbrains.kotlin.utils.ReportLevel;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J/\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0002J\u001d\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/cli/common/arguments/JavaTypeEnhancementStateParser;", "", "collector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "parse", "Lorg/jetbrains/kotlin/utils/JavaTypeEnhancementState;", "jsr305Args", "", "", "supportCompatqualCheckerFrameworkAnnotations", "jspecifyState", "([Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lorg/jetbrains/kotlin/utils/JavaTypeEnhancementState;", "parseJspecifyReportLevel", "Lorg/jetbrains/kotlin/utils/ReportLevel;", "parseJsr305State", "Lorg/jetbrains/kotlin/cli/common/arguments/JavaTypeEnhancementStateParser$Jsr305State;", "args", "([Ljava/lang/String;)Lorg/jetbrains/kotlin/cli/common/arguments/JavaTypeEnhancementStateParser$Jsr305State;", "parseJsr305UserDefined", "Lkotlin/Pair;", "item", "reportDuplicateJsr305", "", "first", "second", "reportUnrecognizedJsr305", "Jsr305State", "cli-common"})
public final class JavaTypeEnhancementStateParser {
    @NotNull
    private final MessageCollector collector;

    public JavaTypeEnhancementStateParser(@NotNull MessageCollector collector2) {
        Intrinsics.checkNotNullParameter(collector2, "collector");
        this.collector = collector2;
    }

    @NotNull
    public final JavaTypeEnhancementState parse(@Nullable String[] jsr305Args, @Nullable String supportCompatqualCheckerFrameworkAnnotations, @Nullable String jspecifyState) {
        Boolean bl;
        Jsr305State jsr305State = this.parseJsr305State(jsr305Args);
        String string2 = supportCompatqualCheckerFrameworkAnnotations;
        if (Intrinsics.areEqual(string2, "enable")) {
            bl = true;
        } else if (Intrinsics.areEqual(string2, "disable")) {
            bl = false;
        } else if (string2 == null) {
            bl = null;
        } else {
            MessageCollector.DefaultImpls.report$default(this.collector, CompilerMessageSeverity.ERROR, "Unrecognized -Xsupport-compatqual-checker-framework-annotations option: " + supportCompatqualCheckerFrameworkAnnotations + ". Possible values are 'enable'/'disable'", null, 4, null);
            bl = null;
        }
        Boolean enableCompatqualCheckerFrameworkAnnotations = bl;
        ReportLevel jspecifyReportLevel = this.parseJspecifyReportLevel(jspecifyState);
        Object object = jsr305State.getGlobal();
        Object object2 = object == null ? ReportLevel.WARN : object;
        object = enableCompatqualCheckerFrameworkAnnotations;
        JavaTypeEnhancementState state = new JavaTypeEnhancementState((ReportLevel)((Object)object2), jsr305State.getMigration(), (Map<String, ? extends ReportLevel>)jsr305State.getUsedDefined(), object == null ? true : (Boolean)object, jspecifyReportLevel);
        return Intrinsics.areEqual(state, JavaTypeEnhancementState.DISABLED_JSR_305) ? JavaTypeEnhancementState.DISABLED_JSR_305 : state;
    }

    private final ReportLevel parseJspecifyReportLevel(String jspecifyState) {
        if (jspecifyState == null) {
            return JavaTypeEnhancementState.DEFAULT_REPORT_LEVEL_FOR_JSPECIFY;
        }
        ReportLevel reportLevel = ReportLevel.Companion.findByDescription(jspecifyState);
        if (reportLevel == null) {
            MessageCollector.DefaultImpls.report$default(this.collector, CompilerMessageSeverity.ERROR, "Unrecognized -Xjspecify-annotations option: " + jspecifyState + ". Possible values are 'disable'/'warn'/'strict'", null, 4, null);
            return JavaTypeEnhancementState.DEFAULT_REPORT_LEVEL_FOR_JSPECIFY;
        }
        return reportLevel;
    }

    private final Jsr305State parseJsr305State(String[] args) {
        ReportLevel global = null;
        ReportLevel migration = null;
        boolean bl = false;
        Map userDefined = new LinkedHashMap();
        String[] stringArray = args;
        if (stringArray != null) {
            String[] $this$forEach$iv = stringArray;
            boolean $i$f$forEach = false;
            String[] stringArray2 = $this$forEach$iv;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                String element$iv;
                String item = element$iv = stringArray2[i];
                boolean bl2 = false;
                if (StringsKt.startsWith$default(item, "@", false, 2, null)) {
                    object = this.parseJsr305UserDefined(item);
                    if (object == null) continue;
                    Pair<String, ReportLevel> pair = object;
                    String name = pair.component1();
                    ReportLevel state = pair.component2();
                    ReportLevel current2 = (ReportLevel)((Object)userDefined.get(name));
                    if (current2 == null) {
                        Map map = userDefined;
                        boolean bl3 = false;
                        map.put(name, state);
                        continue;
                    }
                    if (current2 == state) continue;
                    this.reportDuplicateJsr305('@' + name + ':' + current2.getDescription(), item);
                    continue;
                }
                if (StringsKt.startsWith$default(item, "under-migration", false, 2, null)) {
                    ReportLevel state = JavaTypeEnhancementStateParser.parseJsr305State$parseJsr305UnderMigration(this, item);
                    if (migration == null) {
                        migration = state;
                        continue;
                    }
                    if (migration == state) continue;
                    object = migration;
                    this.reportDuplicateJsr305(Intrinsics.stringPlus("under-migration:", ((ReportLevel)((Object)object)).getDescription()), item);
                    continue;
                }
                if (Intrinsics.areEqual(item, "enable")) {
                    MessageCollector.DefaultImpls.report$default(this.collector, CompilerMessageSeverity.STRONG_WARNING, "Option 'enable' for -Xjsr305 flag is deprecated. Please use 'strict' instead", null, 4, null);
                    if (global != null) continue;
                    global = ReportLevel.STRICT;
                    continue;
                }
                if (global == null) {
                    global = ReportLevel.Companion.findByDescription(item);
                    continue;
                }
                if (Intrinsics.areEqual(global.getDescription(), item)) continue;
                this.reportDuplicateJsr305(global.getDescription(), item);
            }
        }
        return new Jsr305State(global, migration, userDefined);
    }

    private final void reportUnrecognizedJsr305(String item) {
        MessageCollector.DefaultImpls.report$default(this.collector, CompilerMessageSeverity.ERROR, Intrinsics.stringPlus("Unrecognized -Xjsr305 value: ", item), null, 4, null);
    }

    private final void reportDuplicateJsr305(String first, String second) {
        MessageCollector.DefaultImpls.report$default(this.collector, CompilerMessageSeverity.ERROR, "Conflict duplicating -Xjsr305 value: " + first + ", " + second, null, 4, null);
    }

    private final Pair<String, ReportLevel> parseJsr305UserDefined(String item) {
        Object object;
        Object object2;
        Object object3 = item;
        int n = 1;
        boolean bl = false;
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)object3).substring(n);
        Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.String).substring(startIndex)");
        object3 = new String[]{":"};
        object3 = StringsKt.split$default((CharSequence)string2, (String[])object3, false, 0, 6, null);
        n = 0;
        bl = false;
        Object it = object3;
        boolean bl2 = false;
        Object object4 = object2 = it.size() == 2 ? object3 : null;
        if (object2 == null) {
            object3 = this;
            n = 0;
            bl = false;
            JavaTypeEnhancementStateParser $this$parseJsr305UserDefined_u24lambda_u2d4 = (JavaTypeEnhancementStateParser)object3;
            boolean bl3 = false;
            $this$parseJsr305UserDefined_u24lambda_u2d4.reportUnrecognizedJsr305((String)item);
            return null;
        }
        object3 = object = object2;
        n = 0;
        String name = (String)object3.get(0);
        Object object5 = object;
        bl = false;
        String rawState = (String)object5.get(1);
        ReportLevel reportLevel = ReportLevel.Companion.findByDescription(rawState);
        if (reportLevel == null) {
            JavaTypeEnhancementStateParser javaTypeEnhancementStateParser = this;
            boolean bl4 = false;
            boolean bl5 = false;
            JavaTypeEnhancementStateParser $this$parseJsr305UserDefined_u24lambda_u2d5 = javaTypeEnhancementStateParser;
            boolean bl6 = false;
            $this$parseJsr305UserDefined_u24lambda_u2d5.reportUnrecognizedJsr305((String)item);
            return null;
        }
        ReportLevel state = reportLevel;
        return TuplesKt.to(name, state);
    }

    private static final ReportLevel parseJsr305State$parseJsr305UnderMigration(JavaTypeEnhancementStateParser this$0, String item) {
        Object object;
        Object object2 = new String[]{":"};
        object2 = StringsKt.split$default((CharSequence)item, (String[])object2, false, 0, 6, null);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object2;
        boolean bl3 = false;
        Object object3 = it.size() == 2 ? object2 : null;
        String rawState = object3 == null ? null : (String)object3.get(1);
        if ((object3 = ReportLevel.Companion.findByDescription(rawState)) == null) {
            this$0.reportUnrecognizedJsr305(item);
            object2 = Unit.INSTANCE;
            bl = false;
            bl2 = false;
            it = object2;
            boolean bl4 = false;
            object = null;
        } else {
            object = object3;
        }
        return object;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J7\u0010\u0011\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/cli/common/arguments/JavaTypeEnhancementStateParser$Jsr305State;", "", "global", "Lorg/jetbrains/kotlin/utils/ReportLevel;", "migration", "usedDefined", "", "", "(Lorg/jetbrains/kotlin/utils/ReportLevel;Lorg/jetbrains/kotlin/utils/ReportLevel;Ljava/util/Map;)V", "getGlobal", "()Lorg/jetbrains/kotlin/utils/ReportLevel;", "getMigration", "getUsedDefined", "()Ljava/util/Map;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "cli-common"})
    private static final class Jsr305State {
        @Nullable
        private final ReportLevel global;
        @Nullable
        private final ReportLevel migration;
        @NotNull
        private final Map<String, ReportLevel> usedDefined;

        public Jsr305State(@Nullable ReportLevel global, @Nullable ReportLevel migration, @NotNull Map<String, ? extends ReportLevel> usedDefined) {
            Intrinsics.checkNotNullParameter(usedDefined, "usedDefined");
            this.global = global;
            this.migration = migration;
            this.usedDefined = usedDefined;
        }

        @Nullable
        public final ReportLevel getGlobal() {
            return this.global;
        }

        @Nullable
        public final ReportLevel getMigration() {
            return this.migration;
        }

        @NotNull
        public final Map<String, ReportLevel> getUsedDefined() {
            return this.usedDefined;
        }

        @Nullable
        public final ReportLevel component1() {
            return this.global;
        }

        @Nullable
        public final ReportLevel component2() {
            return this.migration;
        }

        @NotNull
        public final Map<String, ReportLevel> component3() {
            return this.usedDefined;
        }

        @NotNull
        public final Jsr305State copy(@Nullable ReportLevel global, @Nullable ReportLevel migration, @NotNull Map<String, ? extends ReportLevel> usedDefined) {
            Intrinsics.checkNotNullParameter(usedDefined, "usedDefined");
            return new Jsr305State(global, migration, usedDefined);
        }

        public static /* synthetic */ Jsr305State copy$default(Jsr305State jsr305State, ReportLevel reportLevel, ReportLevel reportLevel2, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                reportLevel = jsr305State.global;
            }
            if ((n & 2) != 0) {
                reportLevel2 = jsr305State.migration;
            }
            if ((n & 4) != 0) {
                map = jsr305State.usedDefined;
            }
            return jsr305State.copy(reportLevel, reportLevel2, map);
        }

        @NotNull
        public String toString() {
            return "Jsr305State(global=" + (Object)((Object)this.global) + ", migration=" + (Object)((Object)this.migration) + ", usedDefined=" + this.usedDefined + ')';
        }

        public int hashCode() {
            int result2 = this.global == null ? 0 : this.global.hashCode();
            result2 = result2 * 31 + (this.migration == null ? 0 : this.migration.hashCode());
            result2 = result2 * 31 + ((Object)this.usedDefined).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Jsr305State)) {
                return false;
            }
            Jsr305State jsr305State = (Jsr305State)other;
            if (this.global != jsr305State.global) {
                return false;
            }
            if (this.migration != jsr305State.migration) {
                return false;
            }
            return Intrinsics.areEqual(this.usedDefined, jsr305State.usedDefined);
        }
    }
}

