/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.model.node;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUquadric;
import org.gephi.graph.api.Node;
import org.gephi.visualization.model.Model;
import org.gephi.visualization.model.Modeler;
import org.gephi.visualization.model.node.NodeDiskModel;
import org.gephi.visualization.model.node.NodeModel;
import org.gephi.visualization.opengl.CompatibilityEngine;

public class NodeModeler
extends Modeler {
    public int SHAPE_DIAMOND;
    public int SHAPE_DISK16;
    public int SHAPE_DISK32;
    public int SHAPE_DISK64;
    public int BORDER16;
    public int BORDER32;
    public int BORDER64;

    public NodeModeler(CompatibilityEngine engine) {
        super(engine);
    }

    public NodeModel initModel(Node n) {
        NodeDiskModel obj = new NodeDiskModel(n);
        obj.modelType = this.SHAPE_DISK64;
        obj.modelBorderType = this.BORDER64;
        this.chooseModel(obj);
        return obj;
    }

    @Override
    public void chooseModel(Model object3d) {
        NodeDiskModel obj = (NodeDiskModel)object3d;
        if (this.config.isDisableLOD()) {
            obj.modelType = this.SHAPE_DISK64;
            obj.modelBorderType = this.BORDER64;
            return;
        }
        float distance = this.cameraDistance(obj) / (obj.getNode().size() * this.drawable.getGlobalScale());
        if (distance > 600.0f) {
            obj.modelType = this.SHAPE_DIAMOND;
            obj.modelBorderType = -1;
        } else if (distance > 50.0f) {
            obj.modelType = this.SHAPE_DISK16;
            obj.modelBorderType = this.BORDER16;
        } else {
            obj.modelType = this.SHAPE_DISK32;
            obj.modelBorderType = this.BORDER32;
        }
    }

    @Override
    public int initDisplayLists(GL2 gl, GLU glu, GLUquadric quadric, int ptr) {
        this.SHAPE_DIAMOND = ptr + 1;
        gl.glNewList(this.SHAPE_DIAMOND, 4864);
        glu.gluDisk(quadric, 0.0, 0.5, 4, 1);
        gl.glEndList();
        this.SHAPE_DISK16 = this.SHAPE_DIAMOND + 1;
        gl.glNewList(this.SHAPE_DISK16, 4864);
        glu.gluDisk(quadric, 0.0, 0.5, 6, 1);
        gl.glEndList();
        this.SHAPE_DISK32 = this.SHAPE_DISK16 + 1;
        gl.glNewList(this.SHAPE_DISK32, 4864);
        glu.gluDisk(quadric, 0.0, 0.5, 12, 2);
        gl.glEndList();
        this.SHAPE_DISK64 = this.SHAPE_DISK32 + 1;
        gl.glNewList(this.SHAPE_DISK64, 4864);
        glu.gluDisk(quadric, 0.0, 0.5, 32, 4);
        gl.glEndList();
        this.BORDER16 = this.SHAPE_DISK64 + 1;
        gl.glNewList(this.BORDER16, 4864);
        glu.gluDisk(quadric, 0.42, 0.5, 24, 2);
        gl.glEndList();
        this.BORDER32 = this.BORDER16 + 1;
        gl.glNewList(this.BORDER32, 4864);
        glu.gluDisk(quadric, 0.42, 0.5, 48, 2);
        gl.glEndList();
        this.BORDER64 = this.BORDER32 + 1;
        gl.glNewList(this.BORDER64, 4864);
        glu.gluDisk(quadric, 0.42, 0.5, 96, 4);
        gl.glEndList();
        return this.BORDER64;
    }

    @Override
    public void beforeDisplay(GL2 gl, GLU glu) {
    }

    @Override
    public void afterDisplay(GL2 gl, GLU glu) {
    }

    protected float cameraDistance(NodeModel object) {
        float[] cameraLocation = this.drawable.getCameraLocation();
        double distance = Math.sqrt(Math.pow((double)object.getNode().x() - (double)cameraLocation[0], 2.0) + Math.pow((double)object.getNode().y() - (double)cameraLocation[1], 2.0) + Math.pow((double)object.getNode().z() - (double)cameraLocation[2], 2.0));
        object.setCameraDistance((float)distance);
        return (float)distance;
    }

    public boolean isLod() {
        return true;
    }

    public boolean isSelectable() {
        return true;
    }

    public boolean isClickable() {
        return true;
    }

    public boolean isOnlyAutoSelect() {
        return false;
    }
}

