/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.doubles.Double2IntRBTreeMap;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.graph.api.types.TimestampSet;
import org.gephi.graph.impl.GraphLock;
import org.gephi.graph.impl.TimeIndexImpl;
import org.gephi.graph.impl.TimeIndexStore;
import org.gephi.graph.impl.TimestampIndexImpl;

public class TimestampIndexStore<T extends Element>
extends TimeIndexStore<T, Double, TimestampSet, TimestampMap<?>> {
    public TimestampIndexStore(Class<T> type, GraphLock lock, boolean indexed) {
        super(type, lock, indexed, new Double2IntRBTreeMap());
        this.mainIndex = indexed ? new TimestampIndexImpl(this, true) : null;
    }

    @Override
    protected double getLow(Double k) {
        return k;
    }

    @Override
    protected void checkK(Double timestamp) {
        if (Double.isInfinite(timestamp) || Double.isNaN(timestamp)) {
            throw new IllegalArgumentException("Timestamp can't be NaN or infinity");
        }
    }

    @Override
    protected TimeIndexImpl createIndex(boolean main) {
        return new TimestampIndexImpl(this, main);
    }

    protected Double2IntRBTreeMap getMap() {
        return (Double2IntRBTreeMap)this.timeSortedMap;
    }
}

