/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.http;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class HTTPDateFormat
extends DateFormat {
    static final String[] DAYS_OF_WEEK = new String[]{null, "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public HTTPDateFormat() {
        this.calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        this.numberFormat = new DecimalFormat();
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.calendar.clear();
        this.calendar.setTime(date);
        stringBuffer.setLength(0);
        stringBuffer.append(DAYS_OF_WEEK[this.calendar.get(7)]);
        stringBuffer.append(',');
        stringBuffer.append(' ');
        int n = this.calendar.get(5);
        stringBuffer.append(Character.forDigit(n / 10, 10));
        stringBuffer.append(Character.forDigit(n % 10, 10));
        stringBuffer.append(' ');
        stringBuffer.append(MONTHS[this.calendar.get(2)]);
        stringBuffer.append(' ');
        int n2 = this.calendar.get(1);
        if (n2 < 1000) {
            stringBuffer.append('0');
            if (n2 < 100) {
                stringBuffer.append('0');
                if (n2 < 10) {
                    stringBuffer.append('0');
                }
            }
        }
        stringBuffer.append(Integer.toString(n2));
        stringBuffer.append(' ');
        int n3 = this.calendar.get(11);
        stringBuffer.append(Character.forDigit(n3 / 10, 10));
        stringBuffer.append(Character.forDigit(n3 % 10, 10));
        stringBuffer.append(':');
        int n4 = this.calendar.get(12);
        stringBuffer.append(Character.forDigit(n4 / 10, 10));
        stringBuffer.append(Character.forDigit(n4 % 10, 10));
        stringBuffer.append(':');
        int n5 = this.calendar.get(13);
        stringBuffer.append(Character.forDigit(n5 / 10, 10));
        stringBuffer.append(Character.forDigit(n5 % 10, 10));
        stringBuffer.append(' ');
        int n6 = (this.calendar.get(15) + this.calendar.get(16)) / 60000;
        if (n6 < 0) {
            n6 = -n6;
            stringBuffer.append('-');
        } else {
            stringBuffer.append('+');
        }
        int n7 = n6 / 60;
        stringBuffer.append(Character.forDigit(n7 / 10, 10));
        stringBuffer.append(Character.forDigit(n7 % 10, 10));
        int n8 = n6 % 60;
        stringBuffer.append(Character.forDigit(n8 / 10, 10));
        stringBuffer.append(Character.forDigit(n8 % 10, 10));
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(stringBuffer.length());
        return stringBuffer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        int n = 0;
        int n2 = -1;
        int n3 = string.length();
        this.calendar.clear();
        parsePosition.setIndex(n);
        try {
            void var4_13;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            char c;
            if (Character.isLetter(string.charAt(n))) {
                n = this.skipNonWhitespace(string, n);
            }
            switch (n) {
                case 3: {
                    char c2;
                    n = this.skipWhitespace(string, n);
                    parsePosition.setIndex(n);
                    n2 = this.skipNonWhitespace(string, n + 1);
                    String string2 = string.substring(n, n2);
                    int c22 = -1;
                    for (c = '\u0000'; c < '\f'; ++c) {
                        if (!MONTHS[c].equals(string2)) continue;
                        c2 = c;
                        break;
                    }
                    if (c2 == '\uffffffff') {
                        parsePosition.setErrorIndex(n2);
                        return null;
                    }
                    n = this.skipWhitespace(string, n2 + 1);
                    parsePosition.setIndex(n);
                    n2 = this.skipNonWhitespace(string, n + 1);
                    n8 = Integer.parseInt(string.substring(n, n2));
                    n = this.skipWhitespace(string, n2 + 1);
                    parsePosition.setIndex(n);
                    n2 = this.skipTo(string, n + 1, ':');
                    n7 = Integer.parseInt(string.substring(n, n2));
                    n = n2 + 1;
                    parsePosition.setIndex(n);
                    n2 = this.skipTo(string, n + 1, ':');
                    n6 = Integer.parseInt(string.substring(n, n2));
                    n = n2 + 1;
                    parsePosition.setIndex(n);
                    n2 = this.skipNonWhitespace(string, n + 1);
                    n5 = Integer.parseInt(string.substring(n, n2));
                    n = this.skipWhitespace(string, n2 + 1);
                    parsePosition.setIndex(n);
                    n2 = this.skipNonWhitespace(string, n + 1);
                    n4 = Integer.parseInt(string.substring(n, n2));
                    break;
                }
                case 0: 
                case 4: {
                    char c3;
                    n = this.skipWhitespace(string, n);
                    parsePosition.setIndex(n);
                    n2 = this.skipNonWhitespace(string, n + 1);
                    n8 = Integer.parseInt(string.substring(n, n2));
                    n = this.skipWhitespace(string, n2 + 1);
                    parsePosition.setIndex(n);
                    n2 = this.skipNonWhitespace(string, n + 1);
                    String string2 = string.substring(n, n2);
                    int n9 = -1;
                    for (c = '\u0000'; c < '\f'; ++c) {
                        if (!MONTHS[c].equals(string2)) continue;
                        c3 = c;
                        break;
                    }
                    if (c3 == '\uffffffff') {
                        parsePosition.setErrorIndex(n2);
                        return null;
                    }
                    n = this.skipWhitespace(string, n2 + 1);
                    parsePosition.setIndex(n);
                    n2 = this.skipNonWhitespace(string, n + 1);
                    n4 = Integer.parseInt(string.substring(n, n2));
                    n = this.skipWhitespace(string, n2 + 1);
                    parsePosition.setIndex(n);
                    n2 = this.skipTo(string, n + 1, ':');
                    n7 = Integer.parseInt(string.substring(n, n2));
                    n = n2 + 1;
                    parsePosition.setIndex(n);
                    n2 = this.skipTo(string, n + 1, ':');
                    n6 = Integer.parseInt(string.substring(n, n2));
                    n = n2 + 1;
                    parsePosition.setIndex(n);
                    for (n2 = n + 1; n2 < n3 && !Character.isWhitespace(string.charAt(n2)); ++n2) {
                    }
                    n5 = Integer.parseInt(string.substring(n, n2));
                    break;
                }
                default: {
                    char c4;
                    n = this.skipWhitespace(string, n);
                    parsePosition.setIndex(n);
                    n2 = this.skipTo(string, n + 1, '-');
                    n8 = Integer.parseInt(string.substring(n, n2));
                    n = n2 + 1;
                    parsePosition.setIndex(n);
                    n2 = this.skipTo(string, n + 1, '-');
                    String string2 = string.substring(n, n2);
                    int n10 = -1;
                    for (c = '\u0000'; c < '\f'; ++c) {
                        if (!MONTHS[c].equals(string2)) continue;
                        c4 = c;
                        break;
                    }
                    if (c4 == '\uffffffff') {
                        parsePosition.setErrorIndex(n2);
                        return null;
                    }
                    n = n2 + 1;
                    parsePosition.setIndex(n);
                    n2 = this.skipNonWhitespace(string, n + 1);
                    n4 = 1900 + Integer.parseInt(string.substring(n, n2));
                    n = this.skipWhitespace(string, n2 + 1);
                    parsePosition.setIndex(n);
                    n2 = this.skipTo(string, n + 1, ':');
                    n7 = Integer.parseInt(string.substring(n, n2));
                    n = n2 + 1;
                    parsePosition.setIndex(n);
                    n2 = this.skipTo(string, n + 1, ':');
                    n6 = Integer.parseInt(string.substring(n, n2));
                    n = n2 + 1;
                    parsePosition.setIndex(n);
                    for (n2 = n + 1; n2 < n3 && !Character.isWhitespace(string.charAt(n2)); ++n2) {
                    }
                    n5 = Integer.parseInt(string.substring(n, n2));
                }
            }
            this.calendar.set(1, n4);
            this.calendar.set(2, (int)var4_13);
            this.calendar.set(5, n8);
            this.calendar.set(10, n7);
            this.calendar.set(12, n6);
            this.calendar.set(13, n5);
            if (n2 != n3) {
                n = this.skipWhitespace(string, n2 + 1);
                for (n2 = n + 1; n2 < n3 && !Character.isWhitespace(string.charAt(n2)); ++n2) {
                }
                c = string.charAt(n);
                if (Character.isLetter(c)) {
                    TimeZone timeZone = TimeZone.getTimeZone(string.substring(n, n2));
                    this.calendar.set(15, timeZone.getRawOffset());
                } else {
                    int n11 = 0;
                    n11 += 600 * Character.digit(string.charAt(++n), 10);
                    n11 += 60 * Character.digit(string.charAt(++n), 10);
                    n11 += 10 * Character.digit(string.charAt(++n), 10);
                    n11 += Character.digit(string.charAt(++n), 10);
                    n11 *= 60000;
                    if ('-' == c) {
                        n11 = -n11;
                    }
                    this.calendar.set(15, n11);
                }
            }
            parsePosition.setIndex(n2);
            return this.calendar.getTime();
        }
        catch (NumberFormatException numberFormatException) {
            parsePosition.setErrorIndex(Math.max(n, n2));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            parsePosition.setErrorIndex(Math.max(n, n2));
        }
        return null;
    }

    private int skipWhitespace(String string, int n) {
        while (Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    private int skipNonWhitespace(String string, int n) {
        while (!Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    private int skipTo(String string, int n, char c) {
        while (string.charAt(n) != c) {
            ++n;
        }
        return n;
    }

    @Override
    public void setCalendar(Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNumberFormat(NumberFormat numberFormat) {
        throw new UnsupportedOperationException();
    }
}

