/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.collections.SynchronizedQueue;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;

public class NioBlockingSelector {
    private static final Log log = LogFactory.getLog(NioBlockingSelector.class);
    private static AtomicInteger threadCounter = new AtomicInteger(0);
    private final SynchronizedStack<KeyReference> keyReferenceStack = new SynchronizedStack();
    protected Selector sharedSelector;
    protected BlockPoller poller;

    public void open(Selector selector) {
        this.sharedSelector = selector;
        this.poller = new BlockPoller();
        this.poller.selector = this.sharedSelector;
        this.poller.setDaemon(true);
        this.poller.setName("NioBlockingSelector.BlockPoller-" + threadCounter.getAndIncrement());
        this.poller.start();
    }

    public void close() {
        if (this.poller != null) {
            this.poller.disable();
            this.poller.interrupt();
            this.poller = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer byteBuffer, NioChannel nioChannel, long l) throws IOException {
        SelectionKey selectionKey = nioChannel.getIOChannel().keyFor(nioChannel.getPoller().getSelector());
        if (selectionKey == null) {
            throw new IOException("Key no longer registered");
        }
        KeyReference keyReference = (KeyReference)this.keyReferenceStack.pop();
        if (keyReference == null) {
            keyReference = new KeyReference();
        }
        NioEndpoint.NioSocketWrapper nioSocketWrapper = (NioEndpoint.NioSocketWrapper)selectionKey.attachment();
        if (nioSocketWrapper.previousIOException != null) {
            throw new IOException(nioSocketWrapper.previousIOException);
        }
        int n = 0;
        boolean bl = false;
        int n2 = 1;
        long l2 = System.currentTimeMillis();
        try {
            while (!bl && byteBuffer.hasRemaining()) {
                if (n2 > 0) {
                    int n3 = nioChannel.write(byteBuffer);
                    if (n3 == -1) {
                        throw new EOFException();
                    }
                    n += n3;
                    if (n3 > 0) {
                        l2 = System.currentTimeMillis();
                        continue;
                    }
                }
                try {
                    if (nioSocketWrapper.getWriteLatch() == null || nioSocketWrapper.getWriteLatch().getCount() == 0L) {
                        nioSocketWrapper.startWriteLatch(1);
                    }
                    this.poller.add(nioSocketWrapper, 4, keyReference);
                    if (l < 0L) {
                        nioSocketWrapper.awaitWriteLatch(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    } else {
                        nioSocketWrapper.awaitWriteLatch(l, TimeUnit.MILLISECONDS);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (nioSocketWrapper.getWriteLatch() != null && nioSocketWrapper.getWriteLatch().getCount() > 0L) {
                    n2 = 0;
                } else {
                    n2 = 1;
                    nioSocketWrapper.resetWriteLatch();
                }
                if (l <= 0L || n2 != 0) continue;
                bl = System.currentTimeMillis() - l2 >= l;
            }
            if (bl) {
                nioSocketWrapper.previousIOException = new SocketTimeoutException();
                throw nioSocketWrapper.previousIOException;
            }
        }
        finally {
            this.poller.remove(nioSocketWrapper, 4);
            if (bl && keyReference.key != null) {
                this.poller.cancelKey(keyReference.key);
            }
            keyReference.key = null;
            this.keyReferenceStack.push((Object)keyReference);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer byteBuffer, NioChannel nioChannel, long l) throws IOException {
        SelectionKey selectionKey = nioChannel.getIOChannel().keyFor(nioChannel.getPoller().getSelector());
        if (selectionKey == null) {
            throw new IOException("Key no longer registered");
        }
        KeyReference keyReference = (KeyReference)this.keyReferenceStack.pop();
        if (keyReference == null) {
            keyReference = new KeyReference();
        }
        NioEndpoint.NioSocketWrapper nioSocketWrapper = (NioEndpoint.NioSocketWrapper)selectionKey.attachment();
        int n = 0;
        boolean bl = false;
        int n2 = 1;
        long l2 = System.currentTimeMillis();
        try {
            while (!(bl || n2 > 0 && (n = nioChannel.read(byteBuffer)) != 0)) {
                try {
                    if (nioSocketWrapper.getReadLatch() == null || nioSocketWrapper.getReadLatch().getCount() == 0L) {
                        nioSocketWrapper.startReadLatch(1);
                    }
                    this.poller.add(nioSocketWrapper, 1, keyReference);
                    if (l < 0L) {
                        nioSocketWrapper.awaitReadLatch(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    } else {
                        nioSocketWrapper.awaitReadLatch(l, TimeUnit.MILLISECONDS);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (nioSocketWrapper.getReadLatch() != null && nioSocketWrapper.getReadLatch().getCount() > 0L) {
                    n2 = 0;
                } else {
                    n2 = 1;
                    nioSocketWrapper.resetReadLatch();
                }
                if (l < 0L || n2 != 0) continue;
                bl = System.currentTimeMillis() - l2 >= l;
            }
            if (bl) {
                throw new SocketTimeoutException();
            }
        }
        finally {
            this.poller.remove(nioSocketWrapper, 1);
            if (bl && keyReference.key != null) {
                this.poller.cancelKey(keyReference.key);
            }
            keyReference.key = null;
            this.keyReferenceStack.push((Object)keyReference);
        }
        return n;
    }

    public static class KeyReference {
        SelectionKey key = null;

        public void finalize() {
            if (this.key != null && this.key.isValid()) {
                log.warn((Object)"Possible key leak, cancelling key in the finalizer.");
                try {
                    this.key.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected static class BlockPoller
    extends Thread {
        protected volatile boolean run = true;
        protected Selector selector = null;
        protected final SynchronizedQueue<Runnable> events = new SynchronizedQueue();
        protected final AtomicInteger wakeupCounter = new AtomicInteger(0);

        protected BlockPoller() {
        }

        public void disable() {
            this.run = false;
            this.selector.wakeup();
        }

        public void cancelKey(SelectionKey selectionKey) {
            RunnableCancel runnableCancel = new RunnableCancel(selectionKey);
            this.events.offer((Object)runnableCancel);
            this.wakeup();
        }

        public void wakeup() {
            if (this.wakeupCounter.addAndGet(1) == 0) {
                this.selector.wakeup();
            }
        }

        public void cancel(SelectionKey selectionKey, NioEndpoint.NioSocketWrapper nioSocketWrapper, int n) {
            if (selectionKey != null) {
                selectionKey.cancel();
                selectionKey.attach(null);
                if (4 == (n & 4)) {
                    this.countDown(nioSocketWrapper.getWriteLatch());
                }
                if (1 == (n & 1)) {
                    this.countDown(nioSocketWrapper.getReadLatch());
                }
            }
        }

        public void add(NioEndpoint.NioSocketWrapper nioSocketWrapper, int n, KeyReference keyReference) {
            if (nioSocketWrapper == null) {
                return;
            }
            NioChannel nioChannel = (NioChannel)nioSocketWrapper.getSocket();
            SocketChannel socketChannel = nioChannel.getIOChannel();
            if (socketChannel == null) {
                return;
            }
            RunnableAdd runnableAdd = new RunnableAdd(socketChannel, nioSocketWrapper, n, keyReference);
            this.events.offer((Object)runnableAdd);
            this.wakeup();
        }

        public void remove(NioEndpoint.NioSocketWrapper nioSocketWrapper, int n) {
            if (nioSocketWrapper == null) {
                return;
            }
            NioChannel nioChannel = (NioChannel)nioSocketWrapper.getSocket();
            SocketChannel socketChannel = nioChannel.getIOChannel();
            if (socketChannel == null) {
                return;
            }
            RunnableRemove runnableRemove = new RunnableRemove(socketChannel, nioSocketWrapper, n);
            this.events.offer((Object)runnableRemove);
            this.wakeup();
        }

        public boolean events() {
            Runnable runnable = null;
            int n = this.events.size();
            for (int i = 0; i < n && (runnable = (Runnable)this.events.poll()) != null; ++i) {
                runnable.run();
            }
            return n > 0;
        }

        @Override
        public void run() {
            block21: {
                block20: {
                    while (this.run) {
                        try {
                            Iterator<SelectionKey> iterator;
                            this.events();
                            int n = 0;
                            try {
                                int n2 = this.wakeupCounter.get();
                                if (n2 > 0) {
                                    n = this.selector.selectNow();
                                } else {
                                    this.wakeupCounter.set(-1);
                                    n = this.selector.select(1000L);
                                }
                                this.wakeupCounter.set(0);
                                if (!this.run) {
                                    break;
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                if (this.selector == null) {
                                    throw nullPointerException;
                                }
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)"Possibly encountered sun bug 5076772 on windows JDK 1.5", (Throwable)nullPointerException);
                                continue;
                            }
                            catch (CancelledKeyException cancelledKeyException) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)"Possibly encountered sun bug 5076772 on windows JDK 1.5", (Throwable)cancelledKeyException);
                                continue;
                            }
                            catch (Throwable throwable) {
                                ExceptionUtils.handleThrowable((Throwable)throwable);
                                log.error((Object)"", throwable);
                                continue;
                            }
                            Iterator<SelectionKey> iterator2 = iterator = n > 0 ? this.selector.selectedKeys().iterator() : null;
                            while (this.run && iterator != null && iterator.hasNext()) {
                                SelectionKey selectionKey = iterator.next();
                                NioEndpoint.NioSocketWrapper nioSocketWrapper = (NioEndpoint.NioSocketWrapper)selectionKey.attachment();
                                try {
                                    iterator.remove();
                                    selectionKey.interestOps(selectionKey.interestOps() & ~selectionKey.readyOps());
                                    if (selectionKey.isReadable()) {
                                        this.countDown(nioSocketWrapper.getReadLatch());
                                    }
                                    if (!selectionKey.isWritable()) continue;
                                    this.countDown(nioSocketWrapper.getWriteLatch());
                                }
                                catch (CancelledKeyException cancelledKeyException) {
                                    selectionKey.cancel();
                                    this.countDown(nioSocketWrapper.getReadLatch());
                                    this.countDown(nioSocketWrapper.getWriteLatch());
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            log.error((Object)"", throwable);
                        }
                    }
                    this.events.clear();
                    if (this.selector.isOpen()) {
                        try {
                            this.selector.selectNow();
                        }
                        catch (Exception exception) {
                            if (!log.isDebugEnabled()) break block20;
                            log.debug((Object)"", (Throwable)exception);
                        }
                    }
                }
                try {
                    this.selector.close();
                }
                catch (Exception exception) {
                    if (!log.isDebugEnabled()) break block21;
                    log.debug((Object)"", (Throwable)exception);
                }
            }
        }

        public void countDown(CountDownLatch countDownLatch) {
            if (countDownLatch == null) {
                return;
            }
            countDownLatch.countDown();
        }

        public static class RunnableCancel
        implements Runnable {
            private final SelectionKey key;

            public RunnableCancel(SelectionKey selectionKey) {
                this.key = selectionKey;
            }

            @Override
            public void run() {
                this.key.cancel();
            }
        }

        private class RunnableRemove
        implements Runnable {
            private final SocketChannel ch;
            private final NioEndpoint.NioSocketWrapper key;
            private final int ops;

            public RunnableRemove(SocketChannel socketChannel, NioEndpoint.NioSocketWrapper nioSocketWrapper, int n) {
                this.ch = socketChannel;
                this.key = nioSocketWrapper;
                this.ops = n;
            }

            @Override
            public void run() {
                block11: {
                    SelectionKey selectionKey = this.ch.keyFor(BlockPoller.this.selector);
                    try {
                        if (selectionKey == null) {
                            if (4 == (this.ops & 4)) {
                                BlockPoller.this.countDown(this.key.getWriteLatch());
                            }
                            if (1 == (this.ops & 1)) {
                                BlockPoller.this.countDown(this.key.getReadLatch());
                            }
                        } else if (selectionKey.isValid()) {
                            selectionKey.interestOps(selectionKey.interestOps() & ~this.ops);
                            if (4 == (this.ops & 4)) {
                                BlockPoller.this.countDown(this.key.getWriteLatch());
                            }
                            if (1 == (this.ops & 1)) {
                                BlockPoller.this.countDown(this.key.getReadLatch());
                            }
                            if (selectionKey.interestOps() == 0) {
                                selectionKey.cancel();
                                selectionKey.attach(null);
                            }
                        } else {
                            selectionKey.cancel();
                            selectionKey.attach(null);
                        }
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        if (selectionKey == null) break block11;
                        selectionKey.cancel();
                        selectionKey.attach(null);
                    }
                }
            }
        }

        private class RunnableAdd
        implements Runnable {
            private final SocketChannel ch;
            private final NioEndpoint.NioSocketWrapper key;
            private final int ops;
            private final KeyReference ref;

            public RunnableAdd(SocketChannel socketChannel, NioEndpoint.NioSocketWrapper nioSocketWrapper, int n, KeyReference keyReference) {
                this.ch = socketChannel;
                this.key = nioSocketWrapper;
                this.ops = n;
                this.ref = keyReference;
            }

            @Override
            public void run() {
                SelectionKey selectionKey = this.ch.keyFor(BlockPoller.this.selector);
                try {
                    if (selectionKey == null) {
                        this.ref.key = selectionKey = this.ch.register(BlockPoller.this.selector, this.ops, this.key);
                    } else if (!selectionKey.isValid()) {
                        BlockPoller.this.cancel(selectionKey, this.key, this.ops);
                    } else {
                        selectionKey.interestOps(selectionKey.interestOps() | this.ops);
                    }
                }
                catch (CancelledKeyException cancelledKeyException) {
                    BlockPoller.this.cancel(selectionKey, this.key, this.ops);
                }
                catch (ClosedChannelException closedChannelException) {
                    BlockPoller.this.cancel(null, this.key, this.ops);
                }
            }
        }
    }
}

