/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.cpu.SnapshotCPUView;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.actions.CompareSnapshotsAction;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.snaptracer.TracerPackage;
import org.netbeans.modules.profiler.snaptracer.impl.Bundle;
import org.netbeans.modules.profiler.snaptracer.impl.TimelineView;
import org.netbeans.modules.profiler.snaptracer.impl.TracerController;
import org.netbeans.modules.profiler.snaptracer.impl.TracerModel;
import org.netbeans.modules.profiler.snaptracer.impl.TracerSupportImpl;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;
import org.netbeans.modules.profiler.v2.ProfilerFeature;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class TracerView {
    private final TracerModel model;
    private final TracerController controller;
    private LoadedSnapshot lsF;
    private TimelineView timelineView;
    private SnapshotView snapshotView;

    public TracerView(TracerModel tracerModel, TracerController tracerController) {
        this.model = tracerModel;
        this.controller = tracerController;
    }

    public JComponent createComponent() {
        final JPanel jPanel = new JPanel(new BorderLayout());
        this.timelineView = new TimelineView(this.model);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.timelineView.getView(), "Center");
        jPanel2.add((Component)new JSeparator(), "South");
        final JPanel jPanel3 = new JPanel(null){

            @Override
            public void doLayout() {
                Component[] componentArray;
                for (Component component : componentArray = this.getComponents()) {
                    component.setBounds(0, 0, this.getWidth(), this.getHeight());
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return this.getComponent(this.getComponentCount() - 1).getPreferredSize();
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getComponent(this.getComponentCount() - 1).getMinimumSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getComponent(this.getComponentCount() - 1).getMaximumSize();
            }

            @Override
            public boolean isOptimizedDrawingEnabled() {
                return false;
            }
        };
        JPanel jPanel4 = new JPanel(null);
        jPanel4.setOpaque(false);
        jPanel4.setCursor(Cursor.getPredefinedCursor(3));
        jPanel4.addMouseListener(new MouseAdapter(){});
        jPanel4.addMouseMotionListener(new MouseMotionAdapter(){});
        jPanel4.addKeyListener(new KeyAdapter(){});
        jPanel3.add(jPanel4);
        jPanel3.add(jPanel2);
        jPanel.add((Component)jPanel3, "North");
        TracerSupportImpl.getInstance().perform(new Runnable(){

            @Override
            public void run() {
                TracerView.this.initProbes();
                TracerView.this.initTimeline();
                TracerView.this.initData(jPanel, jPanel3);
                TracerView.this.initListeners(jPanel);
            }
        });
        ActionMap actionMap = jPanel.getActionMap();
        actionMap.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TracerView.this.snapshotView != null && TracerView.this.snapshotView.isShowing()) {
                    TracerView.this.snapshotView.getActionMap().get("filter-action-key").actionPerformed(actionEvent);
                }
            }
        });
        actionMap.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TracerView.this.snapshotView != null && TracerView.this.snapshotView.isShowing()) {
                    TracerView.this.snapshotView.getActionMap().get("find-action-key").actionPerformed(actionEvent);
                }
            }
        });
        return jPanel;
    }

    private void initProbes() {
        List<TracerPackage> list = TracerSupportImpl.getInstance().getPackages(this.model.getSnapshot());
        for (TracerPackage tracerPackage : list) {
            this.model.addDescriptors(tracerPackage, tracerPackage.getProbeDescriptors());
        }
    }

    private void initTimeline() {
        TimelineSupport timelineSupport = this.model.getTimelineSupport();
        long l = this.model.firstTimestamp();
        if (l == -1L) {
            return;
        }
        long l2 = this.model.lastTimestamp();
        if (l2 == -1L) {
            return;
        }
        timelineSupport.dataLoadingStarted(l2 - l);
    }

    private void initData(final JPanel jPanel, final JPanel jPanel2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JLabel jLabel = new JLabel(Bundle.MSG_LoadingSnapshot(), 0);
                jLabel.setCursor(Cursor.getPredefinedCursor(3));
                TracerView.this.addContents(jPanel, jLabel);
                TracerSupportImpl.getInstance().perform(new Runnable(){

                    @Override
                    public void run() {
                        TracerView.this.controller.performSession();
                        TracerView.this.controller.performAfterSession(new Runnable(){

                            @Override
                            public void run() {
                                TimelineSupport timelineSupport = TracerView.this.model.getTimelineSupport();
                                timelineSupport.dataLoadingFinished();
                                timelineSupport.selectAll();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        TracerView.this.timelineView.updateActions();
                                    }
                                });
                                jPanel.remove(jPanel2);
                                jPanel.add(jPanel2.getComponent(1), "North");
                                jPanel.revalidate();
                                jPanel.repaint();
                            }
                        });
                    }
                });
            }
        });
    }

    private void initListeners(final JPanel jPanel) {
        final TimelineSupport timelineSupport = this.model.getTimelineSupport();
        timelineSupport.addSelectionListener(new TimelineSupport.SelectionListener(){

            @Override
            public void intervalsSelectionChanged() {
            }

            @Override
            public void indexSelectionChanged() {
                final int n = Math.min(timelineSupport.getStartIndex(), timelineSupport.getEndIndex());
                final int n2 = Math.max(timelineSupport.getStartIndex(), timelineSupport.getEndIndex());
                JLabel jLabel = new JLabel(Bundle.MSG_ProcessingSelection(), 0);
                TracerView.this.addContents(jPanel, jLabel);
                TracerView.this.controller.performAfterSession(new Runnable(){

                    @Override
                    public void run() {
                        if (n == n2) {
                            TracerView.this.displayThreadDump(jPanel, n);
                        } else {
                            TracerView.this.displaySnapshot(jPanel, n, n2);
                        }
                    }
                });
            }

            @Override
            public void timeSelectionChanged(boolean bl, boolean bl2) {
            }
        });
    }

    private void displaySnapshot(final JPanel jPanel, int n, int n2) {
        LoadedSnapshot loadedSnapshot = null;
        try {
            loadedSnapshot = this.model.getSnapshot().getCPUSnapshot(n, n2);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.lsF = loadedSnapshot;
        if (this.lsF != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CPUResultsSnapshot cPUResultsSnapshot = (CPUResultsSnapshot)TracerView.this.lsF.getSnapshot();
                    if (TracerView.this.snapshotView == null) {
                        CompareSnapshotsAction compareSnapshotsAction = new CompareSnapshotsAction(TracerView.this.lsF);
                        ResultsManager.SnapshotHandle snapshotHandle = new ResultsManager.SnapshotHandle(){

                            public LoadedSnapshot getSnapshot() {
                                return TracerView.this.lsF;
                            }
                        };
                        ExportUtils.Exportable exportable = ResultsManager.getDefault().createSnapshotExporter(snapshotHandle);
                        TracerView.this.snapshotView = new SnapshotView(cPUResultsSnapshot, (Action)compareSnapshotsAction, exportable);
                        compareSnapshotsAction.setPerformer(new CompareSnapshotsAction.Performer(){

                            public void compare(LoadedSnapshot loadedSnapshot) {
                                TracerView.this.snapshotView.setRefSnapshot((CPUResultsSnapshot)loadedSnapshot.getSnapshot());
                            }
                        });
                    } else {
                        TracerView.this.snapshotView.setData(cPUResultsSnapshot);
                    }
                    TracerView.this.addContents(jPanel, (JComponent)((Object)TracerView.this.snapshotView));
                }
            });
        }
    }

    private void displayThreadDump(final JPanel jPanel, int n) {
        String string = null;
        try {
            string = this.model.getSnapshot().getThreadDump(n);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        final String string2 = string;
        if (string2 != null) {
            this.lsF = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HTMLTextArea hTMLTextArea = new HTMLTextArea(string2){

                        protected void showURL(URL uRL) {
                            if (uRL == null) {
                                return;
                            }
                            String string = uRL.toString();
                            TracerView.this.showURL(string);
                        }
                    };
                    hTMLTextArea.setCaretPosition(0);
                    JScrollPane jScrollPane = new JScrollPane((Component)hTMLTextArea);
                    jScrollPane.setBorder(BorderFactory.createEmptyBorder());
                    jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
                    TracerView.this.addContents(jPanel, jScrollPane);
                }
            });
        }
    }

    private void addContents(JComponent jComponent, JComponent jComponent2) {
        BorderLayout borderLayout = (BorderLayout)jComponent.getLayout();
        Component component = borderLayout.getLayoutComponent("Center");
        if (component != jComponent2) {
            if (component != null) {
                jComponent.remove(component);
            }
            jComponent.add((Component)jComponent2, "Center");
            jComponent2.requestFocusInWindow();
            jComponent.revalidate();
            jComponent.repaint();
        }
    }

    void showURL(String string) {
        if (string.startsWith("file:/stackframe/")) {
            string = string.substring("file:/stackframe/".length());
            String[] stringArray = string.split("\\|");
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            int n = Integer.parseInt(stringArray[2]);
            GoToSource.openSource(null, (String)string2, (String)string3, (int)n);
        }
    }

    private class FindMethodAction
    extends AbstractAction {
        private final PrestimeCPUCCTNode node;

        private FindMethodAction(PrestimeCPUCCTNode prestimeCPUCCTNode) {
            super(Bundle.LBL_FindMethod());
            this.node = prestimeCPUCCTNode;
            this.setEnabled(this.isRegular(prestimeCPUCCTNode));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProgressHandle progressHandle = null;
                    try {
                        progressHandle = ProgressHandle.createHandle((String)Bundle.LBL_SelectingIntervals());
                        progressHandle.setInitialDelay(0);
                        progressHandle.start();
                        List<Integer> list = TracerView.this.model.getIntervals(FindMethodAction.this.node);
                        assert (list.size() % 2 == 0);
                        final Iterator<Integer> iterator = list.iterator();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TimelineSupport timelineSupport = TracerView.this.model.getTimelineSupport();
                                timelineSupport.resetSelectedIntervals();
                                while (iterator.hasNext()) {
                                    int n = (Integer)iterator.next();
                                    int n2 = (Integer)iterator.next();
                                    timelineSupport.selectInterval(n, n2);
                                }
                                timelineSupport.selectedIntervalsChanged();
                            }
                        });
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    finally {
                        if (progressHandle != null) {
                            progressHandle.finish();
                        }
                    }
                }
            });
        }

        private boolean isRegular(PrestimeCPUCCTNode prestimeCPUCCTNode) {
            return prestimeCPUCCTNode.getThreadId() != -1 && prestimeCPUCCTNode.getMethodId() != 0 && !prestimeCPUCCTNode.isFiltered();
        }
    }

    private final class SnapshotView
    extends SnapshotCPUView {
        SnapshotView(CPUResultsSnapshot cPUResultsSnapshot, Action action, ExportUtils.Exportable exportable) {
            super(cPUResultsSnapshot, true, null, action, null, exportable);
        }

        void setData(CPUResultsSnapshot cPUResultsSnapshot) {
            super.setSnapshot(cPUResultsSnapshot, true);
        }

        protected boolean profileMethodEnabled() {
            return false;
        }

        protected boolean profileMethodSupported() {
            return ProfilerFeature.Registry.hasProviders();
        }

        protected boolean profileClassSupported() {
            return ProfilerFeature.Registry.hasProviders();
        }

        protected boolean showSourceSupported() {
            return GoToSource.isAvailable();
        }

        protected void showSource(ClientUtils.SourceCodeSelection sourceCodeSelection) {
            String string = sourceCodeSelection.getClassName();
            String string2 = sourceCodeSelection.getMethodName();
            String string3 = sourceCodeSelection.getMethodSignature();
            GoToSource.openSource(null, (String)string, (String)string2, (String)string3);
        }

        protected void selectForProfiling(final ClientUtils.SourceCodeSelection sourceCodeSelection) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    String string = "*".equals(sourceCodeSelection.getMethodName()) ? Bundle.LBL_ProfileClass() : Bundle.LBL_ProfileMethod();
                    ProfilerSession.findAndConfigure((Lookup)Lookups.fixed((Object[])new Object[]{sourceCodeSelection}), null, (String)string);
                }
            });
        }

        protected void customizeNodePopup(DataView dataView, JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
            if (object instanceof PrestimeCPUCCTNode) {
                jPopupMenu.add(new FindMethodAction((PrestimeCPUCCTNode)object));
                jPopupMenu.addSeparator();
            }
        }
    }
}

