/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Wrapper;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.buf.MessageBytes;

final class StandardContextValve
extends ValveBase {
    private static final String info = "org.apache.catalina.core.StandardContextValve/1.0";

    public StandardContextValve() {
        super(true);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        MessageBytes messageBytes = request.getRequestPathMB();
        if (messageBytes.startsWithIgnoreCase("/META-INF/", 0) || messageBytes.equalsIgnoreCase("/META-INF") || messageBytes.startsWithIgnoreCase("/WEB-INF/", 0) || messageBytes.equalsIgnoreCase("/WEB-INF")) {
            response.sendError(404);
            return;
        }
        Wrapper wrapper = request.getWrapper();
        if (wrapper == null || wrapper.isUnavailable()) {
            response.sendError(404);
            return;
        }
        try {
            response.sendAcknowledgement();
        }
        catch (IOException iOException) {
            this.container.getLogger().error((Object)sm.getString("standardContextValve.acknowledgeException"), (Throwable)iOException);
            request.setAttribute("javax.servlet.error.exception", iOException);
            response.sendError(500);
            return;
        }
        if (request.isAsyncSupported()) {
            request.setAsyncSupported(wrapper.getPipeline().isAsyncSupported());
        }
        wrapper.getPipeline().getFirst().invoke(request, response);
    }

    @Override
    public final void event(Request request, Response response, CometEvent cometEvent) throws IOException, ServletException {
        Wrapper wrapper = request.getWrapper();
        wrapper.getPipeline().getFirst().event(request, response, cometEvent);
    }
}

