/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.WebConnection;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolException;
import org.apache.coyote.Request;
import org.apache.coyote.http11.upgrade.InternalHttpUpgradeHandler;
import org.apache.coyote.http2.AbstractNonZeroStream;
import org.apache.coyote.http2.AbstractStream;
import org.apache.coyote.http2.ByteUtil;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.ConnectionSettingsLocal;
import org.apache.coyote.http2.ConnectionSettingsRemote;
import org.apache.coyote.http2.FrameType;
import org.apache.coyote.http2.HeaderSink;
import org.apache.coyote.http2.HpackDecoder;
import org.apache.coyote.http2.HpackEncoder;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.Http2Parser;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.coyote.http2.SendfileData;
import org.apache.coyote.http2.Setting;
import org.apache.coyote.http2.Stream;
import org.apache.coyote.http2.StreamException;
import org.apache.coyote.http2.StreamProcessor;
import org.apache.coyote.http2.StreamRunnable;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SendfileState;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

class Http2UpgradeHandler
extends AbstractStream
implements InternalHttpUpgradeHandler,
Http2Parser.Input,
Http2Parser.Output {
    protected static final Log log = LogFactory.getLog(Http2UpgradeHandler.class);
    protected static final StringManager sm = StringManager.getManager(Http2UpgradeHandler.class);
    private static final AtomicInteger connectionIdGenerator = new AtomicInteger(0);
    private static final Integer STREAM_ID_ZERO = 0;
    protected static final int FLAG_END_OF_STREAM = 1;
    protected static final int FLAG_END_OF_HEADERS = 4;
    protected static final byte[] PING = new byte[]{0, 0, 8, 6, 0, 0, 0, 0, 0};
    protected static final byte[] PING_ACK = new byte[]{0, 0, 8, 6, 1, 0, 0, 0, 0};
    protected static final byte[] SETTINGS_ACK = new byte[]{0, 0, 0, 4, 1, 0, 0, 0, 0};
    protected static final byte[] GOAWAY = new byte[]{7, 0, 0, 0, 0, 0};
    private static final String HTTP2_SETTINGS_HEADER = "HTTP2-Settings";
    private static final HeaderSink HEADER_SINK = new HeaderSink();
    private final Object priorityTreeLock = new Object();
    protected final String connectionId;
    protected final Http2Protocol protocol;
    private final Adapter adapter;
    protected volatile SocketWrapperBase<?> socketWrapper;
    private volatile SSLSupport sslSupport;
    private volatile Http2Parser parser;
    private AtomicReference<ConnectionState> connectionState = new AtomicReference<ConnectionState>(ConnectionState.NEW);
    private volatile long pausedNanoTime = Long.MAX_VALUE;
    private final ConnectionSettingsRemote remoteSettings;
    protected final ConnectionSettingsLocal localSettings;
    private HpackDecoder hpackDecoder;
    private HpackEncoder hpackEncoder;
    private final ConcurrentNavigableMap<Integer, AbstractNonZeroStream> streams = new ConcurrentSkipListMap<Integer, AbstractNonZeroStream>();
    protected final AtomicInteger activeRemoteStreamCount = new AtomicInteger(0);
    private volatile int maxActiveRemoteStreamId = -1;
    private volatile int maxProcessedStreamId;
    private final AtomicInteger nextLocalStreamId = new AtomicInteger(2);
    private final PingManager pingManager = this.getPingManager();
    private volatile int newStreamsSinceLastPrune = 0;
    private final Map<AbstractStream, BacklogTracker> backLogStreams = new ConcurrentHashMap<AbstractStream, BacklogTracker>();
    private long backLogSize = 0L;
    private volatile long connectionTimeout = -1L;
    private AtomicInteger streamConcurrency = null;
    private Queue<StreamRunnable> queuedRunnable = null;
    private final AtomicLong overheadCount = new AtomicLong(-10L);
    private volatile int lastNonFinalDataPayload;
    private volatile int lastWindowUpdate;

    Http2UpgradeHandler(Http2Protocol http2Protocol, Adapter adapter, Request request) {
        super(STREAM_ID_ZERO);
        this.protocol = http2Protocol;
        this.adapter = adapter;
        this.connectionId = Integer.toString(connectionIdGenerator.getAndIncrement());
        this.lastNonFinalDataPayload = http2Protocol.getOverheadDataThreshold() * 2;
        this.lastWindowUpdate = http2Protocol.getOverheadWindowUpdateThreshold() * 2;
        this.remoteSettings = new ConnectionSettingsRemote(this.connectionId);
        this.localSettings = new ConnectionSettingsLocal(this.connectionId);
        this.localSettings.set(Setting.MAX_CONCURRENT_STREAMS, http2Protocol.getMaxConcurrentStreams());
        this.localSettings.set(Setting.INITIAL_WINDOW_SIZE, http2Protocol.getInitialWindowSize());
        this.pingManager.initiateDisabled = http2Protocol.getInitiatePingDisabled();
        if (request != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("upgradeHandler.upgrade", new Object[]{this.connectionId}));
            }
            Integer n = 1;
            Stream stream = new Stream(n, this, request);
            this.streams.put(n, stream);
            this.maxActiveRemoteStreamId = 1;
            this.activeRemoteStreamCount.set(1);
            this.maxProcessedStreamId = 1;
        }
    }

    protected PingManager getPingManager() {
        return new PingManager();
    }

    public void init(WebConnection webConnection) {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.init", new Object[]{this.connectionId, this.connectionState.get()}));
        }
        if (!this.connectionState.compareAndSet(ConnectionState.NEW, ConnectionState.CONNECTED)) {
            return;
        }
        if ((long)this.protocol.getMaxConcurrentStreamExecution() < this.localSettings.getMaxConcurrentStreams()) {
            this.streamConcurrency = new AtomicInteger(0);
            this.queuedRunnable = new ConcurrentLinkedQueue<StreamRunnable>();
        }
        this.parser = this.getParser(this.connectionId);
        Stream stream = null;
        this.socketWrapper.setReadTimeout(this.protocol.getReadTimeout());
        this.socketWrapper.setWriteTimeout(this.protocol.getWriteTimeout());
        if (webConnection != null) {
            try {
                stream = this.getStream(1, true);
                String string = stream.getCoyoteRequest().getHeader(HTTP2_SETTINGS_HEADER);
                object = Base64.decodeBase64URLSafe((String)string);
                FrameType.SETTINGS.check(0, ((byte[])object).length);
                for (int i = 0; i < ((byte[])object).length % 6; ++i) {
                    int n = ByteUtil.getTwoBytes(object, i * 6);
                    long l = ByteUtil.getFourBytes(object, i * 6 + 2);
                    this.remoteSettings.set(Setting.valueOf(n), l);
                }
            }
            catch (Http2Exception http2Exception) {
                throw new ProtocolException(sm.getString("upgradeHandler.upgrade.fail", new Object[]{this.connectionId}));
            }
        }
        this.writeSettings();
        try {
            this.parser.readConnectionPreface(webConnection, stream);
        }
        catch (Http2Exception http2Exception) {
            object = sm.getString("upgradeHandler.invalidPreface", new Object[]{this.connectionId});
            if (log.isDebugEnabled()) {
                log.debug(object, (Throwable)http2Exception);
            }
            throw new ProtocolException((String)object);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.prefaceReceived", new Object[]{this.connectionId}));
        }
        this.processConnection(webConnection, stream);
    }

    protected void processConnection(WebConnection webConnection, Stream stream) {
        try {
            this.pingManager.sendPing(true);
        }
        catch (IOException iOException) {
            throw new ProtocolException(sm.getString("upgradeHandler.pingFailed", new Object[]{this.connectionId}), iOException);
        }
        if (webConnection != null) {
            this.processStreamOnContainerThread(stream);
        }
    }

    protected Http2Parser getParser(String string) {
        return new Http2Parser(string, this, this);
    }

    protected void processStreamOnContainerThread(Stream stream) {
        StreamProcessor streamProcessor = new StreamProcessor(this, stream, this.adapter, this.socketWrapper);
        streamProcessor.setSslSupport(this.sslSupport);
        this.processStreamOnContainerThread(streamProcessor, SocketEvent.OPEN_READ);
    }

    void processStreamOnContainerThread(StreamProcessor streamProcessor, SocketEvent socketEvent) {
        StreamRunnable streamRunnable = new StreamRunnable(streamProcessor, socketEvent);
        if (this.streamConcurrency == null) {
            this.socketWrapper.execute(streamRunnable);
        } else if (this.getStreamConcurrency() < this.protocol.getMaxConcurrentStreamExecution()) {
            this.increaseStreamConcurrency();
            this.socketWrapper.execute(streamRunnable);
        } else {
            this.queuedRunnable.offer(streamRunnable);
        }
    }

    @Override
    public void setSocketWrapper(SocketWrapperBase<?> socketWrapperBase) {
        this.socketWrapper = socketWrapperBase;
    }

    @Override
    public void setSslSupport(SSLSupport sSLSupport) {
        this.sslSupport = sSLSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public AbstractEndpoint.Handler.SocketState upgradeDispatch(SocketEvent var1_1) {
        if (Http2UpgradeHandler.log.isDebugEnabled()) {
            Http2UpgradeHandler.log.debug((Object)Http2UpgradeHandler.sm.getString("upgradeHandler.upgradeDispatch.entry", new Object[]{this.connectionId, var1_1}));
        }
        this.init(null);
        var2_2 = AbstractEndpoint.Handler.SocketState.CLOSED;
        try {
            switch (1.$SwitchMap$org$apache$tomcat$util$net$SocketEvent[var1_1.ordinal()]) {
                case 1: {
                    var3_3 = this.socketWrapper;
                    synchronized (var3_3) {
                        if (!this.socketWrapper.canWrite()) {
                            this.pingManager.sendPing(false);
                        }
                    }
                    try {
                        this.socketWrapper.setReadTimeout(this.protocol.getReadTimeout());
                        this.setConnectionTimeout(-1L);
                        while (true) lbl-1000:
                        // 3 sources

                        {
                            try {
                                if (this.parser.readFrame(false)) ** GOTO lbl24
                                if (this.overheadCount.get() <= 0L) break;
                            }
                            catch (StreamException var3_4) {
                                try {
                                    var4_8 = this.getStream(var3_4.getStreamId(), false);
                                    if (var4_8 == null) {
                                        this.sendStreamReset(var3_4);
                                        continue;
                                    }
                                    var4_8.close(var3_4);
                                    if (this.overheadCount.get() <= 0L) continue;
                                }
                                catch (Throwable var5_9) {
                                    if (this.overheadCount.get() > 0L) {
                                        throw new ConnectionException(Http2UpgradeHandler.sm.getString("upgradeHandler.tooMuchOverhead", new Object[]{this.connectionId}), Http2Error.ENHANCE_YOUR_CALM);
                                    }
                                    throw var5_9;
                                }
                                throw new ConnectionException(Http2UpgradeHandler.sm.getString("upgradeHandler.tooMuchOverhead", new Object[]{this.connectionId}), Http2Error.ENHANCE_YOUR_CALM);
                            }
                            throw new ConnectionException(Http2UpgradeHandler.sm.getString("upgradeHandler.tooMuchOverhead", new Object[]{this.connectionId}), Http2Error.ENHANCE_YOUR_CALM);
lbl24:
                            // 1 sources

                            if (this.overheadCount.get() <= 0L) ** GOTO lbl-1000
                            throw new ConnectionException(Http2UpgradeHandler.sm.getString("upgradeHandler.tooMuchOverhead", new Object[]{this.connectionId}), Http2Error.ENHANCE_YOUR_CALM);
                            break;
                        }
                        this.socketWrapper.setReadTimeout(-1L);
                        this.setConnectionTimeoutForStreamCount(this.activeRemoteStreamCount.get());
                    }
                    catch (Http2Exception var3_5) {
                        if (Http2UpgradeHandler.log.isDebugEnabled()) {
                            Http2UpgradeHandler.log.debug((Object)Http2UpgradeHandler.sm.getString("upgradeHandler.connectionError"), (Throwable)var3_5);
                        }
                        this.closeConnection(var3_5);
                        break;
                    }
                    if (this.connectionState.get() == ConnectionState.CLOSED) break;
                    var2_2 = AbstractEndpoint.Handler.SocketState.UPGRADED;
                    break;
                }
                case 2: {
                    this.processWrites();
                    var2_2 = AbstractEndpoint.Handler.SocketState.UPGRADED;
                    break;
                }
                case 3: {
                    this.closeConnection(null);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.close();
                }
            }
        }
        catch (IOException var3_6) {
            if (Http2UpgradeHandler.log.isDebugEnabled()) {
                Http2UpgradeHandler.log.debug((Object)Http2UpgradeHandler.sm.getString("upgradeHandler.ioerror", new Object[]{this.connectionId}), (Throwable)var3_6);
            }
            this.close();
        }
        if (Http2UpgradeHandler.log.isDebugEnabled()) {
            Http2UpgradeHandler.log.debug((Object)Http2UpgradeHandler.sm.getString("upgradeHandler.upgradeDispatch.exit", new Object[]{this.connectionId, var2_2}));
        }
        return var2_2;
    }

    protected void setConnectionTimeoutForStreamCount(int n) {
        if (n == 0) {
            long l = this.protocol.getKeepAliveTimeout();
            if (l == -1L) {
                this.setConnectionTimeout(-1L);
            } else {
                this.setConnectionTimeout(System.currentTimeMillis() + l);
            }
        } else {
            this.setConnectionTimeout(-1L);
        }
    }

    private void setConnectionTimeout(long l) {
        this.connectionTimeout = l;
    }

    @Override
    public void timeoutAsync(long l) {
        long l2 = this.connectionTimeout;
        if (l == -1L || l2 > -1L && l > l2) {
            this.socketWrapper.processSocket(SocketEvent.TIMEOUT, true);
        }
    }

    ConnectionSettingsRemote getRemoteSettings() {
        return this.remoteSettings;
    }

    ConnectionSettingsLocal getLocalSettings() {
        return this.localSettings;
    }

    Http2Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public void pause() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.pause.entry", new Object[]{this.connectionId}));
        }
        if (this.connectionState.compareAndSet(ConnectionState.CONNECTED, ConnectionState.PAUSING)) {
            this.pausedNanoTime = System.nanoTime();
            try {
                this.writeGoAwayFrame(Integer.MAX_VALUE, Http2Error.NO_ERROR.getCode(), null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void destroy() {
    }

    void checkPauseState() throws IOException {
        if (this.connectionState.get() == ConnectionState.PAUSING && this.pausedNanoTime + this.pingManager.getRoundTripTimeNano() < System.nanoTime()) {
            this.connectionState.compareAndSet(ConnectionState.PAUSING, ConnectionState.PAUSED);
            this.writeGoAwayFrame(this.maxProcessedStreamId, Http2Error.NO_ERROR.getCode(), null);
        }
    }

    private int increaseStreamConcurrency() {
        return this.streamConcurrency.incrementAndGet();
    }

    private int decreaseStreamConcurrency() {
        return this.streamConcurrency.decrementAndGet();
    }

    private int getStreamConcurrency() {
        return this.streamConcurrency.get();
    }

    void executeQueuedStream() {
        StreamRunnable streamRunnable;
        if (this.streamConcurrency == null) {
            return;
        }
        this.decreaseStreamConcurrency();
        if (this.getStreamConcurrency() < this.protocol.getMaxConcurrentStreamExecution() && (streamRunnable = this.queuedRunnable.poll()) != null) {
            this.increaseStreamConcurrency();
            this.socketWrapper.execute(streamRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendStreamReset(StreamException streamException) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.rst.debug", new Object[]{this.connectionId, Integer.toString(streamException.getStreamId()), streamException.getError(), streamException.getMessage()}));
        }
        byte[] byArray = new byte[13];
        ByteUtil.setThreeBytes(byArray, 0, 4);
        byArray[3] = FrameType.RST.getIdByte();
        ByteUtil.set31Bits(byArray, 5, streamException.getStreamId());
        ByteUtil.setFourBytes(byArray, 9, streamException.getError().getCode());
        SocketWrapperBase<?> socketWrapperBase = this.socketWrapper;
        synchronized (socketWrapperBase) {
            this.socketWrapper.write(true, byArray, 0, byArray.length);
            this.socketWrapper.flush(true);
        }
    }

    void closeConnection(Http2Exception http2Exception) {
        byte[] byArray;
        long l;
        if (http2Exception == null) {
            l = Http2Error.NO_ERROR.getCode();
            byArray = null;
        } else {
            l = http2Exception.getError().getCode();
            byArray = http2Exception.getMessage().getBytes(StandardCharsets.UTF_8);
        }
        try {
            this.writeGoAwayFrame(this.maxProcessedStreamId, l, byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.close();
    }

    protected void writeSettings() {
        try {
            byte[] byArray = this.localSettings.getSettingsFrameForPending();
            this.socketWrapper.write(true, byArray, 0, byArray.length);
            byte[] byArray2 = this.createWindowUpdateForSettings();
            if (byArray2.length > 0) {
                this.socketWrapper.write(true, byArray2, 0, byArray2.length);
            }
            this.socketWrapper.flush(true);
        }
        catch (IOException iOException) {
            String string = sm.getString("upgradeHandler.sendPrefaceFail", new Object[]{this.connectionId});
            if (log.isDebugEnabled()) {
                log.debug((Object)string);
            }
            throw new ProtocolException(string, iOException);
        }
    }

    protected byte[] createWindowUpdateForSettings() {
        byte[] byArray;
        int n = this.protocol.getInitialWindowSize() - 65535;
        if (n > 0) {
            byArray = new byte[13];
            ByteUtil.setThreeBytes(byArray, 0, 4);
            byArray[3] = FrameType.WINDOW_UPDATE.getIdByte();
            ByteUtil.set31Bits(byArray, 9, n);
        } else {
            byArray = new byte[]{};
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeGoAwayFrame(int n, long l, byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[8];
        ByteUtil.set31Bits(byArray2, 0, n);
        ByteUtil.setFourBytes(byArray2, 4, l);
        int n2 = 8;
        if (byArray != null) {
            n2 += byArray.length;
        }
        byte[] byArray3 = new byte[3];
        ByteUtil.setThreeBytes(byArray3, 0, n2);
        SocketWrapperBase<?> socketWrapperBase = this.socketWrapper;
        synchronized (socketWrapperBase) {
            this.socketWrapper.write(true, byArray3, 0, byArray3.length);
            this.socketWrapper.write(true, GOAWAY, 0, GOAWAY.length);
            this.socketWrapper.write(true, byArray2, 0, 8);
            if (byArray != null) {
                this.socketWrapper.write(true, byArray, 0, byArray.length);
            }
            this.socketWrapper.flush(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeHeaders(Stream stream, int n, MimeHeaders mimeHeaders, boolean bl, int n2) throws IOException {
        SocketWrapperBase<?> socketWrapperBase = this.socketWrapper;
        synchronized (socketWrapperBase) {
            this.doWriteHeaders(stream, n, mimeHeaders, bl, n2);
        }
        stream.sentHeaders();
        if (bl) {
            stream.sentEndOfStream();
        }
    }

    protected HeaderFrameBuffers doWriteHeaders(Stream stream, int n, MimeHeaders mimeHeaders, boolean bl, int n2) throws IOException {
        if (log.isDebugEnabled()) {
            if (n == 0) {
                log.debug((Object)sm.getString("upgradeHandler.writeHeaders", new Object[]{this.connectionId, stream.getIdAsString(), bl}));
            } else {
                log.debug((Object)sm.getString("upgradeHandler.writePushHeaders", new Object[]{this.connectionId, stream.getIdAsString(), n, bl}));
            }
        }
        if (!stream.canWrite()) {
            return null;
        }
        HeaderFrameBuffers headerFrameBuffers = this.getHeaderFrameBuffers(n2);
        byte[] byArray = null;
        if (n > 0) {
            byArray = new byte[4];
            ByteUtil.set31Bits(byArray, 0, n);
        }
        boolean bl2 = true;
        HpackEncoder.State state = null;
        while (state != HpackEncoder.State.COMPLETE) {
            headerFrameBuffers.startFrame();
            if (bl2 && byArray != null) {
                headerFrameBuffers.getPayload().put(byArray);
            }
            state = this.getHpackEncoder().encode(mimeHeaders, headerFrameBuffers.getPayload());
            headerFrameBuffers.getPayload().flip();
            if (state == HpackEncoder.State.COMPLETE || headerFrameBuffers.getPayload().limit() > 0) {
                ByteUtil.setThreeBytes(headerFrameBuffers.getHeader(), 0, headerFrameBuffers.getPayload().limit());
                if (bl2) {
                    bl2 = false;
                    headerFrameBuffers.getHeader()[3] = byArray == null ? FrameType.HEADERS.getIdByte() : FrameType.PUSH_PROMISE.getIdByte();
                    if (bl) {
                        headerFrameBuffers.getHeader()[4] = 1;
                    }
                } else {
                    headerFrameBuffers.getHeader()[3] = FrameType.CONTINUATION.getIdByte();
                }
                if (state == HpackEncoder.State.COMPLETE) {
                    byte[] byArray2 = headerFrameBuffers.getHeader();
                    byArray2[4] = (byte)(byArray2[4] + 4);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(headerFrameBuffers.getPayload().limit() + " bytes"));
                }
                ByteUtil.set31Bits(headerFrameBuffers.getHeader(), 5, stream.getIdAsInt());
                headerFrameBuffers.endFrame();
                continue;
            }
            if (state != HpackEncoder.State.UNDERFLOW) continue;
            headerFrameBuffers.expandPayload();
        }
        headerFrameBuffers.endHeaders();
        return headerFrameBuffers;
    }

    protected HeaderFrameBuffers getHeaderFrameBuffers(int n) {
        return new DefaultHeaderFrameBuffers(n);
    }

    protected HpackEncoder getHpackEncoder() {
        if (this.hpackEncoder == null) {
            this.hpackEncoder = new HpackEncoder();
        }
        this.hpackEncoder.setMaxTableSize(this.remoteSettings.getHeaderTableSize());
        return this.hpackEncoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeBody(Stream stream, ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.writeBody", new Object[]{this.connectionId, stream.getIdAsString(), Integer.toString(n), bl}));
        }
        this.reduceOverheadCount();
        boolean bl2 = stream.canWrite();
        byte[] byArray = new byte[9];
        ByteUtil.setThreeBytes(byArray, 0, n);
        byArray[3] = FrameType.DATA.getIdByte();
        if (bl) {
            byArray[4] = 1;
            stream.sentEndOfStream();
            if (!stream.isActive()) {
                this.setConnectionTimeoutForStreamCount(this.activeRemoteStreamCount.decrementAndGet());
            }
        }
        if (bl2) {
            ByteUtil.set31Bits(byArray, 5, stream.getIdAsInt());
            SocketWrapperBase<?> socketWrapperBase = this.socketWrapper;
            synchronized (socketWrapperBase) {
                try {
                    this.socketWrapper.write(true, byArray, 0, byArray.length);
                    int n2 = byteBuffer.limit();
                    byteBuffer.limit(byteBuffer.position() + n);
                    this.socketWrapper.write(true, byteBuffer);
                    byteBuffer.limit(n2);
                    this.socketWrapper.flush(true);
                }
                catch (IOException iOException) {
                    this.handleAppInitiatedIOException(iOException);
                }
            }
        }
    }

    protected void handleAppInitiatedIOException(IOException iOException) throws IOException {
        this.close();
        throw iOException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeWindowUpdate(AbstractNonZeroStream abstractNonZeroStream, int n, boolean bl) throws IOException {
        SocketWrapperBase<?> socketWrapperBase = this.socketWrapper;
        synchronized (socketWrapperBase) {
            byte[] byArray = new byte[13];
            ByteUtil.setThreeBytes(byArray, 0, 4);
            byArray[3] = FrameType.WINDOW_UPDATE.getIdByte();
            ByteUtil.set31Bits(byArray, 9, n);
            this.socketWrapper.write(true, byArray, 0, byArray.length);
            if (abstractNonZeroStream instanceof Stream && ((Stream)abstractNonZeroStream).canWrite()) {
                ByteUtil.set31Bits(byArray, 5, abstractNonZeroStream.getIdAsInt());
                try {
                    this.socketWrapper.write(true, byArray, 0, byArray.length);
                    this.socketWrapper.flush(true);
                }
                catch (IOException iOException) {
                    if (bl) {
                        this.handleAppInitiatedIOException(iOException);
                    }
                    throw iOException;
                }
            } else {
                this.socketWrapper.flush(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processWrites() throws IOException {
        SocketWrapperBase<?> socketWrapperBase = this.socketWrapper;
        synchronized (socketWrapperBase) {
            if (this.socketWrapper.flush(false)) {
                this.socketWrapper.registerWriteInterest();
            } else {
                this.pingManager.sendPing(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int reserveWindowSize(Stream stream, int n, boolean bl) throws IOException {
        int n2 = 0;
        Stream stream2 = stream;
        synchronized (stream2) {
            do {
                Object object;
                Http2UpgradeHandler http2UpgradeHandler = this;
                synchronized (http2UpgradeHandler) {
                    block20: {
                        long l;
                        block21: {
                            block22: {
                                void var10_14;
                                if (!stream.canWrite()) {
                                    stream.doStreamCancel(sm.getString("upgradeHandler.stream.notWritable"), Http2Error.STREAM_CLOSED);
                                }
                                if ((l = this.getWindowSize()) >= 1L && this.backLogSize <= 0L) break block21;
                                object = this.backLogStreams.get(stream);
                                if (object != null) break block22;
                                object = new BacklogTracker(n);
                                this.backLogStreams.put(stream, (BacklogTracker)object);
                                this.backLogSize += (long)n;
                                AbstractStream abstractStream = stream.getParentStream();
                                while (var10_14 != null && this.backLogStreams.putIfAbsent((AbstractStream)var10_14, new BacklogTracker()) == null) {
                                    AbstractStream abstractStream2 = var10_14.getParentStream();
                                }
                                break block20;
                            }
                            if (((BacklogTracker)object).getUnusedAllocation() > 0) {
                                n2 = ((BacklogTracker)object).getUnusedAllocation();
                                this.decrementWindowSize(n2);
                                if (((BacklogTracker)object).getRemainingReservation() == 0) {
                                    this.backLogStreams.remove(stream);
                                    break block20;
                                } else {
                                    ((BacklogTracker)object).useAllocation();
                                }
                            }
                            break block20;
                        }
                        if (l < (long)n) {
                            n2 = (int)l;
                            this.decrementWindowSize(n2);
                        } else {
                            n2 = n;
                            this.decrementWindowSize(n2);
                        }
                    }
                    if (n2 != 0) continue;
                }
                if (!bl) {
                    stream.waitForConnectionAllocationNonBlocking();
                    return 0;
                }
                try {
                    void var10_18;
                    long l = this.protocol.getWriteTimeout();
                    stream.waitForConnectionAllocation(l);
                    object = this;
                    synchronized (object) {
                        BacklogTracker backlogTracker = this.backLogStreams.get(stream);
                        if (backlogTracker == null || backlogTracker.getUnusedAllocation() != 0) continue;
                    }
                    if (stream.isActive()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("upgradeHandler.noAllocation", new Object[]{this.connectionId, stream.getIdAsString()}));
                        }
                        this.close();
                        object = sm.getString("stream.writeTimeout");
                        Http2Error http2Error = Http2Error.ENHANCE_YOUR_CALM;
                    } else {
                        object = sm.getString("stream.clientCancel");
                        Http2Error http2Error = Http2Error.STREAM_CLOSED;
                    }
                    stream.doStreamCancel((String)object, (Http2Error)var10_18);
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(sm.getString("upgradeHandler.windowSizeReservationInterrupted", new Object[]{this.connectionId, stream.getIdAsString(), Integer.toString(n)}), interruptedException);
                }
            } while (n2 == 0);
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void incrementWindowSize(int n) throws Http2Exception {
        Set<AbstractStream> set = null;
        Http2UpgradeHandler http2UpgradeHandler = this;
        synchronized (http2UpgradeHandler) {
            long l = this.getWindowSize();
            if (l < 1L && l + (long)n > 0L) {
                set = this.releaseBackLog((int)(l + (long)n));
            }
            super.incrementWindowSize(n);
        }
        if (set != null) {
            for (AbstractStream abstractStream : set) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("upgradeHandler.releaseBacklog", new Object[]{this.connectionId, abstractStream.getIdAsString()}));
                }
                if (this == abstractStream) continue;
                ((Stream)abstractStream).notifyConnection();
            }
        }
    }

    protected SendfileState processSendfile(SendfileData sendfileData) {
        return SendfileState.DONE;
    }

    private synchronized Set<AbstractStream> releaseBackLog(int n) {
        HashSet<AbstractStream> hashSet = new HashSet<AbstractStream>();
        if (this.backLogSize < (long)n) {
            hashSet.addAll(this.backLogStreams.keySet());
            this.backLogStreams.clear();
            this.backLogSize = 0L;
        } else {
            int n2 = n;
            while (n2 > 0) {
                n2 = this.allocate(this, n2);
            }
            for (Map.Entry<AbstractStream, BacklogTracker> entry : this.backLogStreams.entrySet()) {
                int n3 = entry.getValue().getUnusedAllocation();
                if (n3 <= 0) continue;
                this.backLogSize -= (long)n3;
                if (entry.getValue().isNotifyInProgress()) continue;
                hashSet.add(entry.getKey());
                entry.getValue().startNotify();
            }
        }
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    private int allocate(AbstractStream abstractStream, int n) {
        BacklogTracker backlogTracker;
        int n2;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.allocate.debug", new Object[]{this.getConnectionId(), abstractStream.getIdAsString(), Integer.toString(n)}));
        }
        if ((n2 = (backlogTracker = this.backLogStreams.get(abstractStream)).allocate(n)) == 0) {
            return 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.allocate.left", new Object[]{this.getConnectionId(), abstractStream.getIdAsString(), Integer.toString(n2)}));
        }
        HashSet<AbstractNonZeroStream> hashSet = new HashSet<AbstractNonZeroStream>(abstractStream.getChildStreams());
        hashSet.retainAll(this.backLogStreams.keySet());
        while (n2 > 0) {
            void n4;
            if (hashSet.size() == 0) {
                this.backLogStreams.remove(abstractStream);
                return n2;
            }
            int n3 = 0;
            for (AbstractStream abstractStream2 : hashSet) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("upgradeHandler.allocate.recipient", new Object[]{this.getConnectionId(), abstractStream.getIdAsString(), abstractStream2.getIdAsString(), Integer.toString(abstractStream2.getWeight())}));
                }
                n3 += abstractStream2.getWeight();
            }
            Iterator iterator = hashSet.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                int n5;
                AbstractStream abstractStream2 = (AbstractStream)iterator.next();
                int n6 = n2 * abstractStream2.getWeight() / n3;
                if (n6 == 0) {
                    n6 = 1;
                }
                if ((n5 = this.allocate(abstractStream2, n6)) > 0) {
                    iterator.remove();
                }
                n4 += n6 - n5;
            }
            n2 -= n4;
        }
        return 0;
    }

    private Stream getStream(int n) {
        Integer n2 = n;
        AbstractStream abstractStream = (AbstractStream)this.streams.get(n2);
        if (abstractStream instanceof Stream) {
            return (Stream)abstractStream;
        }
        return null;
    }

    private Stream getStream(int n, boolean bl) throws ConnectionException {
        Stream stream = this.getStream(n);
        if (stream == null && bl) {
            throw new ConnectionException(sm.getString("upgradeHandler.stream.closed", new Object[]{Integer.toString(n)}), Http2Error.PROTOCOL_ERROR);
        }
        return stream;
    }

    private AbstractNonZeroStream getAbstractNonZeroStream(int n) {
        Integer n2 = n;
        return (AbstractNonZeroStream)this.streams.get(n2);
    }

    private AbstractNonZeroStream getAbstractNonZeroStream(int n, boolean bl) throws ConnectionException {
        AbstractNonZeroStream abstractNonZeroStream = this.getAbstractNonZeroStream(n);
        if (abstractNonZeroStream == null && bl) {
            throw new ConnectionException(sm.getString("upgradeHandler.stream.closed", new Object[]{Integer.toString(n)}), Http2Error.PROTOCOL_ERROR);
        }
        return abstractNonZeroStream;
    }

    private Stream createRemoteStream(int n) throws ConnectionException {
        Integer n2 = n;
        if (n % 2 != 1) {
            throw new ConnectionException(sm.getString("upgradeHandler.stream.even", new Object[]{n2}), Http2Error.PROTOCOL_ERROR);
        }
        this.pruneClosedStreams(n);
        Stream stream = new Stream(n2, this);
        this.streams.put(n2, stream);
        return stream;
    }

    private Stream createLocalStream(Request request) {
        int n = this.nextLocalStreamId.getAndAdd(2);
        Integer n2 = n;
        Stream stream = new Stream(n2, this, request);
        this.streams.put(n2, stream);
        return stream;
    }

    private void close() {
        ConnectionState connectionState = this.connectionState.getAndSet(ConnectionState.CLOSED);
        if (connectionState == ConnectionState.CLOSED) {
            return;
        }
        for (AbstractNonZeroStream abstractNonZeroStream : this.streams.values()) {
            if (!(abstractNonZeroStream instanceof Stream)) continue;
            ((Stream)abstractNonZeroStream).receiveReset(Http2Error.CANCEL.getCode());
        }
        try {
            this.socketWrapper.close();
        }
        catch (Exception exception) {
            log.debug((Object)sm.getString("upgradeHandler.socketCloseFailed"), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneClosedStreams(int n) {
        int n2;
        if (this.newStreamsSinceLastPrune < 9) {
            ++this.newStreamsSinceLastPrune;
            return;
        }
        this.newStreamsSinceLastPrune = 0;
        long l = this.localSettings.getMaxConcurrentStreams();
        if ((l *= 5L) > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        int n3 = this.streams.size();
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.pruneStart", new Object[]{this.connectionId, Long.toString(l), Integer.toString(n3)}));
        }
        if ((n2 = n3 - (int)l) < 1) {
            return;
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
        Object object = this.priorityTreeLock;
        synchronized (object) {
            for (AbstractNonZeroStream abstractNonZeroStream : this.streams.values()) {
                if (abstractNonZeroStream instanceof Stream && ((Stream)abstractNonZeroStream).isActive()) continue;
                if (abstractNonZeroStream.isClosedFinal()) {
                    treeSet2.add(abstractNonZeroStream.getIdentifier());
                    continue;
                }
                if (abstractNonZeroStream.getChildStreams().size() == 0) {
                    AbstractStream abstractStream = abstractNonZeroStream.getParentStream();
                    this.streams.remove(abstractNonZeroStream.getIdentifier());
                    abstractNonZeroStream.detachFromParent();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("upgradeHandler.pruned", new Object[]{this.connectionId, abstractNonZeroStream.getIdAsString()}));
                    }
                    if (--n2 < 1) {
                        return;
                    }
                    while (n2 > 0 && abstractStream.getIdAsInt() > 0 && abstractStream.getIdAsInt() < abstractNonZeroStream.getIdAsInt() && abstractStream.getChildStreams().isEmpty()) {
                        abstractNonZeroStream = (AbstractNonZeroStream)abstractStream;
                        abstractStream = abstractNonZeroStream.getParentStream();
                        this.streams.remove(abstractNonZeroStream.getIdentifier());
                        abstractNonZeroStream.detachFromParent();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("upgradeHandler.pruned", new Object[]{this.connectionId, abstractNonZeroStream.getIdAsString()}));
                        }
                        if (--n2 < 1) {
                            return;
                        }
                        treeSet.remove(abstractNonZeroStream.getIdentifier());
                    }
                    continue;
                }
                treeSet.add(abstractNonZeroStream.getIdentifier());
            }
        }
        for (Integer n4 : treeSet) {
            this.removeStreamFromPriorityTree(n4);
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("upgradeHandler.pruned", new Object[]{this.connectionId, n4}));
            }
            if (--n2 >= 1) continue;
            return;
        }
        while (n2 > 0 && treeSet2.size() > 0) {
            object = (Integer)treeSet2.pollLast();
            this.removeStreamFromPriorityTree((Integer)object);
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("upgradeHandler.prunedPriority", new Object[]{this.connectionId, object}));
            }
            if (--n2 >= 1) continue;
            return;
        }
        if (n2 > 0) {
            log.warn((Object)sm.getString("upgradeHandler.pruneIncomplete", new Object[]{this.connectionId, Integer.toString(n), Integer.toString(n2)}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStreamFromPriorityTree(Integer n) {
        Object object = this.priorityTreeLock;
        synchronized (object) {
            AbstractNonZeroStream abstractNonZeroStream = (AbstractNonZeroStream)this.streams.remove(n);
            Set<AbstractNonZeroStream> set = abstractNonZeroStream.getChildStreams();
            if (set.size() == 1) {
                set.iterator().next().rePrioritise(abstractNonZeroStream.getParentStream(), abstractNonZeroStream.getWeight());
            } else {
                int n2 = 0;
                for (AbstractNonZeroStream abstractNonZeroStream2 : set) {
                    n2 += abstractNonZeroStream2.getWeight();
                }
                for (AbstractNonZeroStream abstractNonZeroStream2 : set) {
                    set.iterator().next().rePrioritise(abstractNonZeroStream.getParentStream(), abstractNonZeroStream.getWeight() * abstractNonZeroStream2.getWeight() / n2);
                }
            }
            abstractNonZeroStream.detachFromParent();
            set.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void push(Request request, Stream stream) throws IOException {
        Stream stream2;
        if (this.localSettings.getMaxConcurrentStreams() < (long)this.activeRemoteStreamCount.incrementAndGet()) {
            this.setConnectionTimeoutForStreamCount(this.activeRemoteStreamCount.decrementAndGet());
            return;
        }
        SocketWrapperBase<?> socketWrapperBase = this.socketWrapper;
        synchronized (socketWrapperBase) {
            stream2 = this.createLocalStream(request);
            this.writeHeaders(stream, stream2.getIdAsInt(), request.getMimeHeaders(), false, 1024);
        }
        stream2.sentPushPromise();
        this.processStreamOnContainerThread(stream2);
    }

    @Override
    protected final String getConnectionId() {
        return this.connectionId;
    }

    @Override
    protected final int getWeight() {
        return 0;
    }

    private void reduceOverheadCount() {
        this.overheadCount.decrementAndGet();
    }

    private void increaseOverheadCount() {
        this.overheadCount.addAndGet(this.getProtocol().getOverheadCountFactor());
    }

    @Override
    public boolean fill(boolean bl, byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        boolean bl2 = bl;
        int n4 = 0;
        for (int i = n2; i > 0; i -= n4) {
            n4 = this.socketWrapper.read(bl2, byArray, n3, i);
            if (n4 == 0) {
                if (bl2) {
                    throw new IllegalStateException();
                }
                return false;
            }
            if (n4 == -1) {
                if (this.connectionState.get().isNewStreamAllowed()) {
                    throw new EOFException();
                }
                return false;
            }
            n3 += n4;
            bl2 = true;
        }
        return true;
    }

    @Override
    public int getMaxFrameSize() {
        return this.localSettings.getMaxFrameSize();
    }

    @Override
    public HpackDecoder getHpackDecoder() {
        if (this.hpackDecoder == null) {
            this.hpackDecoder = new HpackDecoder(this.localSettings.getHeaderTableSize());
        }
        return this.hpackDecoder;
    }

    @Override
    public ByteBuffer startRequestBodyFrame(int n, int n2, boolean bl) throws Http2Exception {
        this.reduceOverheadCount();
        if (!bl) {
            int n3 = this.protocol.getOverheadDataThreshold();
            int n4 = (this.lastNonFinalDataPayload >> 1) + (n2 >> 1);
            this.lastNonFinalDataPayload = n2;
            if (n4 == 0) {
                n4 = 1;
            }
            if (n4 < n3) {
                this.overheadCount.addAndGet(n3 / n4);
            }
        }
        AbstractNonZeroStream abstractNonZeroStream = this.getAbstractNonZeroStream(n, true);
        abstractNonZeroStream.checkState(FrameType.DATA);
        abstractNonZeroStream.receivedData(n2);
        ByteBuffer byteBuffer = abstractNonZeroStream.getInputByteBuffer();
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.startRequestBodyFrame.result", new Object[]{this.getConnectionId(), abstractNonZeroStream.getIdAsString(), byteBuffer}));
        }
        return byteBuffer;
    }

    @Override
    public void endRequestBodyFrame(int n, int n2) throws Http2Exception, IOException {
        AbstractNonZeroStream abstractNonZeroStream = this.getAbstractNonZeroStream(n, true);
        if (abstractNonZeroStream instanceof Stream) {
            ((Stream)abstractNonZeroStream).getInputBuffer().onDataAvailable();
        } else {
            this.onSwallowedDataFramePayload(n, n2);
        }
    }

    @Override
    public void receivedEndOfStream(int n) throws ConnectionException {
        AbstractNonZeroStream abstractNonZeroStream = this.getAbstractNonZeroStream(n, this.connectionState.get().isNewStreamAllowed());
        if (abstractNonZeroStream instanceof Stream) {
            Stream stream = (Stream)abstractNonZeroStream;
            stream.receivedEndOfStream();
            if (!stream.isActive()) {
                this.setConnectionTimeoutForStreamCount(this.activeRemoteStreamCount.decrementAndGet());
            }
        }
    }

    @Override
    public void onSwallowedDataFramePayload(int n, int n2) throws IOException {
        AbstractNonZeroStream abstractNonZeroStream = this.getAbstractNonZeroStream(n);
        this.writeWindowUpdate(abstractNonZeroStream, n2, false);
    }

    @Override
    public HpackDecoder.HeaderEmitter headersStart(int n, boolean bl) throws Http2Exception, IOException {
        this.checkPauseState();
        if (this.connectionState.get().isNewStreamAllowed()) {
            Stream stream = this.getStream(n, false);
            if (stream == null) {
                stream = this.createRemoteStream(n);
            }
            if (n < this.maxActiveRemoteStreamId) {
                throw new ConnectionException(sm.getString("upgradeHandler.stream.old", new Object[]{n, this.maxActiveRemoteStreamId}), Http2Error.PROTOCOL_ERROR);
            }
            stream.checkState(FrameType.HEADERS);
            stream.receivedStartOfHeaders(bl);
            this.closeIdleStreams(n);
            return stream;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.noNewStreams", new Object[]{this.connectionId, Integer.toString(n)}));
        }
        this.reduceOverheadCount();
        return HEADER_SINK;
    }

    private void closeIdleStreams(int n) {
        NavigableMap navigableMap = this.streams.subMap((Object)this.maxActiveRemoteStreamId, false, (Object)n, false);
        for (AbstractNonZeroStream abstractNonZeroStream : navigableMap.values()) {
            if (!(abstractNonZeroStream instanceof Stream)) continue;
            ((Stream)abstractNonZeroStream).closeIfIdle();
        }
        this.maxActiveRemoteStreamId = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reprioritise(int n, int n2, boolean bl, int n3) throws Http2Exception {
        AbstractStream abstractStream;
        if (n == n2) {
            throw new ConnectionException(sm.getString("upgradeHandler.dependency.invalid", new Object[]{this.getConnectionId(), n}), Http2Error.PROTOCOL_ERROR);
        }
        this.increaseOverheadCount();
        AbstractNonZeroStream abstractNonZeroStream = this.getAbstractNonZeroStream(n);
        if (abstractNonZeroStream == null) {
            abstractNonZeroStream = this.createRemoteStream(n);
        }
        if ((abstractStream = this.getAbstractNonZeroStream(n2)) == null) {
            abstractStream = this;
        }
        Object object = this.priorityTreeLock;
        synchronized (object) {
            abstractNonZeroStream.rePrioritise(abstractStream, bl, n3);
        }
    }

    @Override
    public void headersContinue(int n, boolean bl) {
        int n2;
        if (!bl && n < (n2 = this.getProtocol().getOverheadContinuationThreshold())) {
            if (n == 0) {
                this.overheadCount.addAndGet(n2);
            } else {
                this.overheadCount.addAndGet(n2 / n);
            }
        }
    }

    @Override
    public void headersEnd(int n) throws Http2Exception {
        AbstractNonZeroStream abstractNonZeroStream = this.getAbstractNonZeroStream(n, this.connectionState.get().isNewStreamAllowed());
        if (abstractNonZeroStream instanceof Stream) {
            this.setMaxProcessedStream(n);
            Stream stream = (Stream)abstractNonZeroStream;
            if (stream.isActive() && stream.receivedEndOfHeaders()) {
                if (this.localSettings.getMaxConcurrentStreams() < (long)this.activeRemoteStreamCount.incrementAndGet()) {
                    this.setConnectionTimeoutForStreamCount(this.activeRemoteStreamCount.decrementAndGet());
                    this.increaseOverheadCount();
                    throw new StreamException(sm.getString("upgradeHandler.tooManyRemoteStreams", new Object[]{Long.toString(this.localSettings.getMaxConcurrentStreams())}), Http2Error.REFUSED_STREAM, n);
                }
                this.reduceOverheadCount();
                this.processStreamOnContainerThread(stream);
            }
        }
    }

    private void setMaxProcessedStream(int n) {
        if (this.maxProcessedStreamId < n) {
            this.maxProcessedStreamId = n;
        }
    }

    @Override
    public void reset(int n, long l) throws Http2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.reset.receive", new Object[]{this.getConnectionId(), Integer.toString(n), Long.toString(l)}));
        }
        AbstractNonZeroStream abstractNonZeroStream = this.getAbstractNonZeroStream(n, true);
        abstractNonZeroStream.checkState(FrameType.RST);
        if (abstractNonZeroStream instanceof Stream) {
            Stream stream = (Stream)abstractNonZeroStream;
            boolean bl = stream.isActive();
            stream.receiveReset(l);
            if (bl) {
                this.activeRemoteStreamCount.decrementAndGet();
            }
        }
    }

    @Override
    public void setting(Setting setting, long l) throws ConnectionException {
        this.increaseOverheadCount();
        if (setting == null) {
            return;
        }
        if (setting == Setting.INITIAL_WINDOW_SIZE) {
            long l2 = this.remoteSettings.getInitialWindowSize();
            this.remoteSettings.set(setting, l);
            int n = (int)(l - l2);
            for (AbstractNonZeroStream abstractNonZeroStream : this.streams.values()) {
                try {
                    abstractNonZeroStream.incrementWindowSize(n);
                }
                catch (Http2Exception http2Exception) {
                    ((Stream)abstractNonZeroStream).close(new StreamException(sm.getString("upgradeHandler.windowSizeTooBig", new Object[]{this.connectionId, abstractNonZeroStream.getIdAsString()}), http2Exception.getError(), abstractNonZeroStream.getIdAsInt()));
                }
            }
        } else {
            this.remoteSettings.set(setting, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingsEnd(boolean bl) throws IOException {
        if (bl) {
            if (!this.localSettings.ack()) {
                log.warn((Object)sm.getString("upgradeHandler.unexpectedAck", new Object[]{this.connectionId, this.getIdAsString()}));
            }
        } else {
            SocketWrapperBase<?> socketWrapperBase = this.socketWrapper;
            synchronized (socketWrapperBase) {
                this.socketWrapper.write(true, SETTINGS_ACK, 0, SETTINGS_ACK.length);
                this.socketWrapper.flush(true);
            }
        }
    }

    @Override
    public void pingReceive(byte[] byArray, boolean bl) throws IOException {
        if (!bl) {
            this.increaseOverheadCount();
        }
        this.pingManager.receivePing(byArray, bl);
    }

    @Override
    public void goaway(int n, long l, String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.goaway.debug", new Object[]{this.connectionId, Integer.toString(n), Long.toHexString(l), string}));
        }
        this.close();
    }

    @Override
    public void incrementWindowSize(int n, int n2) throws Http2Exception {
        int n3 = (this.lastWindowUpdate >> 1) + (n2 >> 1);
        int n4 = this.protocol.getOverheadWindowUpdateThreshold();
        this.lastWindowUpdate = n2;
        if (n3 == 0) {
            n3 = 1;
        }
        if (n == 0) {
            if (n3 < n4) {
                this.overheadCount.addAndGet(n4 / n3);
            }
            this.incrementWindowSize(n2);
        } else {
            BacklogTracker backlogTracker;
            AbstractNonZeroStream abstractNonZeroStream = this.getAbstractNonZeroStream(n, true);
            if (n3 < n4 && ((backlogTracker = this.backLogStreams.get(abstractNonZeroStream)) == null || n2 < backlogTracker.getRemainingReservation())) {
                this.overheadCount.addAndGet(n4 / n3);
            }
            abstractNonZeroStream.checkState(FrameType.WINDOW_UPDATE);
            abstractNonZeroStream.incrementWindowSize(n2);
        }
    }

    @Override
    public void onSwallowedUnknownFrame(int n, int n2, int n3, int n4) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceStream(AbstractNonZeroStream abstractNonZeroStream, AbstractNonZeroStream abstractNonZeroStream2) {
        Object object = this.priorityTreeLock;
        synchronized (object) {
            AbstractNonZeroStream abstractNonZeroStream3 = (AbstractNonZeroStream)this.streams.get(abstractNonZeroStream.getIdentifier());
            if (abstractNonZeroStream3 instanceof Stream) {
                this.streams.put(abstractNonZeroStream.getIdentifier(), abstractNonZeroStream2);
                abstractNonZeroStream.replaceStream(abstractNonZeroStream2);
            }
        }
    }

    private static class BacklogTracker {
        private int remainingReservation;
        private int unusedAllocation;
        private boolean notifyInProgress;

        public BacklogTracker() {
        }

        public BacklogTracker(int n) {
            this.remainingReservation = n;
        }

        public int getRemainingReservation() {
            return this.remainingReservation;
        }

        public int getUnusedAllocation() {
            return this.unusedAllocation;
        }

        public boolean isNotifyInProgress() {
            return this.notifyInProgress;
        }

        public void useAllocation() {
            this.unusedAllocation = 0;
            this.notifyInProgress = false;
        }

        public void startNotify() {
            this.notifyInProgress = true;
        }

        private int allocate(int n) {
            if (this.remainingReservation >= n) {
                this.remainingReservation -= n;
                this.unusedAllocation += n;
                return 0;
            }
            int n2 = n - this.remainingReservation;
            this.unusedAllocation += this.remainingReservation;
            this.remainingReservation = 0;
            return n2;
        }
    }

    private class DefaultHeaderFrameBuffers
    implements HeaderFrameBuffers {
        private final byte[] header = new byte[9];
        private ByteBuffer payload;

        public DefaultHeaderFrameBuffers(int n) {
            this.payload = ByteBuffer.allocate(n);
        }

        @Override
        public void startFrame() {
        }

        @Override
        public void endFrame() throws IOException {
            try {
                Http2UpgradeHandler.this.socketWrapper.write(true, this.header, 0, this.header.length);
                Http2UpgradeHandler.this.socketWrapper.write(true, this.payload);
                Http2UpgradeHandler.this.socketWrapper.flush(true);
            }
            catch (IOException iOException) {
                Http2UpgradeHandler.this.handleAppInitiatedIOException(iOException);
            }
            this.payload.clear();
        }

        @Override
        public void endHeaders() {
        }

        @Override
        public byte[] getHeader() {
            return this.header;
        }

        @Override
        public ByteBuffer getPayload() {
            return this.payload;
        }

        @Override
        public void expandPayload() {
            this.payload = ByteBuffer.allocate(this.payload.capacity() * 2);
        }
    }

    protected static interface HeaderFrameBuffers {
        public void startFrame();

        public void endFrame() throws IOException;

        public void endHeaders() throws IOException;

        public byte[] getHeader();

        public ByteBuffer getPayload();

        public void expandPayload();
    }

    private static enum ConnectionState {
        NEW(true),
        CONNECTED(true),
        PAUSING(true),
        PAUSED(false),
        CLOSED(false);

        private final boolean newStreamsAllowed;

        private ConnectionState(boolean bl) {
            this.newStreamsAllowed = bl;
        }

        public boolean isNewStreamAllowed() {
            return this.newStreamsAllowed;
        }
    }

    protected static class PingRecord {
        private final int sequence;
        private final long sentNanoTime;

        public PingRecord(int n, long l) {
            this.sequence = n;
            this.sentNanoTime = l;
        }

        public int getSequence() {
            return this.sequence;
        }

        public long getSentNanoTime() {
            return this.sentNanoTime;
        }
    }

    protected class PingManager {
        protected boolean initiateDisabled = false;
        protected final long pingIntervalNano = 10000000000L;
        protected int sequence = 0;
        protected long lastPingNanoTime = Long.MIN_VALUE;
        protected Queue<PingRecord> inflightPings = new ConcurrentLinkedQueue<PingRecord>();
        protected Queue<Long> roundTripTimes = new ConcurrentLinkedQueue<Long>();

        protected PingManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendPing(boolean bl) throws IOException {
            if (this.initiateDisabled) {
                return;
            }
            long l = System.nanoTime();
            if (bl || l - this.lastPingNanoTime > 10000000000L) {
                this.lastPingNanoTime = l;
                byte[] byArray = new byte[8];
                SocketWrapperBase<?> socketWrapperBase = Http2UpgradeHandler.this.socketWrapper;
                synchronized (socketWrapperBase) {
                    int n = ++this.sequence;
                    PingRecord pingRecord = new PingRecord(n, l);
                    this.inflightPings.add(pingRecord);
                    ByteUtil.set31Bits(byArray, 4, n);
                    Http2UpgradeHandler.this.socketWrapper.write(true, PING, 0, PING.length);
                    Http2UpgradeHandler.this.socketWrapper.write(true, byArray, 0, byArray.length);
                    Http2UpgradeHandler.this.socketWrapper.flush(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receivePing(byte[] byArray, boolean bl) throws IOException {
            if (bl) {
                int n = ByteUtil.get31Bits(byArray, 4);
                PingRecord pingRecord = this.inflightPings.poll();
                while (pingRecord != null && pingRecord.getSequence() < n) {
                    pingRecord = this.inflightPings.poll();
                }
                if (pingRecord != null) {
                    long l = System.nanoTime() - pingRecord.getSentNanoTime();
                    this.roundTripTimes.add(l);
                    while (this.roundTripTimes.size() > 3) {
                        this.roundTripTimes.poll();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("pingManager.roundTripTime", new Object[]{Http2UpgradeHandler.this.connectionId, l}));
                    }
                }
            } else {
                SocketWrapperBase<?> socketWrapperBase = Http2UpgradeHandler.this.socketWrapper;
                synchronized (socketWrapperBase) {
                    Http2UpgradeHandler.this.socketWrapper.write(true, PING_ACK, 0, PING_ACK.length);
                    Http2UpgradeHandler.this.socketWrapper.write(true, byArray, 0, byArray.length);
                    Http2UpgradeHandler.this.socketWrapper.flush(true);
                }
            }
        }

        public long getRoundTripTimeNano() {
            return (long)this.roundTripTimes.stream().mapToLong(Long::longValue).average().orElse(0.0);
        }
    }
}

