/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.DefaultNameGenerator;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.UnionType;

public final class Es6ForOfConverter
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.FOR_OF);
    private final boolean addTypes;
    private final JSTypeRegistry registry;
    private final JSType unknownType;
    private final JSType makeIteratorTypeArg;
    private final DefaultNameGenerator namer;
    private final AstFactory astFactory;
    private static final String ITER_BASE = "$jscomp$iter$";
    private static final String ITER_RESULT = "$jscomp$key$";

    public Es6ForOfConverter(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.addTypes = compiler.hasTypeCheckingRun();
        this.registry = compiler.getTypeRegistry();
        this.unknownType = Es6ToEs3Util.createType(this.addTypes, this.registry, JSTypeNative.UNKNOWN_TYPE);
        this.makeIteratorTypeArg = this.createMakeIteratorTypeArg();
        this.namer = new DefaultNameGenerator();
        this.astFactory = compiler.createAstFactory();
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isForOf()) {
            this.visitForOf(n, parent);
        }
    }

    private void visitForOf(Node node, Node parent) {
        Node declarationOrAssign;
        Node variable = node.removeFirstChild();
        Node iterable = node.removeFirstChild();
        Node body = node.removeFirstChild();
        JSType typeParam = this.unknownType;
        if (this.addTypes) {
            ObjectType iterableType;
            ObjectType objectType = iterableType = iterable.getJSType() != null ? iterable.getJSType().autobox().toMaybeObjectType() : null;
            if (iterableType != null) {
                typeParam = iterableType.getTemplateTypeMap().getResolvedTemplateType(this.registry.getIterableTemplate());
            }
        }
        JSType iteratorType = this.createGenericType(JSTypeNative.ITERATOR_TYPE, typeParam);
        FunctionType iteratorNextType = this.addTypes ? iteratorType.toMaybeObjectType().getPropertyType("next").toMaybeFunctionType() : null;
        JSType iIterableResultType = this.unknownType;
        if (this.addTypes && iteratorNextType != null) {
            iIterableResultType = iteratorNextType.getReturnType();
        }
        JSDocInfo varJSDocInfo = variable.getJSDocInfo();
        Node iterName = this.astFactory.createName(ITER_BASE + this.compiler.getUniqueNameIdSupplier().get(), iteratorType);
        iterName.makeNonIndexable();
        Node getNext = this.astFactory.createCall(this.astFactory.createGetProp(iterName.cloneTree(), "next"), new Node[0]);
        String iteratorResultName = ITER_RESULT;
        iteratorResultName = NodeUtil.isNameDeclaration(variable) ? iteratorResultName + variable.getFirstChild().getString() : (variable.isName() ? iteratorResultName + variable.getString() : iteratorResultName + this.namer.generateNextName());
        Node iterResult = this.astFactory.createName(iteratorResultName, iIterableResultType);
        iterResult.makeNonIndexable();
        Node call = Es6ToEs3Util.makeIterator(this.compiler, iterable);
        if (this.addTypes) {
            Node getProp = call.getFirstChild();
            getProp.setJSType(this.registry.createFunctionType(iteratorType, this.makeIteratorTypeArg));
            getProp.getFirstChild().setJSType(this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE));
            getProp.getSecondChild().setJSType(this.registry.getNativeType(JSTypeNative.STRING_TYPE));
            call.setJSType(iteratorType);
        }
        Node init = IR.var(Es6ToEs3Util.withType(iterName.cloneTree(), iterName.getJSType()), call);
        Node initIterResult = iterResult.cloneTree();
        initIterResult.addChildToFront(getNext.cloneTree());
        init.addChildToBack(initIterResult);
        Node cond = this.astFactory.createNot(this.astFactory.createGetProp(iterResult.cloneTree(), "done"));
        Node incr = this.astFactory.createAssign(iterResult.cloneTree(), getNext.cloneTree());
        if (!NodeUtil.isNameDeclaration(variable)) {
            declarationOrAssign = this.astFactory.createAssign(Es6ToEs3Util.withType(variable.cloneTree().setJSDocInfo(null), typeParam), this.astFactory.createGetProp(iterResult.cloneTree(), "value"));
            declarationOrAssign.setJSDocInfo(varJSDocInfo);
            declarationOrAssign = IR.exprResult(declarationOrAssign);
        } else {
            Token declarationType = variable.getToken();
            declarationOrAssign = new Node(declarationType, this.astFactory.createName(variable.getFirstChild().getString(), typeParam).useSourceInfoFrom(variable.getFirstChild()));
            declarationOrAssign.getFirstChild().addChildToBack(this.astFactory.createGetProp(iterResult.cloneTree(), "value"));
            declarationOrAssign.setJSDocInfo(varJSDocInfo);
        }
        Node newBody = IR.block(declarationOrAssign, body).useSourceInfoFrom(body);
        Node newFor = IR.forNode(init, cond, incr, newBody);
        newFor.useSourceInfoIfMissingFromForTree(node);
        parent.replaceChild(node, newFor);
        this.compiler.reportChangeToEnclosingScope(newFor);
    }

    private JSType createGenericType(JSTypeNative typeName, JSType typeArg) {
        return Es6ToEs3Util.createGenericType(this.addTypes, this.registry, typeName, typeArg);
    }

    private JSType createMakeIteratorTypeArg() {
        UnionType.Builder builder = UnionType.builder(this.registry).addAlternate(this.registry.getNativeType(JSTypeNative.STRING_TYPE)).addAlternate(this.registry.getNativeType(JSTypeNative.ITERATOR_TYPE)).addAlternate(this.registry.getNativeType(JSTypeNative.ITERABLE_TYPE));
        JSType argumentsType = this.registry.getGlobalType("Arguments");
        if (argumentsType != null) {
            builder.addAlternate(argumentsType);
        }
        return builder.build();
    }
}

