/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.util.Escape;

public class XmlReader {
    BufferedReader br;
    String line;

    public String getLine() {
        return this.line;
    }

    public XmlReader(BufferedReader br) {
        this.br = br;
    }

    public String toTag(String name) throws Exception {
        this.skipTo("<" + name);
        if (this.line == null) {
            return "";
        }
        int i = this.line.indexOf("<" + name) + name.length() + 1;
        if (i == this.line.length()) {
            return this.line;
        }
        if (this.line.charAt(i) == ' ' || this.line.charAt(i) == '>') {
            return this.line;
        }
        this.line = null;
        return this.toTag(name);
    }

    public void skipTag(String name) throws Exception {
        this.skipTo("</" + name + ">");
    }

    public String getXmlData(String name, String data, boolean withTag, boolean allowSelfCloseOption) throws Exception {
        return this.getXmlDataLF(name, data, withTag, allowSelfCloseOption, false);
    }

    public String getXmlDataLF(String name, String data, boolean withTag, boolean allowSelfCloseOption, boolean addLF) throws Exception {
        String closer = "</" + name + ">";
        String tag = "<" + name;
        if (data == null) {
            SB sb = new SB();
            try {
                if (this.line == null) {
                    this.line = this.br.readLine();
                }
                while (this.line.indexOf(tag) < 0) {
                    this.line = this.br.readLine();
                }
            }
            catch (Exception e) {
                return null;
            }
            sb.append(this.line);
            if (addLF) {
                sb.append("\n");
            }
            boolean selfClosed = false;
            int pt = this.line.indexOf("/>");
            int pt1 = this.line.indexOf(">");
            if (pt1 < 0 || pt == pt1 - 1) {
                selfClosed = allowSelfCloseOption;
            }
            while (!(this.line.indexOf(closer) >= 0 || selfClosed && this.line.indexOf("/>") >= 0)) {
                this.line = this.br.readLine();
                sb.append(this.line);
                if (!addLF) continue;
                sb.append("\n");
            }
            data = sb.toString();
        }
        return XmlReader.extractTag(data, tag, closer, withTag);
    }

    public static String extractTagOnly(String data, String tag) {
        return XmlReader.extractTag(data, "<" + tag + ">", "</" + tag + ">", false);
    }

    private static String extractTag(String data, String tag, String closer, boolean withTag) {
        int pt1 = data.indexOf(tag);
        if (pt1 < 0) {
            return "";
        }
        int pt2 = data.indexOf(closer, pt1);
        if (pt2 < 0) {
            pt2 = data.indexOf("/>", pt1);
            closer = "/>";
        }
        if (pt2 < 0) {
            return "";
        }
        if (withTag) {
            return data.substring(pt1, pt2 += closer.length());
        }
        boolean quoted = false;
        while (pt1 < pt2) {
            char ch = data.charAt(pt1);
            if (ch == '\"') {
                quoted = !quoted;
            } else if (quoted && ch == '\\') {
                ++pt1;
            } else if (!quoted && (ch == '>' || ch == '/')) break;
            ++pt1;
        }
        if (pt1 >= pt2) {
            return "";
        }
        while (PT.isWhitespace(data.charAt(++pt1))) {
        }
        return XmlReader.unwrapCdata(data.substring(pt1, pt2));
    }

    public static String unwrapCdata(String s) {
        return s.startsWith("<![CDATA[") && s.endsWith("]]>") ? PT.rep(s.substring(9, s.length() - 3), "]]]]><![CDATA[>", "]]>") : s;
    }

    public static String getXmlAttrib(String data, String what) {
        int[] nexta = new int[1];
        int pt = XmlReader.setNext(data, what, nexta, 1);
        if (pt < 2 || (pt = XmlReader.setNext(data, "\"", nexta, 0)) < 2) {
            return "";
        }
        int pt1 = XmlReader.setNext(data, "\"", nexta, -1);
        return pt1 <= 0 ? "" : data.substring(pt, pt1);
    }

    public P3 getXmlPoint(String data, String key) {
        String spt = XmlReader.getXmlAttrib(data, key).replace('(', '{').replace(')', '}');
        Object value = Escape.uP(spt);
        if (value instanceof P3) {
            return (P3)value;
        }
        return new P3();
    }

    private static int setNext(String data, String what, int[] next, int offset) {
        int ipt = next[0];
        if (ipt < 0 || (ipt = data.indexOf(what, next[0])) < 0) {
            return -1;
        }
        next[0] = (ipt += what.length()) + offset;
        if (offset > 0 && ipt < data.length() && data.charAt(ipt) != '=') {
            return XmlReader.setNext(data, what, next, offset);
        }
        return next[0];
    }

    private void skipTo(String key) throws Exception {
        if (this.line == null) {
            this.line = this.br.readLine();
        }
        while (this.line != null && this.line.indexOf(key) < 0) {
            this.line = this.br.readLine();
        }
    }

    public boolean isNext(String name) throws Exception {
        if (this.line == null || this.line.indexOf("</") >= 0 && this.line.indexOf("</") == this.line.indexOf("<")) {
            this.line = this.br.readLine();
        }
        return this.line.indexOf("<" + name) >= 0;
    }
}

