/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser.diagnose;

import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;

public class RangeUtil {
    public static final int NO_FLAG = 0;
    public static final int LBRACE_MISSING = 1;
    public static final int IGNORE = 2;

    public static boolean containsErrorInSignature(AbstractMethodDeclaration abstractMethodDeclaration) {
        return abstractMethodDeclaration.sourceEnd + 1 == abstractMethodDeclaration.bodyStart || abstractMethodDeclaration.bodyEnd == abstractMethodDeclaration.declarationSourceEnd;
    }

    public static int[][] computeDietRange(TypeDeclaration[] typeDeclarationArray) {
        if (typeDeclarationArray == null || typeDeclarationArray.length == 0) {
            return new int[3][0];
        }
        RangeResult rangeResult = new RangeResult();
        RangeUtil.computeDietRange0(typeDeclarationArray, rangeResult);
        return rangeResult.getRanges();
    }

    private static void computeDietRange0(TypeDeclaration[] typeDeclarationArray, RangeResult rangeResult) {
        for (int i = 0; i < typeDeclarationArray.length; ++i) {
            FieldDeclaration[] fieldDeclarationArray;
            int n;
            AbstractMethodDeclaration[] abstractMethodDeclarationArray;
            TypeDeclaration[] typeDeclarationArray2 = typeDeclarationArray[i].memberTypes;
            if (typeDeclarationArray2 != null && typeDeclarationArray2.length > 0) {
                RangeUtil.computeDietRange0(typeDeclarationArray[i].memberTypes, rangeResult);
            }
            if ((abstractMethodDeclarationArray = typeDeclarationArray[i].methods) != null) {
                int n2 = abstractMethodDeclarationArray.length;
                for (n = 0; n < n2; ++n) {
                    AbstractMethodDeclaration abstractMethodDeclaration = abstractMethodDeclarationArray[n];
                    if (!RangeUtil.containsIgnoredBody(abstractMethodDeclaration)) continue;
                    if (RangeUtil.containsErrorInSignature(abstractMethodDeclaration)) {
                        abstractMethodDeclaration.bits |= 0x20;
                        rangeResult.addInterval(abstractMethodDeclaration.declarationSourceStart, abstractMethodDeclaration.declarationSourceEnd, 2);
                        continue;
                    }
                    int n3 = abstractMethodDeclaration.sourceEnd + 1 == abstractMethodDeclaration.bodyStart ? 1 : 0;
                    rangeResult.addInterval(abstractMethodDeclaration.bodyStart, abstractMethodDeclaration.bodyEnd, n3);
                }
            }
            if ((fieldDeclarationArray = typeDeclarationArray[i].fields) == null) continue;
            n = fieldDeclarationArray.length;
            for (int j = 0; j < n; ++j) {
                if (!(fieldDeclarationArray[j] instanceof Initializer)) continue;
                Initializer initializer = (Initializer)fieldDeclarationArray[j];
                if (initializer.declarationSourceEnd == initializer.bodyEnd && initializer.declarationSourceStart != initializer.declarationSourceEnd) {
                    initializer.bits |= 0x20;
                    rangeResult.addInterval(initializer.declarationSourceStart, initializer.declarationSourceEnd, 2);
                    continue;
                }
                rangeResult.addInterval(initializer.bodyStart, initializer.bodyEnd);
            }
        }
    }

    public static boolean containsIgnoredBody(AbstractMethodDeclaration abstractMethodDeclaration) {
        return !abstractMethodDeclaration.isDefaultConstructor() && !abstractMethodDeclaration.isClinit() && (abstractMethodDeclaration.modifiers & 0x1000000) == 0;
    }

    static class RangeResult {
        private static final int INITIAL_SIZE = 10;
        int pos = 0;
        int[] intervalStarts = new int[10];
        int[] intervalEnds = new int[10];
        int[] intervalFlags = new int[10];

        RangeResult() {
        }

        void addInterval(int n, int n2) {
            this.addInterval(n, n2, 0);
        }

        void addInterval(int n, int n2, int n3) {
            if (this.pos >= this.intervalStarts.length) {
                this.intervalStarts = new int[this.pos * 2];
                System.arraycopy(this.intervalStarts, 0, this.intervalStarts, 0, this.pos);
                this.intervalEnds = new int[this.pos * 2];
                System.arraycopy(this.intervalEnds, 0, this.intervalEnds, 0, this.pos);
                this.intervalFlags = new int[this.pos * 2];
                System.arraycopy(this.intervalFlags, 0, this.intervalFlags, 0, this.pos);
            }
            this.intervalStarts[this.pos] = n;
            this.intervalEnds[this.pos] = n2;
            this.intervalFlags[this.pos] = n3;
            ++this.pos;
        }

        int[][] getRanges() {
            int[] nArray = new int[this.pos];
            int[] nArray2 = new int[this.pos];
            int[] nArray3 = new int[this.pos];
            System.arraycopy(this.intervalStarts, 0, nArray, 0, this.pos);
            System.arraycopy(this.intervalEnds, 0, nArray2, 0, this.pos);
            System.arraycopy(this.intervalFlags, 0, nArray3, 0, this.pos);
            if (nArray.length > 1) {
                this.quickSort(nArray, nArray2, nArray3, 0, nArray.length - 1);
            }
            return new int[][]{nArray, nArray2, nArray3};
        }

        private void quickSort(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2) {
            int n3 = n;
            int n4 = n2;
            int n5 = nArray[n + (n2 - n) / 2];
            while (true) {
                if (this.compare(nArray[n], n5) < 0) {
                    ++n;
                    continue;
                }
                while (this.compare(n5, nArray[n2]) < 0) {
                    --n2;
                }
                if (n <= n2) {
                    int n6 = nArray[n];
                    nArray[n] = nArray[n2];
                    nArray[n2] = n6;
                    n6 = nArray2[n];
                    nArray2[n] = nArray2[n2];
                    nArray2[n2] = n6;
                    n6 = nArray3[n];
                    nArray3[n] = nArray3[n2];
                    nArray3[n2] = n6;
                    ++n;
                    --n2;
                }
                if (n > n2) break;
            }
            if (n3 < n2) {
                this.quickSort(nArray, nArray2, nArray3, n3, n2);
            }
            if (n < n4) {
                this.quickSort(nArray, nArray2, nArray3, n, n4);
            }
        }

        private int compare(int n, int n2) {
            return n - n2;
        }
    }
}

