/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileStoreAttributes;
import sun.nio.fs.UnixPath;
import sun.nio.fs.Util;

class UnixNativeDispatcher {
    private static final boolean hasAtSysCalls;
    private static final int HAS_AT_SYSCALLS = 1;

    protected UnixNativeDispatcher() {
    }

    static NativeBuffer copyToNativeBuffer(UnixPath path) {
        byte[] cstr = path.getByteArrayForSysCalls();
        int size = cstr.length + 1;
        NativeBuffer buffer = NativeBuffers.getNativeBufferFromCache(size);
        if (buffer == null) {
            buffer = NativeBuffers.allocNativeBuffer(size);
        } else if (buffer.owner() == path) {
            return buffer;
        }
        NativeBuffers.copyCStringToNativeBuffer(cstr, buffer);
        buffer.setOwner(path);
        return buffer;
    }

    static native byte[] getcwd();

    static native int dup(int var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int open(UnixPath path, int flags, int mode) throws UnixException {
        NativeBuffer buffer = UnixNativeDispatcher.copyToNativeBuffer(path);
        try {
            int n = UnixNativeDispatcher.open0(buffer.address(), flags, mode);
            return n;
        }
        finally {
            buffer.release();
        }
    }

    private static native int open0(long var0, int var2, int var3) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int openat(int dfd, byte[] path, int flags, int mode) throws UnixException {
        NativeBuffer buffer = NativeBuffers.asNativeBuffer(path);
        try {
            int n = UnixNativeDispatcher.openat0(dfd, buffer.address(), flags, mode);
            return n;
        }
        finally {
            buffer.release();
        }
    }

    private static native int openat0(int var0, long var1, int var3, int var4) throws UnixException;

    static native void close(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long fopen(UnixPath filename, String mode) throws UnixException {
        NativeBuffer pathBuffer = UnixNativeDispatcher.copyToNativeBuffer(filename);
        NativeBuffer modeBuffer = NativeBuffers.asNativeBuffer(Util.toBytes(mode));
        try {
            long l = UnixNativeDispatcher.fopen0(pathBuffer.address(), modeBuffer.address());
            return l;
        }
        finally {
            modeBuffer.release();
            pathBuffer.release();
        }
    }

    private static native long fopen0(long var0, long var2) throws UnixException;

    static native void fclose(long var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void link(UnixPath existing, UnixPath newfile) throws UnixException {
        NativeBuffer existingBuffer = UnixNativeDispatcher.copyToNativeBuffer(existing);
        NativeBuffer newBuffer = UnixNativeDispatcher.copyToNativeBuffer(newfile);
        try {
            UnixNativeDispatcher.link0(existingBuffer.address(), newBuffer.address());
        }
        finally {
            newBuffer.release();
            existingBuffer.release();
        }
    }

    private static native void link0(long var0, long var2) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unlink(UnixPath path) throws UnixException {
        NativeBuffer buffer = UnixNativeDispatcher.copyToNativeBuffer(path);
        try {
            UnixNativeDispatcher.unlink0(buffer.address());
        }
        finally {
            buffer.release();
        }
    }

    private static native void unlink0(long var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unlinkat(int dfd, byte[] path, int flag) throws UnixException {
        NativeBuffer buffer = NativeBuffers.asNativeBuffer(path);
        try {
            UnixNativeDispatcher.unlinkat0(dfd, buffer.address(), flag);
        }
        finally {
            buffer.release();
        }
    }

    private static native void unlinkat0(int var0, long var1, int var3) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void mknod(UnixPath path, int mode, long dev) throws UnixException {
        NativeBuffer buffer = UnixNativeDispatcher.copyToNativeBuffer(path);
        try {
            UnixNativeDispatcher.mknod0(buffer.address(), mode, dev);
        }
        finally {
            buffer.release();
        }
    }

    private static native void mknod0(long var0, int var2, long var3) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rename(UnixPath from, UnixPath to) throws UnixException {
        NativeBuffer fromBuffer = UnixNativeDispatcher.copyToNativeBuffer(from);
        NativeBuffer toBuffer = UnixNativeDispatcher.copyToNativeBuffer(to);
        try {
            UnixNativeDispatcher.rename0(fromBuffer.address(), toBuffer.address());
        }
        finally {
            toBuffer.release();
            fromBuffer.release();
        }
    }

    private static native void rename0(long var0, long var2) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void renameat(int fromfd, byte[] from, int tofd, byte[] to) throws UnixException {
        NativeBuffer fromBuffer = NativeBuffers.asNativeBuffer(from);
        NativeBuffer toBuffer = NativeBuffers.asNativeBuffer(to);
        try {
            UnixNativeDispatcher.renameat0(fromfd, fromBuffer.address(), tofd, toBuffer.address());
        }
        finally {
            toBuffer.release();
            fromBuffer.release();
        }
    }

    private static native void renameat0(int var0, long var1, int var3, long var4) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void mkdir(UnixPath path, int mode) throws UnixException {
        NativeBuffer buffer = UnixNativeDispatcher.copyToNativeBuffer(path);
        try {
            UnixNativeDispatcher.mkdir0(buffer.address(), mode);
        }
        finally {
            buffer.release();
        }
    }

    private static native void mkdir0(long var0, int var2) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rmdir(UnixPath path) throws UnixException {
        NativeBuffer buffer = UnixNativeDispatcher.copyToNativeBuffer(path);
        try {
            UnixNativeDispatcher.rmdir0(buffer.address());
        }
        finally {
            buffer.release();
        }
    }

    private static native void rmdir0(long var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readlink(UnixPath path) throws UnixException {
        NativeBuffer buffer = UnixNativeDispatcher.copyToNativeBuffer(path);
        try {
            byte[] byArray = UnixNativeDispatcher.readlink0(buffer.address());
            return byArray;
        }
        finally {
            buffer.release();
        }
    }

    private static native byte[] readlink0(long var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] realpath(UnixPath path) throws UnixException {
        NativeBuffer buffer = UnixNativeDispatcher.copyToNativeBuffer(path);
        try {
            byte[] byArray = UnixNativeDispatcher.realpath0(buffer.address());
            return byArray;
        }
        finally {
            buffer.release();
        }
    }

    private static native byte[] realpath0(long var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void symlink(byte[] name1, UnixPath name2) throws UnixException {
        NativeBuffer targetBuffer = NativeBuffers.asNativeBuffer(name1);
        NativeBuffer linkBuffer = UnixNativeDispatcher.copyToNativeBuffer(name2);
        try {
            UnixNativeDispatcher.symlink0(targetBuffer.address(), linkBuffer.address());
        }
        finally {
            linkBuffer.release();
            targetBuffer.release();
        }
    }

    private static native void symlink0(long var0, long var2) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stat(UnixPath path, UnixFileAttributes attrs) throws UnixException {
        NativeBuffer buffer = UnixNativeDispatcher.copyToNativeBuffer(path);
        try {
            UnixNativeDispatcher.stat0(buffer.address(), attrs);
        }
        finally {
            buffer.release();
        }
    }

    private static native void stat0(long var0, UnixFileAttributes var2) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void lstat(UnixPath path, UnixFileAttributes attrs) throws UnixException {
        NativeBuffer buffer = UnixNativeDispatcher.copyToNativeBuffer(path);
        try {
            UnixNativeDispatcher.lstat0(buffer.address(), attrs);
        }
        finally {
            buffer.release();
        }
    }

    private static native void lstat0(long var0, UnixFileAttributes var2) throws UnixException;

    static native void fstat(int var0, UnixFileAttributes var1) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fstatat(int dfd, byte[] path, int flag, UnixFileAttributes attrs) throws UnixException {
        NativeBuffer buffer = NativeBuffers.asNativeBuffer(path);
        try {
            UnixNativeDispatcher.fstatat0(dfd, buffer.address(), flag, attrs);
        }
        finally {
            buffer.release();
        }
    }

    private static native void fstatat0(int var0, long var1, int var3, UnixFileAttributes var4) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void chown(UnixPath path, int uid, int gid) throws UnixException {
        NativeBuffer buffer = UnixNativeDispatcher.copyToNativeBuffer(path);
        try {
            UnixNativeDispatcher.chown0(buffer.address(), uid, gid);
        }
        finally {
            buffer.release();
        }
    }

    private static native void chown0(long var0, int var2, int var3) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void lchown(UnixPath path, int uid, int gid) throws UnixException {
        NativeBuffer buffer = UnixNativeDispatcher.copyToNativeBuffer(path);
        try {
            UnixNativeDispatcher.lchown0(buffer.address(), uid, gid);
        }
        finally {
            buffer.release();
        }
    }

    private static native void lchown0(long var0, int var2, int var3) throws UnixException;

    static native void fchown(int var0, int var1, int var2) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void chmod(UnixPath path, int mode) throws UnixException {
        NativeBuffer buffer = UnixNativeDispatcher.copyToNativeBuffer(path);
        try {
            UnixNativeDispatcher.chmod0(buffer.address(), mode);
        }
        finally {
            buffer.release();
        }
    }

    private static native void chmod0(long var0, int var2) throws UnixException;

    static native void fchmod(int var0, int var1) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void utimes(UnixPath path, long times0, long times1) throws UnixException {
        NativeBuffer buffer = UnixNativeDispatcher.copyToNativeBuffer(path);
        try {
            UnixNativeDispatcher.utimes0(buffer.address(), times0, times1);
        }
        finally {
            buffer.release();
        }
    }

    private static native void utimes0(long var0, long var2, long var4) throws UnixException;

    static native void futimes(int var0, long var1, long var3, UnixPath var5) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long opendir(UnixPath path) throws UnixException {
        NativeBuffer buffer = UnixNativeDispatcher.copyToNativeBuffer(path);
        try {
            long l = UnixNativeDispatcher.opendir0(buffer.address());
            return l;
        }
        finally {
            buffer.release();
        }
    }

    private static native long opendir0(long var0) throws UnixException;

    static native long fdopendir(int var0) throws UnixException;

    static native void closedir(long var0) throws UnixException;

    static native byte[] readdir(long var0) throws UnixException;

    static native int read(int var0, long var1, int var3) throws UnixException;

    static native int write(int var0, long var1, int var3) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void access(UnixPath path, int amode) throws UnixException {
        NativeBuffer buffer = UnixNativeDispatcher.copyToNativeBuffer(path);
        try {
            UnixNativeDispatcher.access0(buffer.address(), amode);
        }
        finally {
            buffer.release();
        }
    }

    private static native void access0(long var0, int var2) throws UnixException;

    static native byte[] getpwuid(int var0) throws UnixException;

    static native byte[] getgrgid(int var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getpwnam(String name) throws UnixException {
        NativeBuffer buffer = NativeBuffers.asNativeBuffer(Util.toBytes(name));
        try {
            int n = UnixNativeDispatcher.getpwnam0(buffer.address());
            return n;
        }
        finally {
            buffer.release();
        }
    }

    private static native int getpwnam0(long var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getgrnam(String name) throws UnixException {
        NativeBuffer buffer = NativeBuffers.asNativeBuffer(Util.toBytes(name));
        try {
            int n = UnixNativeDispatcher.getgrnam0(buffer.address());
            return n;
        }
        finally {
            buffer.release();
        }
    }

    private static native int getgrnam0(long var0) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void statvfs(UnixPath path, UnixFileStoreAttributes attrs) throws UnixException {
        NativeBuffer buffer = UnixNativeDispatcher.copyToNativeBuffer(path);
        try {
            UnixNativeDispatcher.statvfs0(buffer.address(), attrs);
        }
        finally {
            buffer.release();
        }
    }

    private static native void statvfs0(long var0, UnixFileStoreAttributes var2) throws UnixException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long pathconf(UnixPath path, int name) throws UnixException {
        NativeBuffer buffer = UnixNativeDispatcher.copyToNativeBuffer(path);
        try {
            long l = UnixNativeDispatcher.pathconf0(buffer.address(), name);
            return l;
        }
        finally {
            buffer.release();
        }
    }

    private static native long pathconf0(long var0, int var2) throws UnixException;

    static native long fpathconf(int var0, int var1) throws UnixException;

    static native byte[] strerror(int var0);

    static boolean supportsAtSysCalls() {
        return hasAtSysCalls;
    }

    static boolean supportsNoFollowLinks() {
        return true;
    }

    private static native int init();

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("nio");
                return null;
            }
        });
        int flags = UnixNativeDispatcher.init();
        hasAtSysCalls = (flags & 1) > 0;
    }
}

