/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ha extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Lokacin Greenwhich a London",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Apia = new String[] {
               "Apia Standard Time",
               "",
               "Apia Daylight Time",
               "",
               "Apia Time",
               "",
            };
        final String[] Cook = new String[] {
               "Cook Islands Standard Time",
               "",
               "Cook Islands Half Summer Time",
               "",
               "Cook Islands Time",
               "",
            };
        final String[] Cuba = new String[] {
               "Lokaci Tsayayye na Kuba",
               "",
               "Lokaci rana ta Kuba",
               "",
               "Lokaci ta Kuba",
               "",
            };
        final String[] Fiji = new String[] {
               "Fiji Standard Time",
               "",
               "Fiji Summer Time",
               "",
               "Fiji Time",
               "",
            };
        final String[] Gulf = new String[] {
               "Gulf Standard Time [translation hint: translate as just \"Gulf Time\"]",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd Standard Time",
               "",
               "Hovd Summer Time",
               "",
               "Hovd Time",
               "",
            };
        final String[] Iran = new String[] {
               "Iran Standard Time",
               "",
               "Iran Daylight Time",
               "",
               "Iran Time",
               "",
            };
        final String[] Niue = new String[] {
               "Niue Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk Standard Time",
               "",
               "Omsk Summer Time",
               "",
               "Omsk Time",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuk Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake Island Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] China = new String[] {
               "China Standard Time",
               "",
               "China Daylight Time",
               "",
               "China Time",
               "",
            };
        final String[] Cocos = new String[] {
               "Cocos Islands Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davis Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "India Standard Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Japan Standard Time",
               "",
               "Japan Daylight Time",
               "",
               "Japan Time",
               "",
            };
        final String[] Korea = new String[] {
               "Korean Standard Time",
               "",
               "Korean Daylight Time",
               "",
               "Korean Time",
               "",
            };
        final String[] Nauru = new String[] {
               "Nauru Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepal Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa Standard Time",
               "",
               "Samoa Daylight Time",
               "",
               "Samoa Time",
               "",
            };
        final String[] Syowa = new String[] {
               "Syowa Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga Standard Time",
               "",
               "Tonga Summer Time",
               "",
               "Tonga Time",
               "",
            };
        final String[] Alaska = new String[] {
               "Tsayayyen Lokacin Alaska",
               "",
               "Lokacin Rana na Alaska",
               "",
               "Lokacin Alaska",
               "",
            };
        final String[] Azores = new String[] {
               "Azores Standard Time",
               "",
               "Azores Summer Time",
               "",
               "Azores Time",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhutan Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Israel Standard Time",
               "",
               "Israel Daylight Time",
               "",
               "Israel Time",
               "",
            };
        final String[] Kosrae = new String[] {
               "Kosrae Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moscow Standard Time",
               "",
               "Moscow Summer Time",
               "",
               "Moscow Time",
               "",
            };
        final String[] Ponape = new String[] {
               "Ponape Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei Standard Time",
               "",
               "Taipei Daylight Time",
               "",
               "Taipei Time",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis & Futuna Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabian Standard Time",
               "",
               "Arabian Daylight Time",
               "",
               "Arabian Time",
               "",
            };
        final String[] Armenia = new String[] {
               "Armenia Standard Time",
               "",
               "Armenia Summer Time",
               "",
               "Armenia Time",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham Standard Time",
               "",
               "Chatham Daylight Time",
               "",
               "Chatham Time",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Hadewa Lokaci na Duniya",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambier Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgia Standard Time",
               "",
               "Georgia Summer Time",
               "",
               "Georgia Time",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk Standard Time",
               "",
               "Irkutsk Summer Time",
               "",
               "Irkutsk Time",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan Standard Time",
               "",
               "Magadan Summer Time",
               "",
               "Magadan Time",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmar Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolk Island Standard Time",
               "",
               "Norfolk Island Daylight Time",
               "",
               "Norfolk Island Time",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9union Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Solomon Islands Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu Standard Time",
               "",
               "Vanuatu Summer Time",
               "",
               "Vanuatu Time",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk Standard Time",
               "",
               "Yakutsk Summer Time",
               "",
               "Yakutsk Time",
               "",
            };
        final String[] Atlantic = new String[] {
               "Lokaci Tsayayye na Kanada, Puerto Rico da Virgin Islands",
               "",
               "Lokacin Rana na Kanada, Puerto Rico da Virgin Islands",
               "",
               "Lokacin Kanada, Puerto Rico da Virgin Islands",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro Standard Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malaysia Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldives Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatar Standard Time",
               "",
               "Ulaanbaatar Summer Time",
               "",
               "Ulaanbaatar Time",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistan Standard Time",
               "",
               "Pakistan Summer Time",
               "",
               "Pakistan Time",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin Standard Time",
               "",
               "Sakhalin Summer Time",
               "",
               "Sakhalin Time",
               "",
            };
        final String[] Christmas = new String[] {
               "Christmas Island Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Kong Standard Time",
               "",
               "Hong Kong Summer Time",
               "",
               "Hong Kong Time",
               "",
            };
        final String[] Indochina = new String[] {
               "Indochina Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kyrgyzstan Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe Standard Time",
               "",
               "Lord Howe Daylight Time",
               "",
               "Lord Howe Time",
               "",
            };
        final String[] Macquarie = new String[] {
               "Macquarie Island Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesas Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "TsaTsayayyar Lokacin Mauritius",
               "",
               "Bazarar Mauritius",
               "",
               "Lokacin Mauritius",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapore Standard Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgograd Standard Time",
               "",
               "Volgograd Summer Time",
               "",
               "Volgograd Time",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaijan Standard Time",
               "",
               "Azerbaijan Summer Time",
               "",
               "Azerbaijan Time",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesh Standard Time",
               "",
               "Bangladesh Summer Time",
               "",
               "Bangladesh Time",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Cape Verde Standard Time",
               "",
               "Cape Verde Summer Time",
               "",
               "Cape Verde Time",
               "",
            };
        final String[] East_Timor = new String[] {
               "East Timor Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychelles Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tajikistan Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistan Standard Time",
               "",
               "Uzbekistan Summer Time",
               "",
               "Uzbekistan Time",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afghanistan Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk Standard Time",
               "",
               "Krasnoyarsk Summer Time",
               "",
               "Krasnoyarsk Time",
               "",
            };
        final String[] New_Zealand = new String[] {
               "New Zealand Standard Time",
               "",
               "New Zealand Daylight Time",
               "",
               "New Zealand Time",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk Standard Time",
               "",
               "Novosibirsk Summer Time",
               "",
               "Novosibirsk Time",
               "",
            };
        final String[] Philippines = new String[] {
               "Philippine Standard Time",
               "",
               "Philippine Summer Time",
               "",
               "Philippine Time",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok Standard Time",
               "",
               "Vladivostok Summer Time",
               "",
               "Vladivostok Time",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indian Ocean Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Line Islands Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Lokaci Tsayayye ta Newfoundland",
               "",
               "Lokaci rana ta Newfoundland",
               "",
               "Lokaci ta Newfoundland",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan Standard Time",
               "",
               "Turkmenistan Summer Time",
               "",
               "Turkmenistan Time",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "New Caledonia Standard Time",
               "",
               "New Caledonia Summer Time",
               "",
               "New Caledonia Time",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Yekaterinburg Standard Time",
               "",
               "Yekaterinburg Summer Time",
               "",
               "Yekaterinburg Time",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Central Africa Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "East Africa Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Western = new String[] {
               "West Africa Standard Time",
               "",
               "West Africa Summer Time",
               "",
               "West Africa Time",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Ida Tsakiyar a Lokaci Turai",
               "",
               "Tsakiyar bazara a lokaci turai",
               "",
               "Tsakiyar a lokaci turai",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Ida lokaci a turai gabas",
               "",
               "Gabas a lokaci turai da bazara",
               "",
               "Lokaci a turai gabas",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Ida lokaci ta yammacin turai",
               "",
               "Ida lokaci ta yammacin turai da bazara",
               "",
               "Lokaci ta yammacin turai",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Lokaci Tsayayye na Mesiko Pacific",
               "",
               "Lokaci na rana na Mesiko Pacific",
               "",
               "Lokaci na Mesiko Pacific",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "South Africa Standard Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Central = new String[] {
               "Tsayayyen Lokaci dake Arewacin Amurika ta Tsakiya",
               "",
               "Lokacin Rana dake Arewacin Amurika ta Tsakiya",
               "",
               "Lokaci dake Amurika arewa ta tsakiyar",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Tsayayyen Lokacin Gabas dake Arewacin Amurika",
               "",
               "Lokacin Rana ta Gabas dake Arewacin Amurika",
               "",
               "Lokacin Gabas dake Arewacin Amurikaa",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Lokaci Tsayayye na Arewacin Amurika",
               "",
               "Lokaci da rana a Arewacin Amurika",
               "",
               "Lokacin Arewacin Amurika",
               "",
            };
        final String[] French_Southern = new String[] {
               "French Southern & Antarctic Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert Islands Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Ida Lokaci ta Hawaii-Aleutian",
               "",
               "Lokaci rana ta Hawaii-Aleutian",
               "",
               "Lokaci ta Hawaii-Aleutian",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenix Islands Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Lokaci tsayayye St. Pierre da Miquelon",
               "",
               "Lokaci rana ta St. Pierre da Miquelon",
               "",
               "Lokaci ta St. Pierre da Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Lokaci tsayayye na tsauni a Arewacin Amurica",
               "",
               "Lokaci rana tsauni a arewacin da Amirka",
               "",
               "Lokaci tsauni a arewacin da Amirka",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshall Islands Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Lokaci Tsayayye na arewa maso gabashin Mesiko",
               "",
               "Lokacin rana na arewa maso gabashin Mesiko",
               "",
               "Lokacin arewa maso gabashin mesiko",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua New Guinea Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Australian Central Standard Time",
               "",
               "Australian Central Daylight Time",
               "",
               "Central Australia Time",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Australian Eastern Standard Time",
               "",
               "Australian Eastern Daylight Time",
               "",
               "Eastern Australia Time",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Australian Western Standard Time",
               "",
               "Australian Western Daylight Time",
               "",
               "Western Australia Time",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Lokaci Tsayayye a gabashin ta Greenland",
               "",
               "Lokaci rana a gabas ta Greeland",
               "",
               "Lokaci a gabas ta Greeland",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Lokaci Tsayayye a yammacin Greeland",
               "",
               "Lokacin rana a yammacin Greeland",
               "",
               "Lokaci a yammacin Greeland",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Central Indonesia Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Eastern Indonesia Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Western Indonesia Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "East Kazakhstan Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "West Kazakhstan Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Australian Central Western Standard Time",
               "",
               "Australian Central Western Daylight Time",
               "",
               "Australian Central Western Time",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Eastern },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Boise", America_Mountain },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Damascus", Europe_Eastern },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin", GMT },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London", GMT },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Dawson", America_Pacific },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast", GMT },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Ojinaga", America_Mountain },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montserrat", Atlantic },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", America_Pacific },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amman" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Beirut", "Beirut" },
            { "timezone.excity.Etc/Unknown", "Birni da ba a sani ba" },
            { "timezone.excity.Asia/Baghdad", "Baghdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrain" },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Arewacin Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Arewacin Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Arewacin Dakota" },
        };
        return data;
    }
}
