/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.catalina.ssi.ExpressionTokenizer;
import org.apache.catalina.ssi.SSIMediator;

public class ExpressionParseTree {
    private LinkedList<Node> nodeStack = new LinkedList();
    private LinkedList<OppNode> oppStack = new LinkedList();
    private Node root;
    private SSIMediator ssiMediator;
    private static final int PRECEDENCE_NOT = 5;
    private static final int PRECEDENCE_COMPARE = 4;
    private static final int PRECEDENCE_LOGICAL = 1;

    public ExpressionParseTree(String string, SSIMediator sSIMediator) throws ParseException {
        this.ssiMediator = sSIMediator;
        this.parseExpression(string);
    }

    public boolean evaluateTree() {
        return this.root.evaluate();
    }

    private void pushOpp(OppNode oppNode) {
        OppNode oppNode2;
        if (oppNode == null) {
            this.oppStack.add(0, oppNode);
            return;
        }
        while (this.oppStack.size() != 0 && (oppNode2 = this.oppStack.get(0)) != null && oppNode2.getPrecedence() >= oppNode.getPrecedence()) {
            this.oppStack.remove(0);
            oppNode2.popValues(this.nodeStack);
            this.nodeStack.add(0, oppNode2);
        }
        this.oppStack.add(0, oppNode);
    }

    private void resolveGroup() {
        OppNode oppNode = null;
        while ((oppNode = this.oppStack.remove(0)) != null) {
            oppNode.popValues(this.nodeStack);
            this.nodeStack.add(0, oppNode);
        }
    }

    private void parseExpression(String string) throws ParseException {
        StringNode stringNode = null;
        this.pushOpp(null);
        ExpressionTokenizer expressionTokenizer = new ExpressionTokenizer(string);
        while (expressionTokenizer.hasMoreTokens()) {
            int n = expressionTokenizer.nextToken();
            if (n != 0) {
                stringNode = null;
            }
            switch (n) {
                case 0: {
                    if (stringNode == null) {
                        stringNode = new StringNode(expressionTokenizer.getTokenValue());
                        this.nodeStack.add(0, stringNode);
                        break;
                    }
                    stringNode.value.append(" ");
                    stringNode.value.append(expressionTokenizer.getTokenValue());
                    break;
                }
                case 1: {
                    this.pushOpp(new AndNode());
                    break;
                }
                case 2: {
                    this.pushOpp(new OrNode());
                    break;
                }
                case 3: {
                    this.pushOpp(new NotNode());
                    break;
                }
                case 4: {
                    this.pushOpp(new EqualNode());
                    break;
                }
                case 5: {
                    this.pushOpp(new NotNode());
                    this.oppStack.add(0, new EqualNode());
                    break;
                }
                case 6: {
                    this.resolveGroup();
                    break;
                }
                case 7: {
                    this.pushOpp(null);
                    break;
                }
                case 8: {
                    this.pushOpp(new NotNode());
                    this.oppStack.add(0, new LessThanNode());
                    break;
                }
                case 9: {
                    this.pushOpp(new NotNode());
                    this.oppStack.add(0, new GreaterThanNode());
                    break;
                }
                case 10: {
                    this.pushOpp(new GreaterThanNode());
                    break;
                }
                case 11: {
                    this.pushOpp(new LessThanNode());
                    break;
                }
            }
        }
        this.resolveGroup();
        if (this.nodeStack.size() == 0) {
            throw new ParseException("No nodes created.", expressionTokenizer.getIndex());
        }
        if (this.nodeStack.size() > 1) {
            throw new ParseException("Extra nodes created.", expressionTokenizer.getIndex());
        }
        if (this.oppStack.size() != 0) {
            throw new ParseException("Unused opp nodes exist.", expressionTokenizer.getIndex());
        }
        this.root = this.nodeStack.get(0);
    }

    private final class LessThanNode
    extends CompareNode {
        private LessThanNode() {
        }

        @Override
        public boolean evaluate() {
            return this.compareBranches() < 0;
        }

        @Override
        public int getPrecedence() {
            return 4;
        }

        public String toString() {
            return this.left + " " + this.right + " LT";
        }
    }

    private final class GreaterThanNode
    extends CompareNode {
        private GreaterThanNode() {
        }

        @Override
        public boolean evaluate() {
            return this.compareBranches() > 0;
        }

        @Override
        public int getPrecedence() {
            return 4;
        }

        public String toString() {
            return this.left + " " + this.right + " GT";
        }
    }

    private final class EqualNode
    extends CompareNode {
        private EqualNode() {
        }

        @Override
        public boolean evaluate() {
            return this.compareBranches() == 0;
        }

        @Override
        public int getPrecedence() {
            return 4;
        }

        public String toString() {
            return this.left + " " + this.right + " EQ";
        }
    }

    private abstract class CompareNode
    extends OppNode {
        private CompareNode() {
        }

        protected int compareBranches() {
            String string = ((StringNode)this.left).getValue();
            String string2 = ((StringNode)this.right).getValue();
            int n = string2.length();
            if (n > 1 && string2.charAt(0) == '/' && string2.charAt(n - 1) == '/') {
                String string3 = string2.substring(1, n - 1);
                try {
                    Pattern pattern = Pattern.compile(string3);
                    if (pattern.matcher(string).find()) {
                        return 0;
                    }
                    return -1;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    ExpressionParseTree.this.ssiMediator.log("Invalid expression: " + string3, patternSyntaxException);
                    return 0;
                }
            }
            return string.compareTo(string2);
        }
    }

    private final class OrNode
    extends OppNode {
        private OrNode() {
        }

        @Override
        public boolean evaluate() {
            if (this.left.evaluate()) {
                return true;
            }
            return this.right.evaluate();
        }

        @Override
        public int getPrecedence() {
            return 1;
        }

        public String toString() {
            return this.left + " " + this.right + " OR";
        }
    }

    private final class AndNode
    extends OppNode {
        private AndNode() {
        }

        @Override
        public boolean evaluate() {
            if (!this.left.evaluate()) {
                return false;
            }
            return this.right.evaluate();
        }

        @Override
        public int getPrecedence() {
            return 1;
        }

        public String toString() {
            return this.left + " " + this.right + " AND";
        }
    }

    private final class NotNode
    extends OppNode {
        private NotNode() {
        }

        @Override
        public boolean evaluate() {
            return !this.left.evaluate();
        }

        @Override
        public int getPrecedence() {
            return 5;
        }

        @Override
        public void popValues(List<Node> list) {
            this.left = list.remove(0);
        }

        public String toString() {
            return this.left + " NOT";
        }
    }

    private abstract class OppNode
    extends Node {
        Node left;
        Node right;

        private OppNode() {
        }

        public abstract int getPrecedence();

        public void popValues(List<Node> list) {
            this.right = list.remove(0);
            this.left = list.remove(0);
        }
    }

    private class StringNode
    extends Node {
        StringBuilder value;
        String resolved;

        public StringNode(String string) {
            this.resolved = null;
            this.value = new StringBuilder(string);
        }

        public String getValue() {
            if (this.resolved == null) {
                this.resolved = ExpressionParseTree.this.ssiMediator.substituteVariables(this.value.toString());
            }
            return this.resolved;
        }

        @Override
        public boolean evaluate() {
            return this.getValue().length() != 0;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private abstract class Node {
        private Node() {
        }

        public abstract boolean evaluate();
    }
}

