/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.apache.tomcat.util.buf.AbstractChunk;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.StringCache;

public final class ByteChunk
extends AbstractChunk {
    private static final long serialVersionUID = 1L;
    public static final Charset DEFAULT_CHARSET = B2CConverter.ISO_8859_1;
    private transient Charset charset;
    private byte[] buff;
    private transient ByteInputChannel in = null;
    private transient ByteOutputChannel out = null;
    private boolean optimizedWrite = true;

    public ByteChunk() {
    }

    public ByteChunk(int n) {
        this.allocate(n, -1);
    }

    @Deprecated
    public ByteChunk getClone() {
        try {
            return (ByteChunk)this.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeUTF(this.getCharset().name());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.charset = Charset.forName(objectInputStream.readUTF());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void recycle() {
        super.recycle();
        this.charset = null;
    }

    public void reset() {
        this.buff = null;
    }

    public void allocate(int n, int n2) {
        if (this.buff == null || this.buff.length < n) {
            this.buff = new byte[n];
        }
        this.setLimit(n2);
        this.start = 0;
        this.end = 0;
        this.isSet = true;
        this.hasHashCode = false;
    }

    public void setBytes(byte[] byArray, int n, int n2) {
        this.buff = byArray;
        this.start = n;
        this.end = this.start + n2;
        this.isSet = true;
        this.hasHashCode = false;
    }

    @Deprecated
    public void setOptimizedWrite(boolean bl) {
        this.optimizedWrite = bl;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Charset getCharset() {
        if (this.charset == null) {
            this.charset = DEFAULT_CHARSET;
        }
        return this.charset;
    }

    public byte[] getBytes() {
        return this.getBuffer();
    }

    public byte[] getBuffer() {
        return this.buff;
    }

    public void setByteInputChannel(ByteInputChannel byteInputChannel) {
        this.in = byteInputChannel;
    }

    public void setByteOutputChannel(ByteOutputChannel byteOutputChannel) {
        this.out = byteOutputChannel;
    }

    @Deprecated
    public void append(char c) throws IOException {
        this.append((byte)c);
    }

    public void append(byte by) throws IOException {
        this.makeSpace(1);
        int n = this.getLimitInternal();
        if (this.end >= n) {
            this.flushBuffer();
        }
        this.buff[this.end++] = by;
    }

    public void append(ByteChunk byteChunk) throws IOException {
        this.append(byteChunk.getBytes(), byteChunk.getStart(), byteChunk.getLength());
    }

    public void append(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.makeSpace(n2);
        int n4 = this.getLimitInternal();
        if (this.optimizedWrite && n2 == n4 && this.end == this.start && this.out != null) {
            this.out.realWriteBytes(byArray, n, n2);
            return;
        }
        if (n2 <= n4 - this.end) {
            System.arraycopy(byArray, n, this.buff, this.end, n2);
            this.end += n2;
            return;
        }
        int n5 = n4 - this.end;
        System.arraycopy(byArray, n, this.buff, this.end, n5);
        this.end += n5;
        this.flushBuffer();
        for (n3 = n2 - n5; n3 > n4 - this.end; n3 -= n4 - this.end) {
            this.out.realWriteBytes(byArray, n + n2 - n3, n4 - this.end);
        }
        System.arraycopy(byArray, n + n2 - n3, this.buff, this.end, n3);
        this.end += n3;
    }

    public int substract() throws IOException {
        if (this.checkEof()) {
            return -1;
        }
        return this.buff[this.start++] & 0xFF;
    }

    @Deprecated
    public int substract(ByteChunk byteChunk) throws IOException {
        int n;
        if (this.end - this.start == 0) {
            if (this.in == null) {
                return -1;
            }
            n = this.in.realReadBytes(this.buff, 0, this.buff.length);
            if (n < 0) {
                return -1;
            }
        }
        n = this.getLength();
        byteChunk.append(this.buff, this.start, n);
        this.start = this.end;
        return n;
    }

    public byte substractB() throws IOException {
        if (this.checkEof()) {
            return -1;
        }
        return this.buff[this.start++];
    }

    public int substract(byte[] byArray, int n, int n2) throws IOException {
        if (this.checkEof()) {
            return -1;
        }
        int n3 = n2;
        if (n2 > this.getLength()) {
            n3 = this.getLength();
        }
        System.arraycopy(this.buff, this.start, byArray, n, n3);
        this.start += n3;
        return n3;
    }

    private boolean checkEof() throws IOException {
        if (this.end - this.start == 0) {
            if (this.in == null) {
                return true;
            }
            int n = this.in.realReadBytes(this.buff, 0, this.buff.length);
            if (n < 0) {
                return true;
            }
        }
        return false;
    }

    public void flushBuffer() throws IOException {
        if (this.out == null) {
            throw new IOException("Buffer overflow, no sink " + this.getLimit() + " " + this.buff.length);
        }
        this.out.realWriteBytes(this.buff, this.start, this.end - this.start);
        this.end = this.start;
    }

    public void makeSpace(int n) {
        byte[] byArray = null;
        long l = this.end + n;
        int n2 = this.getLimitInternal();
        if (l > (long)n2) {
            l = n2;
        }
        if (this.buff == null) {
            if (l < 256L) {
                l = 256L;
            }
            this.buff = new byte[(int)l];
        }
        if (l <= (long)this.buff.length) {
            return;
        }
        long l2 = l < 2L * (long)this.buff.length ? (long)this.buff.length * 2L : (long)this.buff.length * 2L + (long)n;
        if (l2 > (long)n2) {
            l2 = n2;
        }
        byArray = new byte[(int)l2];
        System.arraycopy(this.buff, this.start, byArray, 0, this.end - this.start);
        this.buff = byArray;
        byArray = null;
        this.end -= this.start;
        this.start = 0;
    }

    public String toString() {
        if (null == this.buff) {
            return null;
        }
        if (this.end - this.start == 0) {
            return "";
        }
        return StringCache.toString(this);
    }

    public String toStringInternal() {
        if (this.charset == null) {
            this.charset = DEFAULT_CHARSET;
        }
        CharBuffer charBuffer = this.charset.decode(ByteBuffer.wrap(this.buff, this.start, this.end - this.start));
        return new String(charBuffer.array(), charBuffer.arrayOffset(), charBuffer.length());
    }

    @Deprecated
    public int getInt() {
        return Ascii.parseInt(this.buff, this.start, this.end - this.start);
    }

    public long getLong() {
        return Ascii.parseLong(this.buff, this.start, this.end - this.start);
    }

    public boolean equals(Object object) {
        if (object instanceof ByteChunk) {
            return this.equals((ByteChunk)object);
        }
        return false;
    }

    public boolean equals(String string) {
        byte[] byArray = this.buff;
        int n = this.end - this.start;
        if (byArray == null || n != string.length()) {
            return false;
        }
        int n2 = this.start;
        for (int i = 0; i < n; ++i) {
            if (byArray[n2++] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String string) {
        byte[] byArray = this.buff;
        int n = this.end - this.start;
        if (byArray == null || n != string.length()) {
            return false;
        }
        int n2 = this.start;
        for (int i = 0; i < n; ++i) {
            if (Ascii.toLower(byArray[n2++]) == Ascii.toLower(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(ByteChunk byteChunk) {
        return this.equals(byteChunk.getBytes(), byteChunk.getStart(), byteChunk.getLength());
    }

    public boolean equals(byte[] byArray, int n, int n2) {
        byte[] byArray2 = this.buff;
        if (byArray2 == null && byArray == null) {
            return true;
        }
        int n3 = this.end - this.start;
        if (n3 != n2 || byArray2 == null || byArray == null) {
            return false;
        }
        int n4 = this.start;
        while (n3-- > 0) {
            if (byArray2[n4++] == byArray[n++]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(CharChunk charChunk) {
        return this.equals(charChunk.getChars(), charChunk.getStart(), charChunk.getLength());
    }

    public boolean equals(char[] cArray, int n, int n2) {
        byte[] byArray = this.buff;
        if (cArray == null && byArray == null) {
            return true;
        }
        if (byArray == null || cArray == null || this.end - this.start != n2) {
            return false;
        }
        int n3 = this.start;
        int n4 = this.end - this.start;
        while (n4-- > 0) {
            if ((char)byArray[n3++] == cArray[n++]) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean startsWith(String string) {
        byte[] byArray = this.buff;
        int n = string.length();
        if (byArray == null || n > this.end - this.start) {
            return false;
        }
        int n2 = this.start;
        for (int i = 0; i < n; ++i) {
            if (byArray[n2++] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean startsWith(byte[] byArray) {
        byte[] byArray2 = this.buff;
        if (byArray2 == null && byArray == null) {
            return true;
        }
        int n = this.end - this.start;
        if (byArray2 == null || byArray == null || byArray.length > n) {
            return false;
        }
        int n2 = this.start;
        int n3 = 0;
        while (n2 < this.end && n3 < byArray.length) {
            if (byArray2[n2++] == byArray[n3++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String string, int n) {
        byte[] byArray = this.buff;
        int n2 = string.length();
        if (byArray == null || n2 + n > this.end - this.start) {
            return false;
        }
        int n3 = this.start + n;
        for (int i = 0; i < n2; ++i) {
            if (byArray[n3++] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWithIgnoreCase(String string, int n) {
        byte[] byArray = this.buff;
        int n2 = string.length();
        if (byArray == null || n2 + n > this.end - this.start) {
            return false;
        }
        int n3 = this.start + n;
        for (int i = 0; i < n2; ++i) {
            if (Ascii.toLower(byArray[n3++]) == Ascii.toLower(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int getBufferElement(int n) {
        return this.buff[n];
    }

    @Deprecated
    public int hashIgnoreCase() {
        return ByteChunk.hashBytesIC(this.buff, this.start, this.end - this.start);
    }

    private static int hashBytesIC(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        byte[] byArray2 = byArray;
        int n4 = 0;
        for (int i = n; i < n3; ++i) {
            n4 = n4 * 37 + Ascii.toLower(byArray2[i]);
        }
        return n4;
    }

    public int indexOf(char c, int n) {
        int n2 = ByteChunk.indexOf(this.buff, this.start + n, this.end, c);
        return n2 >= this.start ? n2 - this.start : -1;
    }

    public static int indexOf(byte[] byArray, int n, int n2, char c) {
        for (int i = n; i < n2; ++i) {
            byte by = byArray[i];
            if (by != c) continue;
            return i;
        }
        return -1;
    }

    public static int findByte(byte[] byArray, int n, int n2, byte by) {
        for (int i = n; i < n2; ++i) {
            if (byArray[i] != by) continue;
            return i;
        }
        return -1;
    }

    public static int findBytes(byte[] byArray, int n, int n2, byte[] byArray2) {
        for (int i = n; i < n2; ++i) {
            for (byte by : byArray2) {
                if (byArray[i] != by) continue;
                return i;
            }
        }
        return -1;
    }

    @Deprecated
    public static int findNotBytes(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = byArray2.length;
        for (int i = n; i < n2; ++i) {
            boolean bl = true;
            for (int j = 0; j < n3; ++j) {
                if (byArray[i] != byArray2[j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    public static final byte[] convertToBytes(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }

    public static interface ByteOutputChannel {
        public void realWriteBytes(byte[] var1, int var2, int var3) throws IOException;
    }

    public static interface ByteInputChannel {
        public int realReadBytes(byte[] var1, int var2, int var3) throws IOException;
    }
}

