/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.modules.profiler.heapwalk.details.jdk.image.ImageBuilder;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.BaseBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.ComponentBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.Utils;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

final class WindowBuilders {
    WindowBuilders() {
    }

    static ComponentBuilders.ComponentBuilder getBuilder(Instance instance, Heap heap) {
        if (DetailsUtils.isSubclassOf(instance, JRootPane.class.getName())) {
            return new JRootPaneBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JDesktopPane.class.getName())) {
            return new JDesktopPaneBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JLayeredPane.class.getName())) {
            return new JLayeredPaneBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, Frame.class.getName())) {
            return new FrameBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, Dialog.class.getName())) {
            return new DialogBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JInternalFrame.class.getName())) {
            return new JInternalFrameBuilder(instance, heap);
        }
        return null;
    }

    private static class JInternalFrameBuilder
    extends ComponentBuilders.JComponentBuilder<JInternalFrame> {
        private final JRootPaneBuilder _rootPane;
        private final boolean closable;
        private final boolean _isClosed;
        private final boolean maximizable;
        private final boolean _isMaximum;
        private final boolean iconable;
        private final boolean _isIcon;
        private final boolean resizable;
        private final boolean _isSelected;
        private final BaseBuilders.IconBuilder frameIcon;
        private final String title;

        JInternalFrameBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this._rootPane = JRootPaneBuilder.fromField(instance, "rootPane", heap);
            this.closable = DetailsUtils.getBooleanFieldValue(instance, "closable", false);
            this._isClosed = DetailsUtils.getBooleanFieldValue(instance, "isClosed", false);
            this.maximizable = DetailsUtils.getBooleanFieldValue(instance, "maximizable", false);
            this._isMaximum = DetailsUtils.getBooleanFieldValue(instance, "isMaximum", false);
            this.iconable = DetailsUtils.getBooleanFieldValue(instance, "iconable", false);
            this._isIcon = DetailsUtils.getBooleanFieldValue(instance, "isIcon", false);
            this.resizable = DetailsUtils.getBooleanFieldValue(instance, "resizable", false);
            this._isSelected = DetailsUtils.getBooleanFieldValue(instance, "isSelected", false);
            this.frameIcon = BaseBuilders.IconBuilder.fromField(instance, "frameIcon", heap);
            this.title = Utils.getFieldString(instance, "title");
        }

        @Override
        protected void setupInstance(JInternalFrame jInternalFrame) {
            super.setupInstance(jInternalFrame);
            if (this.frameIcon != null) {
                jInternalFrame.setFrameIcon((Icon)this.frameIcon.createInstance());
            }
        }

        @Override
        protected JInternalFrame createInstanceImpl() {
            JInternalFrame jInternalFrame = new JInternalFrame(this.title, this.resizable, this.closable, this.maximizable, this.iconable){

                @Override
                protected JRootPane createRootPane() {
                    return _rootPane == null ? null : (JRootPane)_rootPane.createInstance();
                }

                @Override
                public void addNotify() {
                    try {
                        this.setClosed(_isClosed);
                        this.setMaximum(_isMaximum);
                        this.setIcon(_isIcon);
                        this.setSelected(_isSelected);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            };
            return jInternalFrame;
        }
    }

    private static class DialogBuilder
    extends ComponentBuilders.ContainerBuilder<Dialog> {
        private final String title;
        private final boolean undecorated;
        private final Image image;

        DialogBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            Object object;
            Object object2;
            this.title = Utils.getFieldString(instance, "title");
            this.undecorated = DetailsUtils.getBooleanFieldValue(instance, "undecorated", false);
            Image image = null;
            Object object3 = instance.getValueOfField("icons");
            if (object3 == null) {
                object2 = instance.getValueOfField("parent");
                while (object2 instanceof Instance && !((object3 = ((Instance)object2).getValueOfField("icons")) instanceof Instance)) {
                    object2 = ((Instance)object2).getValueOfField("parent");
                }
            }
            if (object3 instanceof Instance && DetailsUtils.getIntFieldValue((Instance)(object2 = (Instance)object3), "size", 0) > 0 && (object = object2.getValueOfField("elementData")) instanceof ObjectArrayInstance) {
                Object e = ((ObjectArrayInstance)object).getValues().get(0);
                image = e != null ? ImageBuilder.buildImage((Instance)e, heap) : null;
            }
            this.image = image;
        }

        @Override
        protected void setupInstance(Dialog dialog) {
            super.setupInstance(dialog);
            dialog.setUndecorated(this.undecorated);
            if (this.image != null) {
                dialog.setIconImage(this.image);
            }
        }

        @Override
        protected Dialog createInstanceImpl() {
            return new JDialog((Frame)null, this.title){

                @Override
                protected void dialogInit() {
                }

                @Override
                public void addNotify() {
                }

                @Override
                public void remove(Component component) {
                }

                @Override
                public void setVisible(boolean bl) {
                }
            };
        }

        @Override
        protected Component createPresenterImpl(Dialog dialog) {
            Image image;
            if (dialog.isUndecorated()) {
                JPanel jPanel = new JPanel(null);
                jPanel.setOpaque(true);
                Dimension dimension = null;
                for (Component component : dialog.getComponents()) {
                    jPanel.add(component);
                    Dimension dimension2 = component.getSize();
                    if (dimension == null) {
                        dimension = dimension2;
                        continue;
                    }
                    dimension.width = Math.max(dimension.width, dimension2.width);
                    dimension.height = Math.max(dimension.height, dimension2.height);
                }
                if (dimension != null) {
                    jPanel.setSize(dimension);
                }
                return jPanel;
            }
            JInternalFrame jInternalFrame = new JInternalFrame(dialog.getTitle());
            List<Image> list = dialog.getIconImages();
            Image image2 = image = list.isEmpty() ? null : list.get(0);
            if (image != null) {
                jInternalFrame.setFrameIcon(new ImageIcon(image));
            }
            for (Component component : dialog.getComponents()) {
                jInternalFrame.add(component);
            }
            jInternalFrame.pack();
            return jInternalFrame;
        }
    }

    private static class FrameBuilder
    extends ComponentBuilders.ContainerBuilder<Frame> {
        private final String title;
        private final boolean undecorated;
        private final Image image;

        FrameBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            Object object;
            Instance instance2;
            this.title = Utils.getFieldString(instance, "title");
            this.undecorated = DetailsUtils.getBooleanFieldValue(instance, "undecorated", false);
            Image image = null;
            Object object2 = instance.getValueOfField("icons");
            if (object2 instanceof Instance && DetailsUtils.getIntFieldValue(instance2 = (Instance)object2, "size", 0) > 0 && (object = instance2.getValueOfField("elementData")) instanceof ObjectArrayInstance) {
                Object e = ((ObjectArrayInstance)object).getValues().get(0);
                image = e != null ? ImageBuilder.buildImage((Instance)e, heap) : null;
            }
            this.image = image;
        }

        @Override
        protected void setupInstance(Frame frame) {
            super.setupInstance(frame);
            frame.setUndecorated(this.undecorated);
            if (this.image != null) {
                frame.setIconImage(this.image);
            }
        }

        @Override
        protected Frame createInstanceImpl() {
            return new JFrame(this.title){

                @Override
                protected void frameInit() {
                }

                @Override
                public void addNotify() {
                }

                @Override
                public void remove(Component component) {
                }

                @Override
                public void setVisible(boolean bl) {
                }
            };
        }

        @Override
        protected Component createPresenterImpl(Frame frame) {
            if (frame.isUndecorated()) {
                JPanel jPanel = new JPanel(null);
                jPanel.setOpaque(true);
                Dimension dimension = null;
                for (Component component : frame.getComponents()) {
                    jPanel.add(component);
                    Dimension dimension2 = component.getSize();
                    if (dimension == null) {
                        dimension = dimension2;
                        continue;
                    }
                    dimension.width = Math.max(dimension.width, dimension2.width);
                    dimension.height = Math.max(dimension.height, dimension2.height);
                }
                if (dimension != null) {
                    jPanel.setSize(dimension);
                }
                return jPanel;
            }
            JInternalFrame jInternalFrame = new JInternalFrame(frame.getTitle());
            Image image = frame.getIconImage();
            if (image != null) {
                jInternalFrame.setFrameIcon(new ImageIcon(image));
            }
            for (Component component : frame.getComponents()) {
                jInternalFrame.add(component);
            }
            jInternalFrame.pack();
            return jInternalFrame;
        }
    }

    private static class JDesktopPaneBuilder
    extends JLayeredPaneBuilder {
        JDesktopPaneBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JLayeredPane createInstanceImpl() {
            return new JDesktopPane();
        }
    }

    private static class JLayeredPaneBuilder
    extends ComponentBuilders.JComponentBuilder<JLayeredPane> {
        JLayeredPaneBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JLayeredPane createInstanceImpl() {
            return new JLayeredPane();
        }
    }

    private static class JRootPaneBuilder
    extends ComponentBuilders.JComponentBuilder<JRootPane> {
        private final int windowDecorationStyle;

        JRootPaneBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.windowDecorationStyle = DetailsUtils.getIntFieldValue(instance, "windowDecorationStyle", 0);
        }

        static JRootPaneBuilder fromField(Instance instance, String string, Heap heap) {
            Object object = instance.getValueOfField(string);
            if (!(object instanceof Instance)) {
                return null;
            }
            return new JRootPaneBuilder((Instance)object, heap);
        }

        @Override
        protected void setupInstance(JRootPane jRootPane) {
            super.setupInstance(jRootPane);
            jRootPane.setWindowDecorationStyle(this.windowDecorationStyle);
        }

        @Override
        protected JRootPane createInstanceImpl() {
            return new JRootPane();
        }
    }
}

