"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const drawBorder_1 = require("./drawBorder");
const drawRow_1 = __importDefault(require("./drawRow"));
/**
 * Group the array into sub-arrays by sizes.
 *
 * @example
 * chunkBySizes(['a', 'b', 'c', 'd', 'e'], [2, 1, 2]) = [ ['a', 'b'], ['c'], ['d', 'e'] ]
 */
const groupBySizes = (array, sizes) => {
    let startIndex = 0;
    return sizes.map((rowHeight) => {
        const chunk = array.slice(startIndex, startIndex + rowHeight);
        startIndex += rowHeight;
        return chunk;
    });
};
const shouldDrawBorderJoin = (rowIndex, rowCount, config) => {
    const { singleLine, drawHorizontalLine } = config;
    return !singleLine && rowIndex + 1 < rowCount && drawHorizontalLine(rowIndex + 1, rowCount);
};
exports.default = (rows, columnWidths, rowHeights, config) => {
    const { drawHorizontalLine, } = config;
    const groupedRows = groupBySizes(rows, rowHeights).map((group) => {
        return group.map((row) => {
            return drawRow_1.default(row, config);
        }).join('');
    });
    const rowCount = groupedRows.length;
    let output = '';
    if (drawHorizontalLine(0, rowCount)) {
        output += drawBorder_1.drawBorderTop(columnWidths, config);
    }
    groupedRows.forEach((row, rowIndex) => {
        output += row;
        if (shouldDrawBorderJoin(rowIndex, rowCount, config)) {
            output += drawBorder_1.drawBorderJoin(columnWidths, config);
        }
    });
    if (drawHorizontalLine(rowCount, rowCount)) {
        output += drawBorder_1.drawBorderBottom(columnWidths, config);
    }
    return output;
};
