/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.parser.Authorization;
import org.apache.tomcat.util.security.ConcurrentMessageDigest;
import org.apache.tomcat.util.security.MD5Encoder;

public class DigestAuthenticator
extends AuthenticatorBase {
    private final Log log = LogFactory.getLog(DigestAuthenticator.class);
    protected static final String QOP = "auth";
    protected Map<String, NonceInfo> nonces;
    protected long lastTimestamp = 0L;
    protected final Object lastTimestampLock = new Object();
    protected int nonceCacheSize = 1000;
    protected int nonceCountWindowSize = 100;
    protected String key = null;
    protected long nonceValidity = 300000L;
    protected String opaque;
    protected boolean validateUri = true;

    public DigestAuthenticator() {
        this.setCache(false);
    }

    public int getNonceCountWindowSize() {
        return this.nonceCountWindowSize;
    }

    public void setNonceCountWindowSize(int n) {
        this.nonceCountWindowSize = n;
    }

    public int getNonceCacheSize() {
        return this.nonceCacheSize;
    }

    public void setNonceCacheSize(int n) {
        this.nonceCacheSize = n;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public long getNonceValidity() {
        return this.nonceValidity;
    }

    public void setNonceValidity(long l) {
        this.nonceValidity = l;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public void setOpaque(String string) {
        this.opaque = string;
    }

    public boolean isValidateUri() {
        return this.validateUri;
    }

    public void setValidateUri(boolean bl) {
        this.validateUri = bl;
    }

    @Override
    protected boolean doAuthenticate(Request request, HttpServletResponse httpServletResponse) throws IOException {
        if (this.checkForCachedAuthentication(request, httpServletResponse, false)) {
            return true;
        }
        Principal principal = null;
        String string = request.getHeader("authorization");
        DigestInfo digestInfo = new DigestInfo(this.getOpaque(), this.getNonceValidity(), this.getKey(), this.nonces, this.isValidateUri());
        if (string != null && digestInfo.parse(request, string)) {
            if (digestInfo.validate(request)) {
                principal = digestInfo.authenticate(this.context.getRealm());
            }
            if (principal != null && !digestInfo.isNonceStale()) {
                this.register(request, httpServletResponse, principal, "DIGEST", digestInfo.getUsername(), null);
                return true;
            }
        }
        String string2 = this.generateNonce(request);
        this.setAuthenticateHeader(request, httpServletResponse, string2, principal != null && digestInfo.isNonceStale());
        httpServletResponse.sendError(401);
        return false;
    }

    @Override
    protected String getAuthMethod() {
        return "DIGEST";
    }

    protected static String removeQuotes(String string, boolean bl) {
        if (string.length() > 0 && string.charAt(0) != '\"' && !bl) {
            return string;
        }
        if (string.length() > 2) {
            return string.substring(1, string.length() - 1);
        }
        return "";
    }

    protected static String removeQuotes(String string) {
        return DigestAuthenticator.removeQuotes(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateNonce(Request request) {
        long l = System.currentTimeMillis();
        Object object = this.lastTimestampLock;
        synchronized (object) {
            if (l > this.lastTimestamp) {
                this.lastTimestamp = l;
            } else {
                l = ++this.lastTimestamp;
            }
        }
        object = request.getRemoteAddr() + ":" + l + ":" + this.getKey();
        byte[] byArray = ConcurrentMessageDigest.digestMD5((byte[][])new byte[][]{((String)object).getBytes(StandardCharsets.ISO_8859_1)});
        String string = l + ":" + MD5Encoder.encode((byte[])byArray);
        NonceInfo nonceInfo = new NonceInfo(l, this.getNonceCountWindowSize());
        Map<String, NonceInfo> map = this.nonces;
        synchronized (map) {
            this.nonces.put(string, nonceInfo);
        }
        return string;
    }

    protected void setAuthenticateHeader(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) {
        String string2 = DigestAuthenticator.getRealmName(this.context);
        String string3 = bl ? "Digest realm=\"" + string2 + "\", qop=\"" + QOP + "\", nonce=\"" + string + "\", opaque=\"" + this.getOpaque() + "\", stale=true" : "Digest realm=\"" + string2 + "\", qop=\"" + QOP + "\", nonce=\"" + string + "\", opaque=\"" + this.getOpaque() + "\"";
        httpServletResponse.setHeader("WWW-Authenticate", string3);
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        if (this.getKey() == null) {
            this.setKey(this.sessionIdGenerator.generateSessionId());
        }
        if (this.getOpaque() == null) {
            this.setOpaque(this.sessionIdGenerator.generateSessionId());
        }
        this.nonces = new LinkedHashMap<String, NonceInfo>(){
            private static final long serialVersionUID = 1L;
            private static final long LOG_SUPPRESS_TIME = 300000L;
            private long lastLog = 0L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, NonceInfo> entry) {
                long l = System.currentTimeMillis();
                if (this.size() > DigestAuthenticator.this.getNonceCacheSize()) {
                    if (this.lastLog < l && l - entry.getValue().getTimestamp() < DigestAuthenticator.this.getNonceValidity()) {
                        DigestAuthenticator.this.log.warn((Object)AuthenticatorBase.sm.getString("digestAuthenticator.cacheRemove"));
                        this.lastLog = l + 300000L;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static class NonceInfo {
        private final long timestamp;
        private final boolean[] seen;
        private final int offset;
        private int count = 0;

        public NonceInfo(long l, int n) {
            this.timestamp = l;
            this.seen = new boolean[n];
            this.offset = n / 2;
        }

        public synchronized boolean nonceCountValid(long l) {
            if ((long)(this.count - this.offset) >= l || l > (long)(this.count - this.offset + this.seen.length)) {
                return false;
            }
            int n = (int)((l + (long)this.offset) % (long)this.seen.length);
            if (this.seen[n]) {
                return false;
            }
            this.seen[n] = true;
            this.seen[this.count % this.seen.length] = false;
            ++this.count;
            return true;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    public static class DigestInfo {
        private final String opaque;
        private final long nonceValidity;
        private final String key;
        private final Map<String, NonceInfo> nonces;
        private boolean validateUri = true;
        private String userName = null;
        private String method = null;
        private String uri = null;
        private String response = null;
        private String nonce = null;
        private String nc = null;
        private String cnonce = null;
        private String realmName = null;
        private String qop = null;
        private String opaqueReceived = null;
        private boolean nonceStale = false;

        public DigestInfo(String string, long l, String string2, Map<String, NonceInfo> map, boolean bl) {
            this.opaque = string;
            this.nonceValidity = l;
            this.key = string2;
            this.nonces = map;
            this.validateUri = bl;
        }

        public String getUsername() {
            return this.userName;
        }

        public boolean parse(Request request, String string) {
            Map map;
            if (string == null) {
                return false;
            }
            try {
                map = Authorization.parseAuthorizationDigest((StringReader)new StringReader(string));
            }
            catch (IOException iOException) {
                return false;
            }
            if (map == null) {
                return false;
            }
            this.method = request.getMethod();
            this.userName = (String)map.get("username");
            this.realmName = (String)map.get("realm");
            this.nonce = (String)map.get("nonce");
            this.nc = (String)map.get("nc");
            this.cnonce = (String)map.get("cnonce");
            this.qop = (String)map.get("qop");
            this.uri = (String)map.get("uri");
            this.response = (String)map.get("response");
            this.opaqueReceived = (String)map.get("opaque");
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean validate(Request request) {
            byte[] byArray;
            String string;
            Object object;
            long l;
            CharSequence charSequence;
            String string2;
            String string3;
            if (this.userName == null || this.realmName == null || this.nonce == null || this.uri == null || this.response == null) {
                return false;
            }
            if (this.validateUri && !this.uri.equals(string3 = (string2 = request.getQueryString()) == null ? request.getRequestURI() : request.getRequestURI() + "?" + string2)) {
                String string4 = request.getHeader("host");
                String string5 = request.getScheme();
                if (string4 != null && !string3.startsWith(string5)) {
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append(string5);
                    ((StringBuilder)charSequence).append("://");
                    ((StringBuilder)charSequence).append(string4);
                    ((StringBuilder)charSequence).append(string3);
                    if (!this.uri.equals(((StringBuilder)charSequence).toString())) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (!(string3 = AuthenticatorBase.getRealmName(request.getContext())).equals(this.realmName)) {
                return false;
            }
            if (!this.opaque.equals(this.opaqueReceived)) {
                return false;
            }
            int n = this.nonce.indexOf(58);
            if (n < 0 || n + 1 == this.nonce.length()) {
                return false;
            }
            try {
                l = Long.parseLong(this.nonce.substring(0, n));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            charSequence = this.nonce.substring(n + 1);
            long l2 = System.currentTimeMillis();
            if (l2 - l > this.nonceValidity) {
                this.nonceStale = true;
                object = this.nonces;
                synchronized (object) {
                    this.nonces.remove(this.nonce);
                }
            }
            if (!(string = MD5Encoder.encode((byte[])(byArray = ConcurrentMessageDigest.digestMD5((byte[][])new byte[][]{((String)(object = request.getRemoteAddr() + ":" + l + ":" + this.key)).getBytes(StandardCharsets.ISO_8859_1)})))).equals(charSequence)) {
                return false;
            }
            if (this.qop != null && !DigestAuthenticator.QOP.equals(this.qop)) {
                return false;
            }
            if (this.qop == null) {
                if (this.cnonce != null || this.nc != null) {
                    return false;
                }
            } else {
                NonceInfo nonceInfo;
                long l3;
                if (this.cnonce == null || this.nc == null) {
                    return false;
                }
                if (this.nc.length() < 6 || this.nc.length() > 8) {
                    return false;
                }
                try {
                    l3 = Long.parseLong(this.nc, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                Map<String, NonceInfo> map = this.nonces;
                synchronized (map) {
                    nonceInfo = this.nonces.get(this.nonce);
                }
                if (nonceInfo == null) {
                    this.nonceStale = true;
                } else if (!nonceInfo.nonceCountValid(l3)) {
                    return false;
                }
            }
            return true;
        }

        public boolean isNonceStale() {
            return this.nonceStale;
        }

        public Principal authenticate(Realm realm) {
            String string = this.method + ":" + this.uri;
            byte[] byArray = ConcurrentMessageDigest.digestMD5((byte[][])new byte[][]{string.getBytes(StandardCharsets.ISO_8859_1)});
            String string2 = MD5Encoder.encode((byte[])byArray);
            return realm.authenticate(this.userName, this.response, this.nonce, this.nc, this.cnonce, this.qop, this.realmName, string2);
        }
    }
}

