"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function isMultiLine(s) {
    return s && s.indexOf('\n') >= 0;
}
exports.isMultiLine = isMultiLine;
function isMultiLineValue(s) {
    return isMultiLine(s) && s.length > 2 && s[0] == '|' && (s[1] == '\n' || s[1] == '\r' || s[2] == '\n');
}
exports.isMultiLineValue = isMultiLineValue;
function makeMutiLine(s, lev) {
    var xbuf = '';
    if (isMultiLine(s)) {
        xbuf += '|\n';
        var lines = splitOnLines(s);
        for (var i = 0; i < lines.length; i++) {
            xbuf += indent(lev, lines[i]);
        }
        //xbuf += '\n';
    }
    else {
        xbuf += s;
    }
    return xbuf;
}
exports.makeMutiLine = makeMutiLine;
function fromMutiLine(s) {
    if (!isMultiLineValue(s))
        return s;
    var res = null;
    var lines = splitOnLines(s);
    for (var i = 1; i < lines.length; i++) {
        var line = lines[i];
        var str = line.substring(2);
        if (!res)
            res = str;
        else
            res += str;
    }
    return res;
}
exports.fromMutiLine = fromMutiLine;
function trimStart(s) {
    if (!s)
        return s;
    var pos = 0;
    while (pos < s.length) {
        var ch = s[pos];
        if (ch != '\r' && ch != '\n' && ch != ' ' && ch != '\t')
            break;
        pos++;
    }
    return s.substring(pos, s.length);
}
exports.trimStart = trimStart;
function indent(lev, str) {
    if (str === void 0) { str = ''; }
    var leading = '';
    //leading += '[' + lev + ']';
    for (var i = 0; i < lev; i++)
        leading += '  ';
    return leading + str;
}
exports.indent = indent;
function print(lev, str) {
    if (str === void 0) { str = ''; }
    console.log(indent(lev, str));
}
exports.print = print;
function replaceNewlines(s, rep) {
    if (rep === void 0) { rep = null; }
    var res = '';
    for (var i = 0; i < s.length; i++) {
        var ch = s[i];
        if (ch == '\r')
            ch = rep == null ? '\\r' : rep;
        if (ch == '\n')
            ch = rep == null ? '\\n' : rep;
        res += ch;
    }
    return res;
}
exports.replaceNewlines = replaceNewlines;
function trimEnd(s) {
    var pos = s.length;
    while (pos > 0) {
        var ch = s[pos - 1];
        if (ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n')
            break;
        pos--;
    }
    return s.substring(0, pos);
}
exports.trimEnd = trimEnd;
function trim(s) {
    return trimStart(trimEnd(s));
}
exports.trim = trim;
function splitOnLines(text) {
    var lines = text.match(/^.*((\r\n|\n|\r)|$)/gm);
    return lines;
}
exports.splitOnLines = splitOnLines;
function startsWith(s, suffix) {
    if (!s || !suffix || s.length < suffix.length)
        return false;
    for (var i = 0; i < suffix.length; i++) {
        if (s[i] != suffix[i])
            return false;
    }
    return true;
}
exports.startsWith = startsWith;
function endsWith(s, suffix) {
    if (!s || !suffix || s.length < suffix.length)
        return false;
    for (var i = 0; i < suffix.length; i++) {
        if (s[s.length - 1 - i] != suffix[suffix.length - 1 - i])
            return false;
    }
    return true;
}
exports.endsWith = endsWith;
function capitalize(s) {
    return s.charAt(0).toUpperCase() + s.slice(1);
}
exports.capitalize = capitalize;
var TextRange = /** @class */ (function () {
    function TextRange(contents, start, end) {
        this.contents = contents;
        this.start = start;
        this.end = end;
    }
    TextRange.prototype.text = function () {
        return this.contents.substring(this.start, this.end);
    };
    TextRange.prototype.startpos = function () { return this.start; };
    TextRange.prototype.endpos = function () { return this.end; };
    TextRange.prototype.len = function () { return this.end - this.start; };
    TextRange.prototype.unitText = function () { return this.contents; };
    TextRange.prototype.withStart = function (start) {
        return new TextRange(this.contents, start, this.end);
    };
    TextRange.prototype.withEnd = function (end) {
        return new TextRange(this.contents, this.start, end);
    };
    TextRange.prototype.sub = function (start, end) {
        return this.contents.substring(start, end);
    };
    TextRange.prototype.trimStart = function () {
        var pos = this.start;
        while (pos < this.contents.length - 1) {
            var ch = this.contents[pos];
            if (ch != ' ' && ch != '\t')
                break;
            pos++;
        }
        return new TextRange(this.contents, pos, this.end);
    };
    TextRange.prototype.trimEnd = function () {
        var pos = this.end;
        while (pos > 0) {
            var ch = this.contents[pos - 1];
            if (ch != ' ' && ch != '\t')
                break;
            pos--;
        }
        return new TextRange(this.contents, this.start, pos);
    };
    TextRange.prototype.extendToStartOfLine = function () {
        var pos = this.start;
        while (pos > 0) {
            var prevchar = this.contents[pos - 1];
            if (prevchar == '\r' || prevchar == '\n')
                break;
            pos--;
        }
        return new TextRange(this.contents, pos, this.end);
    };
    TextRange.prototype.extendAnyUntilNewLines = function () {
        var pos = this.end;
        if (pos > 0) {
            var last = this.contents[pos - 1];
            if (last == '\n')
                return this;
        }
        while (pos < this.contents.length - 1) {
            var nextchar = this.contents[pos];
            if (nextchar == '\r' || nextchar == '\n')
                break;
            pos++;
        }
        return new TextRange(this.contents, this.start, pos);
    };
    TextRange.prototype.extendSpacesUntilNewLines = function () {
        var pos = this.end;
        if (pos > 0) {
            var last = this.contents[pos - 1];
            if (last == '\n')
                return this;
        }
        while (pos < this.contents.length - 1) {
            var nextchar = this.contents[pos];
            if (nextchar != ' ') {
                break;
            }
            pos++;
        }
        return new TextRange(this.contents, this.start, pos);
    };
    TextRange.prototype.extendSpaces = function () {
        var pos = this.end;
        while (pos < this.contents.length - 1) {
            var nextchar = this.contents[pos];
            if (nextchar != ' ')
                break;
            pos++;
        }
        return new TextRange(this.contents, this.start, pos);
    };
    TextRange.prototype.extendSpacesBack = function () {
        var pos = this.start;
        while (pos > 0) {
            var nextchar = this.contents[pos - 1];
            if (nextchar != ' ')
                break;
            pos--;
        }
        return new TextRange(this.contents, pos, this.end);
    };
    TextRange.prototype.extendCharIfAny = function (ch) {
        var pos = this.end;
        if (pos < this.contents.length - 1 && this.contents[pos] == ch) {
            pos++;
        }
        return new TextRange(this.contents, this.start, pos);
    };
    TextRange.prototype.extendCharIfAnyBack = function (ch) {
        var pos = this.start;
        if (pos > 0 && this.contents[pos - 1] == ch) {
            pos--;
        }
        return new TextRange(this.contents, pos, this.end);
    };
    TextRange.prototype.extendToNewlines = function () {
        var pos = this.end;
        if (pos > 0) {
            var last = this.contents[pos - 1];
            if (last == '\n')
                return this;
        }
        while (pos < this.contents.length - 1) {
            var nextchar = this.contents[pos];
            if (nextchar != '\r' && nextchar != '\n')
                break;
            pos++;
        }
        return new TextRange(this.contents, this.start, pos);
    };
    TextRange.prototype.extendUntilNewlinesBack = function () {
        var pos = this.start;
        while (pos > 0) {
            var nextchar = this.contents[pos - 1];
            if (nextchar == '\r' || nextchar == '\n')
                break;
            pos--;
        }
        return new TextRange(this.contents, pos, this.end);
    };
    TextRange.prototype.reduceNewlinesEnd = function () {
        var pos = this.end;
        while (pos > this.start) {
            var last = this.contents[pos - 1];
            if (last != '\r' && last != '\n')
                break;
            pos--;
        }
        return new TextRange(this.contents, this.start, pos);
    };
    TextRange.prototype.reduceSpaces = function () {
        var pos = this.end;
        while (pos > this.start) {
            var last = this.contents[pos - 1];
            if (last != ' ')
                break;
            pos--;
        }
        return new TextRange(this.contents, this.start, pos);
    };
    TextRange.prototype.replace = function (text) {
        return this.sub(0, this.start) + text + this.sub(this.end, this.unitText().length);
    };
    TextRange.prototype.remove = function () {
        return this.sub(0, this.start) + /*this.text() +*/ this.sub(this.end, this.unitText().length);
    };
    return TextRange;
}());
exports.TextRange = TextRange;
//# sourceMappingURL=textutil.js.map