/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.indent;

import java.util.List;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.indent.BracketIndentRule;
import org.gjt.sp.jedit.indent.IndentAction;
import org.gjt.sp.util.StandardUtilities;

public class CloseBracketIndentRule
extends BracketIndentRule {
    private final boolean aligned;

    public CloseBracketIndentRule(char c, boolean bl) {
        super(TextUtilities.getComplementaryBracket(c, null), c);
        this.aligned = bl;
    }

    @Override
    public void apply(JEditBuffer jEditBuffer, int n, int n2, int n3, List<IndentAction> list) {
        int n4;
        int n5 = this.aligned ? n : n2;
        if (n5 == -1) {
            return;
        }
        CharSequence charSequence = jEditBuffer.getLineSegment(n5);
        for (n4 = charSequence.length() - 1; n4 >= 0 && charSequence.charAt(n4) != this.closeBracket; --n4) {
        }
        if (n4 == -1) {
            return;
        }
        int n6 = this.getBrackets((JEditBuffer)jEditBuffer, (int)n5).closeCount;
        if (n6 != 0) {
            AlignBracket alignBracket = new AlignBracket(jEditBuffer, n5, n4);
            int n7 = alignBracket.getOpenBracketLine();
            if (n7 != -1) {
                int n8 = alignBracket.getOpenBracketColumn();
                alignBracket.setExtraIndent(this.getBrackets((JEditBuffer)jEditBuffer, (int)n7, (int)0, (int)n8).openCount);
            }
            list.add(alignBracket);
        }
    }

    private static class AlignBracket
    implements IndentAction {
        private final int openBracketLine;
        private int openBracketColumn;
        private CharSequence openBracketLineText;
        private int extraIndent;

        public AlignBracket(JEditBuffer jEditBuffer, int n, int n2) {
            int n3 = TextUtilities.findMatchingBracket(jEditBuffer, n, n2);
            if (n3 == -1) {
                this.openBracketLine = -1;
            } else {
                this.openBracketLine = jEditBuffer.getLineOfOffset(n3);
                this.openBracketColumn = n3 - jEditBuffer.getLineStartOffset(this.openBracketLine);
                this.openBracketLineText = jEditBuffer.getLineSegment(this.openBracketLine);
            }
        }

        public int getExtraIndent() {
            return this.extraIndent;
        }

        public void setExtraIndent(int n) {
            this.extraIndent = n;
        }

        public int getOpenBracketColumn() {
            return this.openBracketColumn;
        }

        public int getOpenBracketLine() {
            return this.openBracketLine;
        }

        @Override
        public int calculateIndent(JEditBuffer jEditBuffer, int n, int n2, int n3) {
            if (this.openBracketLineText == null) {
                return n3;
            }
            return StandardUtilities.getLeadingWhiteSpaceWidth(this.openBracketLineText, jEditBuffer.getTabSize()) + this.extraIndent * jEditBuffer.getIndentSize();
        }

        @Override
        public boolean keepChecking() {
            return false;
        }
    }
}

