/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sun.tools.jconsole.InternalDialog;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.LabeledComponent;
import sun.tools.jconsole.LocalVirtualMachine;
import sun.tools.jconsole.Messages;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Utilities;

public class ConnectDialog
extends InternalDialog
implements DocumentListener,
FocusListener,
ItemListener,
ListSelectionListener,
KeyListener {
    private static final int COL_NAME = 0;
    private static final int COL_PID = 1;
    JConsole jConsole;
    JTextField userNameTF;
    JTextField passwordTF;
    JRadioButton localRadioButton;
    JRadioButton remoteRadioButton;
    JLabel localMessageLabel;
    JLabel remoteMessageLabel;
    JTextField remoteTF;
    JButton connectButton;
    JButton cancelButton;
    JPanel radioButtonPanel;
    private Icon mastheadIcon = new InternalDialog.MastheadIcon(this, Messages.CONNECT_DIALOG_MASTHEAD_TITLE);
    private Color hintTextColor;
    private Color disabledTableCellColor;
    JTable vmTable;
    ManagedVmTableModel vmModel = null;
    JScrollPane localTableScrollPane = null;
    private Action connectAction;
    private Action cancelAction;
    private static JLabel tmpLabel = new JLabel();

    public ConnectDialog(JConsole jConsole) {
        super(jConsole, Messages.CONNECT_DIALOG_TITLE, true);
        this.jConsole = jConsole;
        Utilities.setAccessibleDescription(this, Messages.CONNECT_DIALOG_ACCESSIBLE_DESCRIPTION);
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        JComponent cp = (JComponent)this.getContentPane();
        this.radioButtonPanel = new JPanel(new BorderLayout(0, 12));
        this.radioButtonPanel.setBorder(new EmptyBorder(6, 12, 12, 12));
        ButtonGroup radioButtonGroup = new ButtonGroup();
        JPanel bottomPanel = new JPanel(new BorderLayout());
        this.statusBar = new JLabel(" ", 0);
        Utilities.setAccessibleName(this.statusBar, Messages.CONNECT_DIALOG_STATUS_BAR_ACCESSIBLE_NAME);
        Font normalLabelFont = this.statusBar.getFont();
        Font boldLabelFont = normalLabelFont.deriveFont(1);
        Font smallLabelFont = normalLabelFont.deriveFont(normalLabelFont.getSize2D() - 1.0f);
        JLabel mastheadLabel = new JLabel(this.mastheadIcon);
        Utilities.setAccessibleName(mastheadLabel, Messages.CONNECT_DIALOG_MASTHEAD_ACCESSIBLE_NAME);
        cp.add((Component)mastheadLabel, "North");
        cp.add((Component)this.radioButtonPanel, "Center");
        cp.add((Component)bottomPanel, "South");
        this.createActions();
        this.remoteTF = new JTextField();
        this.remoteTF.addActionListener(this.connectAction);
        this.remoteTF.getDocument().addDocumentListener(this);
        this.remoteTF.addFocusListener(this);
        this.remoteTF.setPreferredSize(this.remoteTF.getPreferredSize());
        Utilities.setAccessibleName(this.remoteTF, Messages.REMOTE_PROCESS_TEXT_FIELD_ACCESSIBLE_NAME);
        if (JConsole.isLocalAttachAvailable()) {
            this.vmModel = new ManagedVmTableModel();
            this.vmTable = new LocalTabJTable(this.vmModel);
            this.vmTable.setSelectionMode(0);
            this.vmTable.setPreferredScrollableViewportSize(new Dimension(400, 250));
            this.vmTable.setColumnSelectionAllowed(false);
            this.vmTable.addFocusListener(this);
            this.vmTable.getSelectionModel().addListSelectionListener(this);
            TableColumnModel columnModel = this.vmTable.getColumnModel();
            TableColumn pidColumn = columnModel.getColumn(1);
            pidColumn.setMaxWidth(ConnectDialog.getLabelWidth("9999999"));
            pidColumn.setResizable(false);
            TableColumn cmdLineColumn = columnModel.getColumn(0);
            cmdLineColumn.setResizable(false);
            this.localRadioButton = new JRadioButton(Messages.LOCAL_PROCESS_COLON);
            this.localRadioButton.setMnemonic(Resources.getMnemonicInt(Messages.LOCAL_PROCESS_COLON));
            this.localRadioButton.setFont(boldLabelFont);
            this.localRadioButton.addItemListener(this);
            radioButtonGroup.add(this.localRadioButton);
            JPanel localPanel = new JPanel(new BorderLayout());
            JPanel localTablePanel = new JPanel(new BorderLayout());
            this.radioButtonPanel.add((Component)localPanel, "North");
            localPanel.add((Component)this.localRadioButton, "North");
            localPanel.add((Component)new Padder(this.localRadioButton), "Before");
            localPanel.add((Component)localTablePanel, "Center");
            this.localTableScrollPane = new JScrollPane(this.vmTable);
            localTablePanel.add((Component)this.localTableScrollPane, "North");
            this.localMessageLabel = new JLabel(" ");
            this.localMessageLabel.setFont(smallLabelFont);
            this.localMessageLabel.setForeground(this.hintTextColor);
            localTablePanel.add((Component)this.localMessageLabel, "South");
        }
        this.remoteRadioButton = new JRadioButton(Messages.REMOTE_PROCESS_COLON);
        this.remoteRadioButton.setMnemonic(Resources.getMnemonicInt(Messages.REMOTE_PROCESS_COLON));
        this.remoteRadioButton.setFont(boldLabelFont);
        radioButtonGroup.add(this.remoteRadioButton);
        JPanel remotePanel = new JPanel(new BorderLayout());
        if (this.localRadioButton != null) {
            remotePanel.add((Component)this.remoteRadioButton, "North");
            remotePanel.add((Component)new Padder(this.remoteRadioButton), "Before");
            AbstractAction nextRadioButtonAction = new AbstractAction("nextRadioButton"){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    JRadioButton rb = ev.getSource() == ConnectDialog.this.localRadioButton ? ConnectDialog.this.remoteRadioButton : ConnectDialog.this.localRadioButton;
                    rb.doClick();
                    rb.requestFocus();
                }
            };
            this.localRadioButton.getActionMap().put("nextRadioButton", nextRadioButtonAction);
            this.remoteRadioButton.getActionMap().put("nextRadioButton", nextRadioButtonAction);
            this.localRadioButton.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "nextRadioButton");
            this.remoteRadioButton.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "nextRadioButton");
        } else {
            JLabel remoteLabel = new JLabel(this.remoteRadioButton.getText());
            remoteLabel.setFont(boldLabelFont);
            remotePanel.add((Component)remoteLabel, "North");
        }
        this.radioButtonPanel.add((Component)remotePanel, "South");
        JPanel remoteTFPanel = new JPanel(new BorderLayout());
        remotePanel.add((Component)remoteTFPanel, "Center");
        remoteTFPanel.add((Component)this.remoteTF, "North");
        this.remoteMessageLabel = new JLabel("<html>" + Messages.REMOTE_TF_USAGE + "</html>");
        this.remoteMessageLabel.setFont(smallLabelFont);
        this.remoteMessageLabel.setForeground(this.hintTextColor);
        remoteTFPanel.add((Component)this.remoteMessageLabel, "Center");
        JPanel userPwdPanel = new JPanel(new FlowLayout(3, 0, 0));
        userPwdPanel.setBorder(new EmptyBorder(12, 0, 0, 0));
        int tfWidth = JConsole.IS_WIN ? 12 : 8;
        this.userNameTF = new JTextField(tfWidth);
        this.userNameTF.addActionListener(this.connectAction);
        this.userNameTF.getDocument().addDocumentListener(this);
        this.userNameTF.addFocusListener(this);
        Utilities.setAccessibleName(this.userNameTF, Messages.USERNAME_ACCESSIBLE_NAME);
        LabeledComponent lc = new LabeledComponent(Messages.USERNAME_COLON_, Resources.getMnemonicInt(Messages.USERNAME_COLON_), this.userNameTF);
        lc.label.setFont(boldLabelFont);
        userPwdPanel.add(lc);
        this.passwordTF = new JPasswordField(tfWidth);
        this.passwordTF.setPreferredSize(this.userNameTF.getPreferredSize());
        this.passwordTF.addActionListener(this.connectAction);
        this.passwordTF.getDocument().addDocumentListener(this);
        this.passwordTF.addFocusListener(this);
        Utilities.setAccessibleName(this.passwordTF, Messages.PASSWORD_ACCESSIBLE_NAME);
        lc = new LabeledComponent(Messages.PASSWORD_COLON_, Resources.getMnemonicInt(Messages.PASSWORD_COLON_), this.passwordTF);
        lc.setBorder(new EmptyBorder(0, 12, 0, 0));
        lc.label.setFont(boldLabelFont);
        userPwdPanel.add(lc);
        remoteTFPanel.add((Component)userPwdPanel, "South");
        String connectButtonToolTipText = Messages.CONNECT_DIALOG_CONNECT_BUTTON_TOOLTIP;
        this.connectButton = new JButton(this.connectAction);
        this.connectButton.setToolTipText(connectButtonToolTipText);
        this.cancelButton = new JButton(this.cancelAction);
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        buttonPanel.setBorder(new EmptyBorder(12, 12, 2, 12));
        if (JConsole.IS_GTK) {
            buttonPanel.add(this.cancelButton);
            buttonPanel.add(this.connectButton);
        } else {
            buttonPanel.add(this.connectButton);
            buttonPanel.add(this.cancelButton);
        }
        bottomPanel.add((Component)buttonPanel, "North");
        bottomPanel.add((Component)this.statusBar, "South");
        this.updateButtonStates();
        Utilities.updateTransparency(this);
    }

    @Override
    public void revalidate() {
        this.hintTextColor = Utilities.ensureContrast(UIManager.getColor("Label.disabledForeground"), UIManager.getColor("Panel.background"));
        this.disabledTableCellColor = Utilities.ensureContrast(new Color(0x808080), UIManager.getColor("Table.background"));
        if (this.remoteMessageLabel != null) {
            this.remoteMessageLabel.setForeground(this.hintTextColor);
            String colorStr = String.format("%06x", this.hintTextColor.getRGB() & 0xFFFFFF);
            this.remoteMessageLabel.setText("<html><font color=#" + colorStr + ">" + Messages.REMOTE_TF_USAGE);
        }
        if (this.localMessageLabel != null) {
            this.localMessageLabel.setForeground(this.hintTextColor);
            this.valueChanged(null);
        }
        super.revalidate();
    }

    private void createActions() {
        this.connectAction = new AbstractAction(Messages.CONNECT){
            {
                this.putValue("MnemonicKey", Resources.getMnemonicInt(Messages.CONNECT));
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!this.isEnabled() || !ConnectDialog.this.isVisible()) {
                    return;
                }
                ConnectDialog.this.setVisible(false);
                ConnectDialog.this.statusBar.setText("");
                if (ConnectDialog.this.remoteRadioButton.isSelected()) {
                    String txt = ConnectDialog.this.remoteTF.getText().trim();
                    String userName = ConnectDialog.this.userNameTF.getText().trim();
                    userName = userName.equals("") ? null : userName;
                    String password = ConnectDialog.this.passwordTF.getText();
                    password = password.equals("") ? null : password;
                    try {
                        if (txt.startsWith("service:jmx:")) {
                            String url = txt;
                            ConnectDialog.this.jConsole.addUrl(url, userName, password, false);
                            ConnectDialog.this.remoteTF.setText("service:jmx:");
                            return;
                        }
                        String host = ConnectDialog.this.remoteTF.getText().trim();
                        String port = "0";
                        int index = host.lastIndexOf(":");
                        if (index >= 0) {
                            port = host.substring(index + 1);
                            host = host.substring(0, index);
                        }
                        if (host.length() > 0 && port.length() > 0) {
                            int p = Integer.parseInt(port.trim());
                            ConnectDialog.this.jConsole.addHost(host, p, userName, password);
                            ConnectDialog.this.remoteTF.setText("");
                            ConnectDialog.this.userNameTF.setText("");
                            ConnectDialog.this.passwordTF.setText("");
                            return;
                        }
                    }
                    catch (Exception ex) {
                        ConnectDialog.this.statusBar.setText(ex.toString());
                    }
                    ConnectDialog.this.setVisible(true);
                } else if (ConnectDialog.this.localRadioButton != null && ConnectDialog.this.localRadioButton.isSelected()) {
                    int row = ConnectDialog.this.vmTable.getSelectedRow();
                    if (row >= 0) {
                        ConnectDialog.this.jConsole.addVmid(ConnectDialog.this.vmModel.vmAt(row));
                    }
                    ConnectDialog.this.refresh();
                }
            }
        };
        this.cancelAction = new AbstractAction(Messages.CANCEL){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ConnectDialog.this.setVisible(false);
                ConnectDialog.this.statusBar.setText("");
            }
        };
    }

    public static int getLabelWidth(String text) {
        tmpLabel.setText(text);
        return (int)tmpLabel.getPreferredSize().getWidth() + 1;
    }

    public void setConnectionParameters(String url, String host, int port, String userName, String password, String msg) {
        if (url != null && url.length() > 0 || host != null && host.length() > 0 && port > 0) {
            this.remoteRadioButton.setSelected(true);
            if (url != null && url.length() > 0) {
                this.remoteTF.setText(url);
            } else {
                this.remoteTF.setText(host + ":" + port);
            }
            this.userNameTF.setText(userName != null ? userName : "");
            this.passwordTF.setText(password != null ? password : "");
            this.statusBar.setText(msg != null ? msg : "");
            if (this.getPreferredSize().width > this.getWidth()) {
                this.pack();
            }
            this.remoteTF.requestFocus();
            this.remoteTF.selectAll();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ev) {
        if (!this.localRadioButton.isSelected()) {
            this.vmTable.getSelectionModel().clearSelection();
        }
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        int row;
        boolean connectEnabled = false;
        if (this.remoteRadioButton.isSelected()) {
            connectEnabled = JConsole.isValidRemoteString(this.remoteTF.getText());
        } else if (this.localRadioButton != null && this.localRadioButton.isSelected() && (row = this.vmTable.getSelectedRow()) >= 0) {
            LocalVirtualMachine lvm = this.vmModel.vmAt(row);
            connectEnabled = lvm.isManageable() || lvm.isAttachable();
        }
        this.connectAction.setEnabled(connectEnabled);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateButtonStates();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateButtonStates();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateButtonStates();
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        Component opposite = e.getOppositeComponent();
        if (!e.isTemporary() && source instanceof JTextField && opposite instanceof JComponent && SwingUtilities.getRootPane(opposite) == this.getRootPane()) {
            ((JTextField)source).selectAll();
        }
        if (source == this.remoteTF) {
            this.remoteRadioButton.setSelected(true);
        } else if (source == this.vmTable) {
            this.localRadioButton.setSelected(true);
            if (this.vmModel.getRowCount() == 1) {
                this.vmTable.setRowSelectionInterval(0, 0);
            }
        }
        this.updateButtonStates();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        char c = e.getKeyChar();
        if (c == '\u001b') {
            this.setVisible(false);
        } else if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
            this.getToolkit().beep();
            e.consume();
        }
    }

    @Override
    public void setVisible(boolean b) {
        boolean wasVisible = this.isVisible();
        super.setVisible(b);
        if (b && !wasVisible) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ConnectDialog.this.remoteRadioButton.isSelected()) {
                        ConnectDialog.this.remoteTF.requestFocus();
                        ConnectDialog.this.remoteTF.selectAll();
                    }
                }
            });
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        LocalVirtualMachine lvm;
        this.updateButtonStates();
        String labelText = " ";
        int row = this.vmTable.getSelectedRow();
        if (row >= 0 && !(lvm = this.vmModel.vmAt(row)).isManageable()) {
            labelText = lvm.isAttachable() ? Messages.MANAGEMENT_WILL_BE_ENABLED : Messages.MANAGEMENT_NOT_ENABLED;
        }
        String colorStr = String.format("%06x", this.hintTextColor.getRGB() & 0xFFFFFF);
        this.localMessageLabel.setText("<html><font color=#" + colorStr + ">" + labelText);
    }

    public void refresh() {
        if (this.vmModel != null) {
            LocalVirtualMachine selected = null;
            int row = this.vmTable.getSelectedRow();
            if (row >= 0) {
                selected = this.vmModel.vmAt(row);
            }
            this.vmModel.refresh();
            int selectRow = -1;
            int n = this.vmModel.getRowCount();
            if (selected != null) {
                for (int i = 0; i < n; ++i) {
                    LocalVirtualMachine lvm = this.vmModel.vmAt(i);
                    if (selected.vmid() != lvm.vmid() || !selected.toString().equals(lvm.toString())) continue;
                    selectRow = i;
                    break;
                }
            }
            if (selectRow > -1) {
                this.vmTable.setRowSelectionInterval(selectRow, selectRow);
            } else {
                this.vmTable.getSelectionModel().clearSelection();
            }
            Dimension dim = this.vmTable.getPreferredSize();
            dim.height = Math.min(dim.height - 1, 100);
            this.localTableScrollPane.setVerticalScrollBarPolicy(dim.height < 100 ? 21 : 20);
            this.localTableScrollPane.getViewport().setMinimumSize(dim);
            this.localTableScrollPane.getViewport().setPreferredSize(dim);
        }
        this.pack();
        this.setLocationRelativeTo(this.jConsole);
    }

    private static class Padder
    extends JPanel {
        JRadioButton radioButton;

        Padder(JRadioButton radioButton) {
            this.radioButton = radioButton;
            Utilities.setAccessibleName(this, Messages.BLANK);
        }

        @Override
        public Dimension getPreferredSize() {
            Rectangle r = Padder.getTextRectangle(this.radioButton);
            int w = r != null && r.x > 8 ? r.x : 22;
            return new Dimension(w, 0);
        }

        private static Rectangle getTextRectangle(AbstractButton button) {
            Icon icon;
            String text = button.getText();
            Icon icon2 = icon = button.isEnabled() ? button.getIcon() : button.getDisabledIcon();
            if (icon == null && button.getUI() instanceof BasicRadioButtonUI) {
                icon = ((BasicRadioButtonUI)button.getUI()).getDefaultIcon();
            }
            if (icon == null && text == null) {
                return null;
            }
            Rectangle paintIconR = new Rectangle();
            Rectangle paintTextR = new Rectangle();
            Rectangle paintViewR = new Rectangle();
            Insets paintViewInsets = new Insets(0, 0, 0, 0);
            paintViewInsets = button.getInsets(paintViewInsets);
            paintViewR.x = paintViewInsets.left;
            paintViewR.y = paintViewInsets.top;
            paintViewR.width = button.getWidth() - (paintViewInsets.left + paintViewInsets.right);
            paintViewR.height = button.getHeight() - (paintViewInsets.top + paintViewInsets.bottom);
            Graphics g = button.getGraphics();
            if (g == null) {
                return null;
            }
            SwingUtilities.layoutCompoundLabel(button, g.getFontMetrics(), text, icon, button.getVerticalAlignment(), button.getHorizontalAlignment(), button.getVerticalTextPosition(), button.getHorizontalTextPosition(), paintViewR, paintIconR, paintTextR, button.getIconTextGap());
            return paintTextR;
        }
    }

    private static class ManagedVmTableModel
    extends AbstractTableModel {
        private static String[] columnNames = new String[]{Messages.COLUMN_NAME, Messages.COLUMN_PID};
        private List<LocalVirtualMachine> vmList;

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return columnNames[col];
        }

        @Override
        public synchronized int getRowCount() {
            return this.vmList.size();
        }

        @Override
        public synchronized Object getValueAt(int row, int col) {
            assert (col >= 0 && col <= columnNames.length);
            LocalVirtualMachine vm = this.vmList.get(row);
            switch (col) {
                case 0: {
                    return vm.displayName();
                }
                case 1: {
                    return vm.vmid();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Integer.class;
                }
            }
            return super.getColumnClass(column);
        }

        public ManagedVmTableModel() {
            this.refresh();
        }

        public synchronized LocalVirtualMachine vmAt(int pos) {
            return this.vmList.get(pos);
        }

        public synchronized void refresh() {
            Map<Integer, LocalVirtualMachine> map = LocalVirtualMachine.getAllVirtualMachines();
            this.vmList = new ArrayList<LocalVirtualMachine>();
            this.vmList.addAll(map.values());
            this.fireTableDataChanged();
        }
    }

    private class LocalTabJTable
    extends JTable {
        ManagedVmTableModel vmModel;
        Border rendererBorder;

        public LocalTabJTable(ManagedVmTableModel model) {
            super(model);
            this.rendererBorder = new EmptyBorder(0, 6, 0, 6);
            this.vmModel = model;
            if (!JConsole.IS_GTK) {
                this.setShowVerticalLines(false);
                this.setIntercellSpacing(new Dimension(0, 1));
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (evt.getClickCount() == 2) {
                        ConnectDialog.this.connectButton.doClick();
                    }
                }
            });
            this.getActionMap().put("connect", ConnectDialog.this.connectAction);
            InputMap inputMap = this.getInputMap(1);
            inputMap.put(KeyStroke.getKeyStroke(10, 0), "connect");
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            String tip = null;
            Point p = e.getPoint();
            int rowIndex = this.rowAtPoint(p);
            int colIndex = this.columnAtPoint(p);
            int realColumnIndex = this.convertColumnIndexToModel(colIndex);
            if (realColumnIndex == 0) {
                LocalVirtualMachine vmd = this.vmModel.vmAt(rowIndex);
                tip = vmd.toString();
            }
            return tip;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    LocalVirtualMachine lvm;
                    Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (!(isSelected || (lvm = LocalTabJTable.this.vmModel.vmAt(row)).isManageable() || lvm.isAttachable())) {
                        comp.setForeground(ConnectDialog.this.disabledTableCellColor);
                    }
                    if (comp instanceof JLabel) {
                        JLabel label = (JLabel)comp;
                        label.setBorder(LocalTabJTable.this.rendererBorder);
                        if (value instanceof Integer) {
                            label.setHorizontalAlignment(4);
                        }
                    }
                    return comp;
                }
            };
        }
    }
}

