/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Singleton;
import com.google.inject.internal.CircularDependencyProxy;
import com.google.inject.internal.LinkedBindingImpl;
import com.google.inject.internal.SingletonScope;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.ExposedBinding;
import java.lang.annotation.Annotation;

public class Scopes {
    public static final Scope SINGLETON = new SingletonScope();
    public static final Scope NO_SCOPE = new Scope(){

        @Override
        public <T> Provider<T> scope(Key<T> key2, Provider<T> unscoped) {
            return unscoped;
        }

        @Override
        public String toString() {
            return "Scopes.NO_SCOPE";
        }
    };
    private static final BindingScopingVisitor<Boolean> IS_SINGLETON_VISITOR = new BindingScopingVisitor<Boolean>(){

        @Override
        public Boolean visitNoScoping() {
            return false;
        }

        @Override
        public Boolean visitScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
            return scopeAnnotation == Singleton.class || scopeAnnotation == javax.inject.Singleton.class;
        }

        @Override
        public Boolean visitScope(Scope scope) {
            return scope == SINGLETON;
        }

        @Override
        public Boolean visitEagerSingleton() {
            return true;
        }
    };

    private Scopes() {
    }

    public static boolean isSingleton(Binding<?> binding2) {
        while (true) {
            ExposedBinding exposedBinding;
            Injector injector;
            boolean singleton;
            if (singleton = binding2.acceptScopingVisitor(IS_SINGLETON_VISITOR).booleanValue()) {
                return true;
            }
            if (binding2 instanceof LinkedBindingImpl) {
                LinkedBindingImpl linkedBinding = (LinkedBindingImpl)binding2;
                injector = linkedBinding.getInjector();
                if (injector == null) break;
                binding2 = injector.getBinding(linkedBinding.getLinkedKey());
                continue;
            }
            if (!(binding2 instanceof ExposedBinding) || (injector = (exposedBinding = (ExposedBinding)binding2).getPrivateElements().getInjector()) == null) break;
            binding2 = injector.getBinding(exposedBinding.getKey());
        }
        return false;
    }

    public static boolean isScoped(Binding<?> binding2, final Scope scope, final Class<? extends Annotation> scopeAnnotation) {
        while (true) {
            ExposedBinding exposedBinding;
            Injector injector;
            boolean matches;
            if (matches = binding2.acceptScopingVisitor(new BindingScopingVisitor<Boolean>(){

                @Override
                public Boolean visitNoScoping() {
                    return false;
                }

                @Override
                public Boolean visitScopeAnnotation(Class<? extends Annotation> visitedAnnotation) {
                    return visitedAnnotation == scopeAnnotation;
                }

                @Override
                public Boolean visitScope(Scope visitedScope) {
                    return visitedScope == scope;
                }

                @Override
                public Boolean visitEagerSingleton() {
                    return false;
                }
            }).booleanValue()) {
                return true;
            }
            if (binding2 instanceof LinkedBindingImpl) {
                LinkedBindingImpl linkedBinding = (LinkedBindingImpl)binding2;
                injector = linkedBinding.getInjector();
                if (injector == null) break;
                binding2 = injector.getBinding(linkedBinding.getLinkedKey());
                continue;
            }
            if (!(binding2 instanceof ExposedBinding) || (injector = (exposedBinding = (ExposedBinding)binding2).getPrivateElements().getInjector()) == null) break;
            binding2 = injector.getBinding(exposedBinding.getKey());
        }
        return false;
    }

    public static boolean isCircularProxy(Object object) {
        return object instanceof CircularDependencyProxy;
    }
}

