//
// libsemigroups - C++ library for semigroups and monoids
// Copyright (C) 2019-20 James D. Mitchell
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

// This file includes all the headers in libsemigroups, for convenience.

#ifndef LIBSEMIGROUPS_LIBSEMIGROUPS_HPP_
#define LIBSEMIGROUPS_LIBSEMIGROUPS_HPP_

#include "action.hpp"
#include "adapters.hpp"
#include "bitset.hpp"
#include "blocks.hpp"
#include "bmat8.hpp"
#include "bruidhinn-traits.hpp"
#include "cong-intf.hpp"
#include "cong-pair.hpp"
#include "cong-wrap.hpp"
#include "cong.hpp"
#include "constants.hpp"
#include "containers.hpp"
#include "coset.hpp"
#include "deprecated.hpp"
#include "digraph-helper.hpp"
#include "digraph.hpp"
#include "element-adapters.hpp"
#include "element-helper.hpp"
#include "element.hpp"
#include "forest.hpp"
#include "fpsemi-intf.hpp"
#include "fpsemi.hpp"
#include "froidure-pin-base.hpp"
#include "froidure-pin.hpp"
#include "function-ref.hpp"
#include "hpcombi.hpp"
#include "int-range.hpp"
#include "iterator.hpp"
#include "kbe.hpp"
#include "knuth-bendix.hpp"
#include "konieczny.hpp"
#include "libsemigroups-config.hpp"
#include "libsemigroups-debug.hpp"
#include "libsemigroups-exception.hpp"
#include "obvinf.hpp"
#include "order.hpp"
#include "pool.hpp"
#include "race.hpp"
#include "report.hpp"
#include "runner.hpp"
#include "schreier-sims.hpp"
#include "semiring.hpp"
#include "siso.hpp"
#include "stl.hpp"
#include "string.hpp"
#include "tce.hpp"
#include "timer.hpp"
#include "todd-coxeter.hpp"
#include "transf.hpp"
#include "types.hpp"
#include "uf.hpp"
#include "wilo.hpp"
#include "wislo.hpp"
#include "word.hpp"

#endif  // LIBSEMIGROUPS_LIBSEMIGROUPS_HPP_
