# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

from __future__ import absolute_import, division, print_function

__metaclass__ = type

from ansible_collections.junipernetworks.junos.tests.unit.compat.mock import (
    patch,
    MagicMock,
)
from ansible_collections.junipernetworks.junos.plugins.modules import (
    junos_bgp_global,
)
from ansible_collections.junipernetworks.junos.tests.unit.modules.utils import (
    set_module_args,
)
from .junos_module import TestJunosModule, load_fixture


class TestJunosBgp_globalModule(TestJunosModule):
    module = junos_bgp_global

    def setUp(self):
        super(TestJunosBgp_globalModule, self).setUp()
        self.mock_lock_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.junos.lock_configuration"
        )
        self.lock_configuration = self.mock_lock_configuration.start()
        self.mock_unlock_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.junos.unlock_configuration"
        )
        self.unlock_configuration = self.mock_unlock_configuration.start()
        self.mock_load_config = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.bgp_global.bgp_global.load_config"
        )
        self.load_config = self.mock_load_config.start()

        self.mock_validate_config = patch(
            "ansible_collections.ansible.netcommon.plugins.module_utils.network.common.utils.validate_config"
        )
        self.validate_config = self.mock_validate_config.start()

        self.mock_commit_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.bgp_global.bgp_global.commit_configuration"
        )
        self.mock_commit_configuration = self.mock_commit_configuration.start()

        self.mock_get_connection = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.facts.bgp_global.bgp_global."
            "Bgp_globalFacts.get_connection"
        )
        self.get_connection = self.mock_get_connection.start()

        self.conn = self.get_connection()
        self.conn.get = MagicMock()

        self.mock_get_xml_dict = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.facts."
            "bgp_global.bgp_global.Bgp_globalFacts._get_xml_dict"
        )
        self._get_xml_dict = self.mock_get_xml_dict.start()

    def tearDown(self):
        super(TestJunosBgp_globalModule, self).tearDown()
        self.mock_get_connection.stop()
        self.mock_load_config.stop()
        self.mock_validate_config.stop()
        self.mock_lock_configuration.stop()
        self.mock_unlock_configuration.stop()
        self.mock_commit_configuration.stop()

    def load_fixtures(self, commands=None, format="text", changed=False):
        self.get_connection.return_value = load_fixture(
            "junos_bgp_global_config.cfg"
        )
        if changed:
            self.load_config.return_value = load_fixture(
                "get_configuration_rpc_reply_diff.txt"
            )
        else:
            self.load_config.return_value = None

    def test_junos_bgp_global_merged(self):
        set_module_args(
            dict(
                config=dict(
                    damping=True,
                    description="This is configured with Junos_bgp resource module",
                    preference="2",
                    bfd_liveness_detection=dict(
                        minimum_receive_interval=4,
                        multiplier=10,
                        no_adaptation=True,
                        version="automatic",
                    ),
                ),
                state="merged",
            )
        )

        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:bgp>'
            "<nc:damping/><nc:description>This is configured with Junos_bgp resource module</nc:description>"
            "<nc:preference>2</nc:preference><nc:bfd-liveness-detection>"
            "<nc:minimum-receive-interval>4</nc:minimum-receive-interval>"
            "<nc:multiplier>10</nc:multiplier><nc:no-adaptation/>"
            "<nc:version>automatic</nc:version></nc:bfd-liveness-detection>"
            "</nc:bgp></nc:protocols>"
        ]
        result = self.execute_module(changed=True)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_bgp_global_merged_idempotent(self):
        self.get_connection.return_value = load_fixture(
            "junos_bgp_global_config.cfg"
        )
        src = load_fixture("junos_bgp_global.cfg", content="str")
        set_module_args(dict(src=src))
        set_module_args(
            dict(
                config=dict(
                    advertise_from_main_vpn_tables=True,
                    accept_remote_nexthop=True,
                    damping=True,
                    no_advertise_peer_as=True,
                    description="This is configured with Junos_bgp resource module",
                    preference="2",
                ),
                state="merged",
            )
        )
        self.execute_module(changed=False, commands=[])

    def test_junos_bgp_global_replaced(self):
        set_module_args(
            dict(
                config=dict(
                    damping=True,
                    description="Replaced by Junos bgp global module",
                    preference="3",
                    bfd_liveness_detection=dict(
                        minimum_receive_interval=4,
                        multiplier=20,
                        no_adaptation=True,
                        version="automatic",
                    ),
                ),
                state="replaced",
            )
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:bgp>'
            '<nc:accept-remote-nexthop delete="delete"/><nc:add-path-display-ipv4-address delete="delete"/>'
            '<nc:advertise-bgp-static delete="delete"/>'
            '<nc:advertise-external delete="delete"/><nc:advertise-from-main-vpn-tables delete="delete"/>'
            '<nc:advertise-inactive delete="delete"/><nc:advertise-peer-as delete="delete"/>'
            '<nc:authentication-algorithm delete="delete"/><nc:authentication-key delete="delete"/>'
            '<nc:authentication-key-chain delete="delete"/><nc:bfd-liveness-detection delete="delete"/>'
            '<nc:bgp-error-tolerance delete="delete"/><nc:bmp delete="delete"/><nc:cluster delete="delete"/>'
            '<nc:damping delete="delete"/><nc:description delete="delete"/><nc:disable delete="delete"/>'
            '<nc:egress-te-sid-stats delete="delete"/><nc:enforce-first-as delete="delete"/><nc:export delete="delete"/>'
            '<nc:forwarding-context delete="delete"/><nc:hold-time delete="delete"/>'
            '<nc:holddown-all-stale-labels delete="delete"/>'
            '<nc:import delete="delete"/><nc:include-mp-next-hop delete="delete"/><nc:ipsec-sa delete="delete"/>'
            '<nc:keep delete="delete"/><nc:local-address delete="delete"/><nc:local-interface delete="delete"/>'
            '<nc:local-preference delete="delete"/><nc:log-updown delete="delete"/><nc:mtu-discovery delete="delete"/>'
            '<nc:no-advertise-peer-as delete="delete"/><nc:no-aggregator-id delete="delete"/>'
            '<nc:no-client-reflect delete="delete"/>'
            '<nc:no-precision-timers delete="delete"/><nc:passive delete="delete"/><nc:peer-as delete="delete"/>'
            '<nc:precision-timers delete="delete"/><nc:preference delete="delete"/><nc:out-delay delete="delete"/>'
            '<nc:rfc6514-compliant-safi129 delete="delete"/><nc:route-server-client delete="delete"/>'
            '<nc:send-addpath-optimization delete="delete"/><nc:sr-preference-override delete="delete"/>'
            '<nc:stale-labels-holddown-period delete="delete"/><nc:tcp-aggressive-transmission delete="delete"/>'
            '<nc:tcp-mss delete="delete"/><nc:ttl delete="delete"/>'
            '<nc:unconfigured-peer-graceful-restart delete="delete"/>'
            '<nc:vpn-apply-export delete="delete"/></nc:bgp><nc:bgp><nc:damping/>'
            "<nc:description>Replaced by Junos bgp global module</nc:description><nc:preference>3</nc:preference>"
            "<nc:bfd-liveness-detection><nc:minimum-receive-interval>4</nc:minimum-receive-interval>"
            "<nc:multiplier>20</nc:multiplier><nc:no-adaptation/>"
            "<nc:version>automatic</nc:version></nc:bfd-liveness-detection>"
            "</nc:bgp></nc:protocols>"
        ]
        result = self.execute_module(changed=True)
        self.assertEqual(sorted(result["commands"]), commands)

    def test_junos_bgp_global_replaced_idempotent(self):
        self.get_connection.return_value = load_fixture(
            "junos_bgp_global_config.cfg"
        )
        src = load_fixture("junos_bgp_global.cfg", content="str")
        set_module_args(dict(src=src))
        set_module_args(
            dict(
                config=dict(
                    advertise_from_main_vpn_tables=True,
                    accept_remote_nexthop=True,
                    damping=True,
                    no_advertise_peer_as=True,
                    description="This is configured with Junos_bgp resource module",
                    preference="2",
                ),
                state="replaced",
            )
        )

        self.execute_module(changed=False, commands=[])

    def test_junos_bgp_global_delete(self):
        self.get_connection.return_value = load_fixture(
            "junos_bgp_global_config.cfg"
        )
        src = load_fixture("junos_bgp_global.cfg", content="str")
        set_module_args(dict(src=src))
        set_module_args(dict(config=dict(), state="deleted"))

        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:bgp>'
            '<nc:accept-remote-nexthop delete="delete"/>'
            '<nc:add-path-display-ipv4-address delete="delete"/><nc:advertise-bgp-static delete="delete"/>'
            '<nc:advertise-external delete="delete"/><nc:advertise-from-main-vpn-tables delete="delete"/>'
            '<nc:advertise-inactive delete="delete"/><nc:advertise-peer-as delete="delete"/>'
            '<nc:authentication-algorithm delete="delete"/><nc:authentication-key delete="delete"/>'
            '<nc:authentication-key-chain delete="delete"/><nc:bfd-liveness-detection delete="delete"/>'
            '<nc:bgp-error-tolerance delete="delete"/><nc:bmp delete="delete"/><nc:cluster delete="delete"/>'
            '<nc:damping delete="delete"/><nc:description delete="delete"/><nc:disable delete="delete"/>'
            '<nc:egress-te-sid-stats delete="delete"/><nc:enforce-first-as delete="delete"/>'
            '<nc:export delete="delete"/>'
            '<nc:forwarding-context delete="delete"/><nc:hold-time delete="delete"/>'
            '<nc:holddown-all-stale-labels delete="delete"/><nc:import delete="delete"/>'
            '<nc:include-mp-next-hop delete="delete"/><nc:ipsec-sa delete="delete"/>'
            '<nc:keep delete="delete"/><nc:local-address delete="delete"/><nc:local-interface delete="delete"/>'
            '<nc:local-preference delete="delete"/><nc:log-updown delete="delete"/><nc:mtu-discovery delete="delete"/>'
            '<nc:no-advertise-peer-as delete="delete"/><nc:no-aggregator-id delete="delete"/>'
            '<nc:no-client-reflect delete="delete"/><nc:no-precision-timers delete="delete"/>'
            '<nc:passive delete="delete"/>'
            '<nc:peer-as delete="delete"/><nc:precision-timers delete="delete"/><nc:preference delete="delete"/>'
            '<nc:out-delay delete="delete"/><nc:rfc6514-compliant-safi129 delete="delete"/>'
            '<nc:route-server-client delete="delete"/><nc:send-addpath-optimization delete="delete"/>'
            '<nc:sr-preference-override delete="delete"/><nc:stale-labels-holddown-period delete="delete"/>'
            '<nc:tcp-aggressive-transmission delete="delete"/><nc:tcp-mss delete="delete"/><nc:ttl delete="delete"/>'
            '<nc:unconfigured-peer-graceful-restart delete="delete"/>'
            '<nc:vpn-apply-export delete="delete"/></nc:bgp></nc:protocols>'
        ]
        result = self.execute_module(changed=True)
        self.assertEqual(sorted(result["commands"]), commands)

    def test_junos_bgp_global_delete_idempotent(self):
        set_module_args(dict(state="deleted"))
        self.execute_module(changed=False, commands=[])

    def test_junos_bgp_global_purged(self):
        self.get_connection.return_value = load_fixture(
            "junos_bgp_global_config.cfg"
        )
        src = load_fixture("junos_bgp_global.cfg", content="str")
        set_module_args(dict(src=src))
        set_module_args(dict(config=dict(), state="purged"))

        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:bgp delete="delete"/></nc:protocols>'
        ]
        result = self.execute_module(changed=True)
        self.assertEqual(sorted(result["commands"]), commands)

    def test_junos_bgp_global_purged_idempotent(self):
        set_module_args(dict(state="purged"))
        self.execute_module(changed=False, commands=[])

    def test_junos_bgp_global_rendered(self):
        set_module_args(
            dict(
                config=dict(
                    damping=True,
                    description="This is configured with Junos_bgp resource module",
                    preference="2",
                    bfd_liveness_detection=dict(
                        minimum_receive_interval=4,
                        multiplier=10,
                        no_adaptation=True,
                        version="automatic",
                    ),
                ),
                state="merged",
            )
        )
        commands = [
            '<nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:bgp>'
            "<nc:damping/><nc:description>This is configured with Junos_bgp resource module</nc:description>"
            "<nc:preference>2</nc:preference><nc:bfd-liveness-detection>"
            "<nc:minimum-receive-interval>4</nc:minimum-receive-interval>"
            "<nc:multiplier>10</nc:multiplier><nc:no-adaptation/><nc:version>automatic</nc:version>"
            "</nc:bfd-liveness-detection>"
            "</nc:bgp></nc:protocols>"
        ]
        self.execute_module(changed=False, commands=commands)
