"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_GLOB_PATTERN = '**/*@(.sh|.inc|.bash|.command)';
function getExplainshellEndpoint() {
    const { EXPLAINSHELL_ENDPOINT } = process.env;
    return typeof EXPLAINSHELL_ENDPOINT === 'string' && EXPLAINSHELL_ENDPOINT.trim() !== ''
        ? EXPLAINSHELL_ENDPOINT
        : null;
}
exports.getExplainshellEndpoint = getExplainshellEndpoint;
function getGlobPattern() {
    const { GLOB_PATTERN } = process.env;
    return typeof GLOB_PATTERN === 'string' && GLOB_PATTERN.trim() !== ''
        ? GLOB_PATTERN
        : exports.DEFAULT_GLOB_PATTERN;
}
exports.getGlobPattern = getGlobPattern;
function getHighlightParsingError() {
    const { HIGHLIGHT_PARSING_ERRORS } = process.env;
    return typeof HIGHLIGHT_PARSING_ERRORS !== 'undefined'
        ? HIGHLIGHT_PARSING_ERRORS === 'true' || HIGHLIGHT_PARSING_ERRORS === '1'
        : false;
}
exports.getHighlightParsingError = getHighlightParsingError;
//# sourceMappingURL=config.js.map