/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.rtp;

import com.sun.media.protocol.BasicPushBufferDataSource;
import com.sun.media.protocol.BufferListener;
import com.sun.media.protocol.RTPSource;
import com.sun.media.protocol.Streamable;
import com.sun.media.rtp.RTPControlImpl;
import com.sun.media.rtp.RTPSessionMgr;
import com.sun.media.rtp.RTPSourceStream;
import com.sun.media.rtp.SSRCInfo;
import java.io.IOException;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.RTPControl;

public class DataSource
extends BasicPushBufferDataSource
implements Streamable,
RTPSource {
    static int SSRC_UNDEFINED = 0;
    private RTPSourceStream[] srcStreams = null;
    private boolean stopped = true;
    Player streamplayer = null;
    RTPSessionMgr mgr = null;
    RTPControl rtpcontrol = null;
    DataSource childsrc = null;
    int ssrc = SSRC_UNDEFINED;

    public void setMgr(RTPSessionMgr mgr) {
        this.mgr = mgr;
    }

    public RTPSessionMgr getMgr() {
        return this.mgr;
    }

    public void setChild(DataSource source) {
        this.childsrc = source;
    }

    public DataSource() {
        this.srcStreams = new RTPSourceStream[1];
        this.rtpcontrol = new MyRTPControl();
        this.setContentType("rtp");
    }

    public PushBufferStream[] getStreams() {
        if (!this.connected) {
            return null;
        }
        return this.srcStreams;
    }

    public void setPlayer(Player player) {
        this.streamplayer = player;
    }

    public Player getPlayer() {
        return this.streamplayer;
    }

    public void setSourceStream(RTPSourceStream stream) {
        if (this.srcStreams != null) {
            this.srcStreams[0] = stream;
        }
    }

    public void setBufferListener(BufferListener listener) {
        this.srcStreams[0].setBufferListener(listener);
    }

    public void setLocator(MediaLocator mrl) {
        super.setLocator(mrl);
    }

    public void setBufferWhenStopped(boolean flag) {
        this.srcStreams[0].setBufferWhenStopped(flag);
    }

    public void prebuffer() {
        this.started = true;
        this.srcStreams[0].prebuffer();
    }

    public void flush() {
        this.srcStreams[0].reset();
    }

    public void setSSRC(int ssrc) {
        this.ssrc = ssrc;
    }

    public int getSSRC() {
        return this.ssrc;
    }

    public String getCNAME() {
        if (this.mgr == null) {
            return null;
        }
        SSRCInfo info = this.mgr.getSSRCInfo(this.ssrc);
        if (info != null) {
            return info.getCNAME();
        }
        return null;
    }

    public void start() throws IOException {
        super.start();
        if (this.childsrc != null) {
            this.childsrc.start();
        }
        if (this.srcStreams != null) {
            int i = 0;
            while (i < this.srcStreams.length) {
                this.srcStreams[i].start();
                ++i;
            }
        }
    }

    public void stop() throws IOException {
        super.stop();
        if (this.childsrc != null) {
            this.childsrc.stop();
        }
        if (this.srcStreams != null) {
            int i = 0;
            while (i < this.srcStreams.length) {
                this.srcStreams[i].stop();
                ++i;
            }
        }
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void connect() throws IOException {
        if (this.srcStreams != null) {
            int i = 0;
            while (i < this.srcStreams.length) {
                if (this.srcStreams[i] != null) {
                    this.srcStreams[i].connect();
                }
                ++i;
            }
        }
        this.connected = true;
    }

    public void disconnect() {
        if (this.srcStreams != null) {
            int i = 0;
            while (i < this.srcStreams.length) {
                this.srcStreams[i].close();
                ++i;
            }
        }
    }

    public Object[] getControls() {
        Object[] controls = new RTPControl[]{this.rtpcontrol};
        return controls;
    }

    public void setControl(Object control) {
        this.rtpcontrol = (RTPControl)control;
    }

    public Object getControl(String type) {
        Class<?> cls;
        try {
            cls = Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        Object[] cs = this.getControls();
        int i = 0;
        while (i < cs.length) {
            if (cls.isInstance(cs[i])) {
                return cs[i];
            }
            ++i;
        }
        return null;
    }

    public boolean isPrefetchable() {
        return false;
    }

    class MyRTPControl
    extends RTPControlImpl {
        MyRTPControl() {
        }

        public int getSSRC() {
            return DataSource.this.ssrc;
        }

        public String getCNAME() {
            if (DataSource.this.mgr == null) {
                return null;
            }
            SSRCInfo info = DataSource.this.mgr.getSSRCInfo(DataSource.this.ssrc);
            if (info != null) {
                return info.getCNAME();
            }
            return null;
        }
    }
}

