/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.AbstractConnection;
import com.ericsson.otp.erlang.GenericQueue;
import com.ericsson.otp.erlang.Links;
import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangExit;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpMsg;
import com.ericsson.otp.erlang.OtpOutputStream;
import com.ericsson.otp.erlang.OtpPeer;
import com.ericsson.otp.erlang.OtpSelf;
import com.ericsson.otp.erlang.OtpTransport;
import java.io.IOException;

public class OtpConnection
extends AbstractConnection {
    protected OtpSelf self;
    protected GenericQueue queue;
    protected Links links;
    private long unlink_id;

    OtpConnection(OtpSelf otpSelf, OtpTransport otpTransport) throws IOException, OtpAuthException {
        super((OtpLocalNode)otpSelf, otpTransport);
        this.self = otpSelf;
        this.queue = new GenericQueue();
        this.start();
    }

    OtpConnection(OtpSelf otpSelf, OtpPeer otpPeer) throws IOException, OtpAuthException {
        super((OtpLocalNode)otpSelf, otpPeer);
        this.self = otpSelf;
        this.queue = new GenericQueue();
        this.start();
    }

    @Override
    public void deliver(Exception exception) {
        this.queue.put(exception);
    }

    @Override
    public void deliver(OtpMsg otpMsg) {
        switch (otpMsg.type()) {
            case 1: 
            case 3: 
            case 4: 
            case 35: 
            case 36: {
                this.handle_link_operation(otpMsg);
                break;
            }
            default: {
                this.queue.put(otpMsg);
            }
        }
    }

    private synchronized void handle_link_operation(OtpMsg otpMsg) {
        OtpErlangPid otpErlangPid = otpMsg.getSenderPid();
        switch (otpMsg.type()) {
            case 1: {
                if (!this.links.addLink(this.self.pid(), otpErlangPid, false)) break;
                this.queue.put(otpMsg);
                break;
            }
            case 4: 
            case 35: {
                long l = otpMsg.getUnlinkId();
                if (this.links.removeActiveLink(this.self.pid(), otpErlangPid)) {
                    this.queue.put(new OtpMsg(4, this.self.pid(), otpErlangPid));
                }
                try {
                    super.sendUnlinkAck(this.self.pid(), otpErlangPid, l);
                }
                catch (Exception exception) {}
                break;
            }
            case 36: {
                this.links.removeUnlinkingLink(this.self.pid(), otpErlangPid, otpMsg.getUnlinkId());
                break;
            }
            case 3: {
                if (!this.links.removeActiveLink(this.self.pid(), otpErlangPid)) break;
                this.queue.put(otpMsg);
            }
        }
    }

    public OtpPeer peer() {
        return this.peer;
    }

    public OtpSelf self() {
        return this.self;
    }

    public int msgCount() {
        return this.queue.getCount();
    }

    public OtpErlangObject receive() throws IOException, OtpErlangExit, OtpAuthException {
        try {
            return this.receiveMsg().getMsg();
        }
        catch (OtpErlangDecodeException otpErlangDecodeException) {
            this.close();
            throw new IOException(otpErlangDecodeException.getMessage());
        }
    }

    public OtpErlangObject receive(long l) throws InterruptedException, IOException, OtpErlangExit, OtpAuthException {
        try {
            return this.receiveMsg(l).getMsg();
        }
        catch (OtpErlangDecodeException otpErlangDecodeException) {
            this.close();
            throw new IOException(otpErlangDecodeException.getMessage());
        }
    }

    public OtpInputStream receiveBuf() throws IOException, OtpErlangExit, OtpAuthException {
        return this.receiveMsg().getMsgBuf();
    }

    public OtpInputStream receiveBuf(long l) throws InterruptedException, IOException, OtpErlangExit, OtpAuthException {
        return this.receiveMsg(l).getMsgBuf();
    }

    public OtpMsg receiveMsg() throws IOException, OtpErlangExit, OtpAuthException {
        Object object = this.queue.get();
        if (object instanceof OtpMsg) {
            return (OtpMsg)object;
        }
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        if (object instanceof OtpErlangExit) {
            throw (OtpErlangExit)object;
        }
        if (object instanceof OtpAuthException) {
            throw (OtpAuthException)object;
        }
        return null;
    }

    public OtpMsg receiveMsg(long l) throws InterruptedException, IOException, OtpErlangExit, OtpAuthException {
        Object object = this.queue.get(l);
        if (object instanceof OtpMsg) {
            return (OtpMsg)object;
        }
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        if (object instanceof OtpErlangExit) {
            throw (OtpErlangExit)object;
        }
        if (object instanceof OtpAuthException) {
            throw (OtpAuthException)object;
        }
        return null;
    }

    public void send(OtpErlangPid otpErlangPid, OtpErlangObject otpErlangObject) throws IOException {
        super.sendBuf(this.self.pid(), otpErlangPid, new OtpOutputStream(otpErlangObject));
    }

    public void send(String string, OtpErlangObject otpErlangObject) throws IOException {
        super.sendBuf(this.self.pid(), string, new OtpOutputStream(otpErlangObject));
    }

    public void sendBuf(String string, OtpOutputStream otpOutputStream) throws IOException {
        super.sendBuf(this.self.pid(), string, otpOutputStream);
    }

    public void sendBuf(OtpErlangPid otpErlangPid, OtpOutputStream otpOutputStream) throws IOException {
        super.sendBuf(this.self.pid(), otpErlangPid, otpOutputStream);
    }

    public void sendRPC(String string, String string2, OtpErlangObject[] otpErlangObjectArray) throws IOException {
        this.sendRPC(string, string2, new OtpErlangList(otpErlangObjectArray));
    }

    public void sendRPC(String string, String string2, OtpErlangList otpErlangList) throws IOException {
        OtpErlangObject[] otpErlangObjectArray = new OtpErlangObject[2];
        OtpErlangObject[] otpErlangObjectArray2 = new OtpErlangObject[]{new OtpErlangAtom("call"), new OtpErlangAtom(string), new OtpErlangAtom(string2), otpErlangList, new OtpErlangAtom("user")};
        otpErlangObjectArray[0] = this.self.pid();
        otpErlangObjectArray[1] = new OtpErlangTuple(otpErlangObjectArray2);
        this.send("rex", (OtpErlangObject)new OtpErlangTuple(otpErlangObjectArray));
    }

    public OtpErlangObject receiveRPC() throws IOException, OtpErlangExit, OtpAuthException {
        OtpErlangTuple otpErlangTuple;
        OtpErlangObject otpErlangObject = this.receive();
        if (otpErlangObject instanceof OtpErlangTuple && (otpErlangTuple = (OtpErlangTuple)otpErlangObject).arity() == 2) {
            return otpErlangTuple.elementAt(1);
        }
        return null;
    }

    public void link(OtpErlangPid otpErlangPid) throws IOException {
        if (this.links.addLink(this.self.pid(), otpErlangPid, true)) {
            try {
                super.sendLink(this.self.pid(), otpErlangPid);
            }
            catch (IOException iOException) {
                this.links.removeLink(this.self.pid(), otpErlangPid);
                throw iOException;
            }
        }
    }

    public void unlink(OtpErlangPid otpErlangPid) throws IOException {
        long l;
        if ((l = this.unlink_id++) == 0L) {
            l = this.unlink_id++;
        }
        if (this.links.setUnlinking(this.self.pid(), otpErlangPid, l)) {
            try {
                super.sendUnlink(this.self.pid(), otpErlangPid, l);
            }
            catch (IOException iOException) {
                this.links.addLink(this.self.pid(), otpErlangPid, true);
                throw iOException;
            }
        }
    }

    public void exit(OtpErlangPid otpErlangPid, OtpErlangObject otpErlangObject) throws IOException {
        super.sendExit2(this.self.pid(), otpErlangPid, otpErlangObject);
    }
}

