/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.option.AudioMixerOption;

public final class AudioMixerOptionUI
extends OptionUI<AudioMixerOption> {
    private final GUI gui;
    private final JPanel panel = new JPanel();
    private final JComboBox<AudioMixerOption.MixerWrapper> cbox;
    private final JButton button1;
    private final JButton button2;
    private final JLabel currentMixerLabel;

    public AudioMixerOptionUI(GUI gui, AudioMixerOption option, boolean editable) {
        super(option, editable);
        this.gui = gui;
        BorderLayout layout = new BorderLayout();
        layout.setHgap(15);
        this.panel.setLayout(layout);
        this.cbox = new JComboBox();
        this.panel.add(this.cbox, "West");
        this.currentMixerLabel = new JLabel();
        this.panel.add((Component)this.currentMixerLabel, "East");
        this.updateMixerLabel();
        this.button1 = Utility.localizedButton("test");
        this.panel.add(this.button1);
        this.button2 = Utility.localizedButton("music");
        this.panel.add(this.button2);
        this.cbox.add(super.getJLabel());
        this.cbox.setModel(new DefaultComboBoxModel<AudioMixerOption.MixerWrapper>(((AudioMixerOption)this.getOption()).getChoices().toArray(new AudioMixerOption.MixerWrapper[0])));
        this.reset();
        this.cbox.setEnabled(editable);
        ActionListener aHandler = ae -> {
            if (ae.getSource() == this.button1) {
                gui.playSound("sound.event.buildingComplete");
            } else if (ae.getSource() == this.button2) {
                gui.playSound("sound.intro.general");
            } else if (ae.getSource() == this.cbox) {
                AudioMixerOption.MixerWrapper value = (AudioMixerOption.MixerWrapper)this.cbox.getSelectedItem();
                if (((AudioMixerOption)this.getOption()).getValue() != value) {
                    ((AudioMixerOption)this.getOption()).setValue(value);
                    this.updateMixerLabel();
                }
            }
        };
        this.button1.addActionListener(aHandler);
        this.button2.addActionListener(aHandler);
        this.cbox.addActionListener(aHandler);
        this.initialize();
    }

    private void updateMixerLabel() {
        this.currentMixerLabel.setText(this.gui.getSoundMixerLabelText());
    }

    @Override
    public final JLabel getJLabel() {
        return null;
    }

    @Override
    public JPanel getComponent() {
        return this.panel;
    }

    @Override
    public void updateOption() {
        ((AudioMixerOption)this.getOption()).setValue((AudioMixerOption.MixerWrapper)this.cbox.getSelectedItem());
    }

    @Override
    public void reset() {
        this.cbox.setSelectedItem(((AudioMixerOption)this.getOption()).getValue());
    }
}

