/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file.spreadsheet.process;

import java.util.ArrayList;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.plugin.file.spreadsheet.process.AbstractImportProcess;
import org.gephi.io.importer.plugin.file.spreadsheet.process.SpreadsheetGeneralConfiguration;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetParser;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetRow;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;

public class ImportMatrixProcess
extends AbstractImportProcess {
    public ImportMatrixProcess(SpreadsheetGeneralConfiguration generalConfig, ContainerLoader container, ProgressTicket progressTicket, SheetParser parser) {
        super(generalConfig, container, progressTicket, parser);
    }

    @Override
    public boolean execute() {
        this.container.setFillLabelWithId(true);
        Progress.start((ProgressTicket)this.progressTicket);
        ArrayList<String> targetLabels = new ArrayList<String>();
        ArrayList<String> sourceLabels = new ArrayList<String>();
        boolean firstRow = true;
        int rowCount = 0;
        for (SheetRow row : this.parser) {
            if (firstRow) {
                for (int i = 1; i < row.size(); ++i) {
                    String label = row.get(i);
                    targetLabels.add(label);
                    if (label != null) continue;
                    this.logError(this.getMessage("ImportMatrixProcess.error.missingTarget", i));
                }
                firstRow = false;
                continue;
            }
            if (row.size() > 0) {
                String source = row.get(0);
                sourceLabels.add(source);
                if (source != null) {
                    for (int i = 1; i < row.size(); ++i) {
                        int labelIndex = i - 1;
                        if (labelIndex < targetLabels.size()) {
                            String value = row.get(i);
                            String target = (String)targetLabels.get(labelIndex);
                            if (target == null) continue;
                            try {
                                float weight;
                                if (value == null || value.trim().equals("0") || (weight = Float.parseFloat(value.replace(',', '.'))) == 0.0f) continue;
                                this.addEdge(source.trim(), target.trim(), weight);
                            }
                            catch (NumberFormatException ex) {
                                this.logError(this.getMessage("ImportMatrixProcess.error.parseWeightError", value));
                            }
                            continue;
                        }
                        this.logError(this.getMessage("ImportMatrixProcess.error.invalidRowLength", row.size() - 1, targetLabels.size()));
                        break;
                    }
                } else {
                    this.logError(this.getMessage("ImportMatrixProcess.error.missingSource"));
                }
            }
            ++rowCount;
        }
        if (rowCount != targetLabels.size()) {
            this.logWarning(this.getMessage("ImportMatrixProcess.warning.inconsistentNumberOfLines", rowCount, targetLabels.size()));
        } else if (!sourceLabels.equals(targetLabels)) {
            this.logWarning(this.getMessage("ImportMatrixProcess.warning.inconsistentLabels"));
        }
        Progress.finish((ProgressTicket)this.progressTicket);
        return !this.cancel;
    }

    @Override
    protected void addColumn(String name, Class type) {
    }
}

