/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.srtm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Track;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.srtm.SrtmTile;
import tim.prune.function.srtm.TileDownloader;
import tim.prune.function.srtm.TileFinder;
import tim.prune.gui.ProgressDialog;
import tim.prune.undo.UndoLookupSrtm;

public class LookupSrtmFunction
extends GenericFunction
implements Runnable {
    private ProgressDialog _progress = null;
    private Track _track = null;
    private boolean _normalTrack = true;
    private boolean _hadToDownload = false;
    private int _numCached = 0;
    private boolean _running = false;
    private static final long HGT_SIZE = 2884802L;
    private static final int VOID_VAL = Short.MIN_VALUE;

    public LookupSrtmFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.lookupsrtm";
    }

    @Override
    public void begin() {
        this.begin(this._app.getTrackInfo().getTrack(), true);
    }

    public void begin(Track track) {
        this.begin(track, false);
    }

    private void begin(Track track, boolean bl) {
        this._running = true;
        this._hadToDownload = false;
        if (this._progress == null) {
            this._progress = new ProgressDialog(this._parentFrame, this.getNameKey());
        }
        this._progress.show();
        this._track = track;
        this._normalTrack = bl;
        new Thread(this).start();
    }

    @Override
    public void run() {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < this._track.getNumPoints()) {
            if (this._track.getPoint(n).hasAltitude()) {
                if (this._track.getPoint(n).getAltitude().getValue() == 0) {
                    bl = true;
                } else {
                    bl2 = true;
                }
            }
            n += 1;
        }
        int n2 = n = bl && !bl2 ? 1 : 0;
        if (bl2 && bl && JOptionPane.showConfirmDialog(this._parentFrame, I18nManager.getText("dialog.lookupsrtm.overwritezeros"), I18nManager.getText(this.getNameKey()), 0) == 0) {
            n = 1;
        }
        HashSet<SrtmTile> hashSet = new HashSet<SrtmTile>();
        int n3 = 0;
        while (n3 < this._track.getNumPoints()) {
            if (!this._track.getPoint(n3).hasAltitude() || n && this._track.getPoint(n3).getAltitude().getValue() == 0) {
                hashSet.add(new SrtmTile(this._track.getPoint(n3)));
            }
            ++n3;
        }
        this.lookupValues(hashSet, n != 0);
        this._running = false;
        if (this._hadToDownload) {
            this._app.showTip(2);
        } else if (this._numCached > 0) {
            this.showConfirmMessage(this._numCached);
        }
    }

    private void lookupValues(HashSet<SrtmTile> hashSet, boolean bl) {
        UndoLookupSrtm undoLookupSrtm = new UndoLookupSrtm(this._app.getTrackInfo());
        int n = 0;
        TileFinder tileFinder = new TileFinder();
        String string = null;
        int n2 = hashSet.size();
        if (this._progress != null) {
            this._progress.setMaximum(n2);
            this._progress.setValue(0);
        }
        int n3 = 0;
        this._numCached = 0;
        for (SrtmTile srtmTile : hashSet) {
            URL uRL = tileFinder.getUrl(srtmTile);
            if (uRL == null) continue;
            try {
                this._progress.setValue(n3++);
                int[] nArray = new int[1442401];
                ZipInputStream zipInputStream = this.getStreamToSrtmData(uRL);
                boolean bl2 = false;
                if (zipInputStream != null) {
                    ZipEntry zipEntry = zipInputStream.getNextEntry();
                    boolean bl3 = bl2 = zipEntry != null && zipEntry.getSize() == 2884802L;
                    if (bl2) {
                        int n4 = 0;
                        while (n4 < 1442401) {
                            nArray[n4] = zipInputStream.read() * 256 + zipInputStream.read();
                            if (nArray[n4] >= 32768) {
                                int n5 = n4;
                                nArray[n5] = nArray[n5] - 65536;
                            }
                            ++n4;
                        }
                    }
                    zipInputStream.close();
                }
                if (!bl2) continue;
                n += this.applySrtmTileToWholeTrack(srtmTile, nArray, bl);
            }
            catch (IOException iOException) {
                string = String.valueOf(iOException.getClass().getName()) + " - " + iOException.getMessage();
            }
        }
        this._progress.dispose();
        if (this._progress.isCancelled()) {
            return;
        }
        if (n > 0) {
            this._track.requestRescale();
            UpdateMessageBroker.informSubscribers((byte)1);
            if (this._normalTrack) {
                this._app.completeFunction(undoLookupSrtm, I18nManager.getTextWithNumber("confirm.lookupsrtm", n));
            }
        } else if (string != null) {
            this._app.showErrorMessageNoLookup(this.getNameKey(), string);
        } else if (n2 > 0) {
            this._app.showErrorMessage(this.getNameKey(), "error.lookupsrtm.nonefound");
        } else {
            this._app.showErrorMessage(this.getNameKey(), "error.lookupsrtm.nonerequired");
        }
    }

    private ZipInputStream getStreamToSrtmData(URL uRL) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = this.getStreamToLocalHgtFile(uRL);
        }
        catch (IOException iOException) {
            zipInputStream = null;
        }
        if (zipInputStream != null) {
            return zipInputStream;
        }
        TileDownloader tileDownloader = new TileDownloader();
        TileDownloader.Result result = tileDownloader.downloadTile(uRL);
        System.out.println("Result: " + (Object)((Object)result));
        if (result == TileDownloader.Result.DOWNLOADED) {
            ++this._numCached;
            return this.getStreamToLocalHgtFile(uRL);
        }
        if (result != TileDownloader.Result.DOWNLOAD_FAILED) {
            this._hadToDownload = true;
            return new ZipInputStream(uRL.openStream());
        }
        return null;
    }

    private ZipInputStream getStreamToLocalHgtFile(URL uRL) throws IOException {
        File file;
        File file2;
        String string = Config.getConfigString("prune.diskcache");
        if (string != null && (file2 = new File(string, "srtm")).exists() && file2.isDirectory() && file2.canRead() && (file = new File(file2, new File(uRL.getFile()).getName())).exists() && file.isFile() && file.canRead() && file.length() > 400L) {
            return new ZipInputStream(new FileInputStream(file));
        }
        return null;
    }

    private int applySrtmTileToWholeTrack(SrtmTile srtmTile, int[] nArray, boolean bl) {
        int n = 0;
        int n2 = 0;
        while (n2 < this._track.getNumPoints()) {
            DataPoint dataPoint = this._track.getPoint(n2);
            if ((!dataPoint.hasAltitude() || bl && dataPoint.getAltitude().getValue() == 0) && new SrtmTile(dataPoint).equals(srtmTile)) {
                double d = (dataPoint.getLongitude().getDouble() - (double)srtmTile.getLongitude()) * 1200.0;
                double d2 = 1201.0 - (dataPoint.getLatitude().getDouble() - (double)srtmTile.getLatitude()) * 1200.0;
                int n3 = (int)d2 * 1201 + (int)d;
                try {
                    int[] nArray2 = new int[]{nArray[n3], nArray[n3 + 1], nArray[n3 - 1201], nArray[n3 - 1200]};
                    int n4 = (nArray2[0] == Short.MIN_VALUE ? 1 : 0) + (nArray2[1] == Short.MIN_VALUE ? 1 : 0) + (nArray2[2] == Short.MIN_VALUE ? 1 : 0) + (nArray2[3] == Short.MIN_VALUE ? 1 : 0);
                    double d3 = 0.0;
                    switch (n4) {
                        case 0: {
                            d3 = LookupSrtmFunction.bilinearInterpolate(nArray2, d, d2);
                            break;
                        }
                        case 1: {
                            d3 = LookupSrtmFunction.bilinearInterpolate(LookupSrtmFunction.fixVoid(nArray2), d, d2);
                            break;
                        }
                        case 2: 
                        case 3: {
                            d3 = LookupSrtmFunction.averageNonVoid(nArray2);
                            break;
                        }
                        default: {
                            d3 = -32768.0;
                        }
                    }
                    if (!this._normalTrack && n4 > 0) {
                        d3 = -32768.0;
                    }
                    if (d3 != -32768.0) {
                        dataPoint.setFieldValue(Field.ALTITUDE, "" + d3, false);
                        dataPoint.getAltitude().reset(new Altitude((int)d3, UnitSetLibrary.UNITS_METRES));
                        ++n;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
            ++n2;
        }
        return n;
    }

    private static double bilinearInterpolate(int[] nArray, double d, double d2) {
        double d3 = d - (double)((int)d);
        double d4 = 1.0 - (d2 - (double)((int)d2));
        double d5 = (1.0 - d3) * (1.0 - d4) * (double)nArray[0] + d3 * (1.0 - d4) * (double)nArray[1] + (1.0 - d3) * d4 * (double)nArray[2] + d3 * d4 * (double)nArray[3];
        return d5;
    }

    private static int[] fixVoid(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = nArray[n] == Short.MIN_VALUE ? (int)Math.round(LookupSrtmFunction.averageNonVoid(nArray)) : nArray[n];
            ++n;
        }
        return nArray2;
    }

    private static final double averageNonVoid(int[] nArray) {
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] != Short.MIN_VALUE) {
                d += (double)nArray[n2];
                ++n;
            }
            ++n2;
        }
        if (n < 1) {
            return -32768.0;
        }
        return d / (double)n;
    }

    public boolean isRunning() {
        return this._running;
    }

    private void showConfirmMessage(int n) {
        if (n == 1) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getTextWithNumber("confirm.downloadsrtm.1", n), I18nManager.getText(this.getNameKey()), 1);
        } else if (n > 1) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getTextWithNumber("confirm.downloadsrtm", n), I18nManager.getText(this.getNameKey()), 1);
        }
    }
}

