/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import tim.prune.data.AudioClip;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.load.AudioFileFilter;
import tim.prune.load.ByteScooper;
import tim.prune.load.GenericFileFilter;
import tim.prune.load.JpegFileFilter;
import tim.prune.load.JpegLoader;

public abstract class MediaHelper {
    private static GenericFileFilter _jpegFilter = null;
    private static GenericFileFilter _audioFilter = null;

    public static MediaObject createMediaObject(File file, String string, File file2) {
        Object object;
        if (string == null || string.length() < 5) {
            return null;
        }
        InputStream inputStream = null;
        ZipFile zipFile = null;
        byte[] byArray = null;
        String string2 = null;
        try {
            if (string.substring(0, 5).toLowerCase().equals("http:")) {
                string2 = string;
                inputStream = new URL(string).openStream();
                byArray = ByteScooper.scoop(inputStream);
            }
        }
        catch (IOException iOException) {
            System.err.println("Got ioe from url: " + iOException.getMessage());
        }
        if (inputStream == null && file != null && file.exists() && file.canRead()) {
            try {
                zipFile = new ZipFile(file);
                object = zipFile.getEntry(string);
                if (object != null && ((ZipEntry)object).getSize() > 0L) {
                    byArray = ByteScooper.scoop(zipFile.getInputStream((ZipEntry)object));
                }
            }
            catch (IOException iOException) {
                System.err.println("Got ioe from zip file: " + iOException.getMessage());
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        if (byArray != null) {
            object = new File(string).getName();
            MediaHelper.initFilters();
            if (_jpegFilter.acceptFilename(string)) {
                return new Photo(byArray, (String)object, string2);
            }
            if (_audioFilter.acceptFilename(string)) {
                return new AudioClip(byArray, (String)object, string2);
            }
            return null;
        }
        object = new File(string);
        if (file2 != null && !((File)object).isAbsolute()) {
            object = new File(file2.getParent(), string);
        }
        return MediaHelper.createMediaObject((File)object);
    }

    private static MediaObject createMediaObject(File file) {
        if (file == null) {
            return null;
        }
        if (!(file.exists() && file.canRead() && file.isFile())) {
            return null;
        }
        MediaHelper.initFilters();
        if (_jpegFilter.acceptFilename(file.getName())) {
            return JpegLoader.createPhoto(file);
        }
        if (_audioFilter.acceptFilename(file.getName())) {
            return new AudioClip(file);
        }
        return null;
    }

    private static void initFilters() {
        if (_jpegFilter == null) {
            _jpegFilter = new JpegFileFilter();
            _audioFilter = new AudioFileFilter();
        }
    }
}

