/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoOperation;

public class UndoInsert
implements UndoOperation {
    private int _startPosition = 0;
    private int _numInserted = 0;
    private boolean _hasSegmentFlag = false;
    private boolean _segmentFlag = false;

    public UndoInsert(int n, int n2) {
        this(n, n2, false, false);
    }

    public UndoInsert(int n, int n2, boolean bl) {
        this(n, n2, true, bl);
    }

    public UndoInsert(int n, int n2, boolean bl, boolean bl2) {
        this._startPosition = n;
        this._numInserted = n2;
        this._hasSegmentFlag = bl;
        this._segmentFlag = bl2;
    }

    @Override
    public String getDescription() {
        return String.valueOf(I18nManager.getText("undo.insert")) + " (" + this._numInserted + ")";
    }

    @Override
    public void performUndo(TrackInfo trackInfo) throws UndoException {
        DataPoint dataPoint;
        trackInfo.getTrack().deleteRange(this._startPosition, this._startPosition + this._numInserted - 1);
        if (this._hasSegmentFlag && (dataPoint = trackInfo.getTrack().getNextTrackPoint(this._startPosition)) != null) {
            dataPoint.setSegmentStart(this._segmentFlag);
        }
        trackInfo.getSelection().clearAll();
    }
}

