/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.TranslateTransition;
import javafx.beans.property.DoubleProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.SizeConverter;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.controlsfx.control.ToggleSwitch;

public class ToggleSwitchSkin
extends SkinBase<ToggleSwitch> {
    private final StackPane thumb = new StackPane();
    private final StackPane thumbArea = new StackPane();
    private final Label label = new Label();
    private final StackPane labelContainer = new StackPane();
    private final TranslateTransition transition = new TranslateTransition(Duration.millis(this.getThumbMoveAnimationTime()), this.thumb);
    private DoubleProperty thumbMoveAnimationTime = null;
    private static final CssMetaData<ToggleSwitch, Number> THUMB_MOVE_ANIMATION_TIME = new CssMetaData<ToggleSwitch, Number>("-thumb-move-animation-time", SizeConverter.getInstance(), (Number)200){

        @Override
        public boolean isSettable(ToggleSwitch toggleSwitch) {
            ToggleSwitchSkin skin = (ToggleSwitchSkin)toggleSwitch.getSkin();
            return skin.thumbMoveAnimationTime == null || !skin.thumbMoveAnimationTime.isBound();
        }

        @Override
        public StyleableProperty<Number> getStyleableProperty(ToggleSwitch toggleSwitch) {
            ToggleSwitchSkin skin = (ToggleSwitchSkin)toggleSwitch.getSkin();
            return (StyleableProperty)((Object)skin.thumbMoveAnimationTimeProperty());
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public ToggleSwitchSkin(ToggleSwitch control) {
        super(control);
        this.transition.setFromX(0.0);
        this.label.textProperty().bind(control.textProperty());
        this.getChildren().addAll((Node[])new Node[]{this.labelContainer, this.thumbArea, this.thumb});
        this.labelContainer.getChildren().addAll((Node[])new Node[]{this.label});
        StackPane.setAlignment(this.label, Pos.CENTER_LEFT);
        this.thumb.getStyleClass().setAll((String[])new String[]{"thumb"});
        this.thumbArea.getStyleClass().setAll((String[])new String[]{"thumb-area"});
        this.thumbArea.setOnMouseReleased(event -> this.mousePressedOnToggleSwitch(control));
        this.thumb.setOnMouseReleased(event -> this.mousePressedOnToggleSwitch(control));
        control.selectedProperty().addListener((observable2, oldValue, newValue) -> {
            if (newValue.booleanValue() != oldValue.booleanValue()) {
                this.selectedStateChanged();
            }
        });
    }

    private void selectedStateChanged() {
        this.transition.stop();
        if (((ToggleSwitch)this.getSkinnable()).isSelected()) {
            this.transition.setRate(1.0);
            this.transition.jumpTo(Duration.ZERO);
        } else {
            this.transition.setRate(-1.0);
            this.transition.jumpTo(this.transition.getDuration());
        }
        this.transition.play();
    }

    private void mousePressedOnToggleSwitch(ToggleSwitch toggleSwitch) {
        toggleSwitch.setSelected(!toggleSwitch.isSelected());
    }

    private DoubleProperty thumbMoveAnimationTimeProperty() {
        if (this.thumbMoveAnimationTime == null) {
            this.thumbMoveAnimationTime = new StyleableDoubleProperty(200.0){

                @Override
                public Object getBean() {
                    return ToggleSwitchSkin.this;
                }

                @Override
                public String getName() {
                    return "thumbMoveAnimationTime";
                }

                @Override
                public CssMetaData<ToggleSwitch, Number> getCssMetaData() {
                    return THUMB_MOVE_ANIMATION_TIME;
                }
            };
        }
        return this.thumbMoveAnimationTime;
    }

    private double getThumbMoveAnimationTime() {
        return this.thumbMoveAnimationTime == null ? 200.0 : this.thumbMoveAnimationTime.get();
    }

    @Override
    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        ToggleSwitch toggleSwitch = (ToggleSwitch)this.getSkinnable();
        double thumbWidth = this.snapSize(this.thumb.prefWidth(-1.0));
        double thumbHeight = this.snapSize(this.thumb.prefHeight(-1.0));
        this.thumb.resize(thumbWidth, thumbHeight);
        double thumbAreaY = this.snapPosition(contentY);
        double thumbAreaWidth = this.snapSize(this.thumbArea.prefWidth(-1.0));
        double thumbAreaHeight = this.snapSize(this.thumbArea.prefHeight(-1.0));
        this.thumbArea.resize(thumbAreaWidth, thumbAreaHeight);
        this.thumbArea.setLayoutX(contentWidth - thumbAreaWidth);
        this.thumbArea.setLayoutY(thumbAreaY);
        this.labelContainer.resize(contentWidth - thumbAreaWidth, thumbAreaHeight);
        this.labelContainer.setLayoutY(thumbAreaY);
        this.thumb.setLayoutX(this.thumbArea.getLayoutX());
        this.thumb.setLayoutY(thumbAreaY + (thumbAreaHeight - thumbHeight) / 2.0);
        double thumbTarget = thumbAreaWidth - thumbWidth;
        this.transition.setToX(thumbTarget);
        if (this.transition.getStatus() == Animation.Status.RUNNING) {
            Duration currentTime = this.transition.getCurrentTime();
            this.transition.stop();
            this.transition.playFrom(currentTime);
        } else {
            this.thumb.setTranslateX(toggleSwitch.isSelected() ? thumbTarget : 0.0);
        }
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.label.prefWidth(-1.0) + this.thumbArea.prefWidth(-1.0) + rightInset;
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + Math.max(this.thumb.prefHeight(-1.0), this.label.prefHeight(-1.0)) + bottomInset;
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.label.prefWidth(-1.0) + 20.0 + this.thumbArea.prefWidth(-1.0) + rightInset;
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + Math.max(this.thumb.prefHeight(-1.0), this.label.prefHeight(-1.0)) + bottomInset;
    }

    @Override
    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ToggleSwitch)this.getSkinnable()).prefWidth(height);
    }

    @Override
    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ToggleSwitch)this.getSkinnable()).prefHeight(width);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ToggleSwitchSkin.getClassCssMetaData();
    }

    static {
        ArrayList styleables = new ArrayList(SkinBase.getClassCssMetaData());
        styleables.add(THUMB_MOVE_ANIMATION_TIME);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }
}

