/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.beans;

import java.util.regex.Pattern;
import org.apache.mina.integration.beans.AbstractPropertyEditor;

public class BooleanEditor
extends AbstractPropertyEditor {
    private static final Pattern TRUE = Pattern.compile("(?:true|t|yes|y|1)", 2);
    private static final Pattern FALSE = Pattern.compile("(?:false|f|no|n|1)", 2);

    @Override
    protected String toText(Object value) {
        return String.valueOf(value);
    }

    @Override
    protected Object toValue(String text) throws IllegalArgumentException {
        if (TRUE.matcher(text).matches()) {
            return Boolean.TRUE;
        }
        if (FALSE.matcher(text).matches()) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Wrong boolean value: " + text);
    }
}

