/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom.kinetic;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.geom.kinetic.MoveObserver;
import net.sourceforge.plantuml.geom.kinetic.VectorForce;

public class Point2DCharge
extends Point2D.Double {
    private double charge = 1.0;
    private MoveObserver moveObserver = null;
    private final int hash = System.identityHashCode(this);

    public Point2DCharge(double x, double y) {
        super(x, y);
    }

    public Point2DCharge(Point2D pt, double ch) {
        super(pt.getX(), pt.getY());
        this.charge = ch;
    }

    public void apply(VectorForce value) {
        Log.println("Applying " + value);
        this.x += value.getX();
        this.y += value.getY();
        if (this.moveObserver != null) {
            this.moveObserver.pointMoved(this);
        }
    }

    @Override
    public final void setLocation(double x, double y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void setLocation(Point2D p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return System.identityHashCode(this) + " " + String.format("[%8.2f %8.2f]", this.x, this.y);
    }

    public final double getCharge() {
        return this.charge;
    }

    public final void setCharge(double charge) {
        this.charge = charge;
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    public final void setMoveObserver(MoveObserver moveObserver) {
        this.moveObserver = moveObserver;
    }
}

