/*
 * Decompiled with CFR 0.152.
 */
package org.coode.mdock;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.coode.mdock.ComponentNode;
import org.coode.mdock.Node;
import org.coode.mdock.NodePanel;
import org.coode.mdock.SplitterNode;
import org.coode.mdock.Util;

public class DynamicConfigPanel
extends JPanel {
    private JComponent component;
    private NodePanel nodePanel;
    private JComponent currentComponent;
    private String currentLabel;
    private Color lineColor = new Color(139, 178, 212);

    public DynamicConfigPanel(JComponent component) {
        this.component = component;
        this.nodePanel = null;
        this.setOpaque(false);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                DynamicConfigPanel.this.updateNodePanel();
                DynamicConfigPanel.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DynamicConfigPanel.this.handleMouseClicked(e);
            }
        });
    }

    private void handleMouseClicked(MouseEvent e) {
        if (this.nodePanel == null) {
            return;
        }
        this.setVisible(false);
        Point nodePanelPt = SwingUtilities.convertPoint(this, e.getPoint(), this.nodePanel);
        Node n = Util.getDeepestNode(this.nodePanel.getRootNode(), this.nodePanel, nodePanelPt);
        if (n == null) {
            return;
        }
        AddMode mode = this.getAddMode(n, nodePanelPt);
        mode.doAdd(this.currentComponent, this.currentLabel);
        this.currentComponent = null;
        this.nodePanel.rebuild();
    }

    public void setCurrentComponent(JComponent currentComponent, String label) {
        this.currentComponent = currentComponent;
        this.currentLabel = label;
    }

    private void updateNodePanel() {
        Container contentPane = this.getRootPane().getContentPane();
        Point pt = this.getMousePosition();
        if (pt == null) {
            return;
        }
        pt = SwingUtilities.convertPoint(this, pt, contentPane);
        Component c = SwingUtilities.getDeepestComponentAt(contentPane, pt.x, pt.y);
        if (c instanceof NodePanel) {
            this.nodePanel = (NodePanel)c;
            return;
        }
        NodePanel np = (NodePanel)SwingUtilities.getAncestorOfClass(NodePanel.class, c);
        if (np != null) {
            this.nodePanel = np;
        }
    }

    public void activate() {
        if (this.currentComponent == null) {
            throw new IllegalStateException("No component is set!");
        }
        if (this.currentComponent.getParent() != null) {
            throw new IllegalStateException("Current component already has a parent!");
        }
        this.component.getRootPane().setGlassPane(this);
        this.setVisible(true);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Point mousePos;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Point pt = this.getMousePosition();
        if (pt != null) {
            g2.fillOval(pt.x - 4, pt.y - 4, 8, 8);
            g2.drawOval(pt.x - 6, pt.y - 6, 12, 12);
        }
        if ((mousePos = this.getMousePosition()) != null && this.nodePanel != null) {
            mousePos = SwingUtilities.convertPoint(this, mousePos, this.nodePanel);
            Node n = Util.getDeepestNode(this.nodePanel.getRootNode(), this.nodePanel, mousePos);
            if (n != null) {
                AddMode addMode = this.getAddMode(n, mousePos);
                addMode.paintRect(g);
            }
        }
    }

    private AddMode getAddMode(Node node, Point mousePoint) {
        if (node.getParent() == null) {
            return new CentreAddMode(node);
        }
        Rectangle bounds = Util.getBounds(node, this.nodePanel, false);
        bounds.grow(-6, -6);
        int xMargin = (int)((double)bounds.width * 0.3);
        int yMargin = (int)((double)bounds.height * 0.3);
        if (mousePoint.y < bounds.y + yMargin) {
            return new TopAddMode(node);
        }
        if (mousePoint.y > bounds.y + bounds.height - yMargin) {
            return new BottomAddMode(node);
        }
        if (mousePoint.x < bounds.x + xMargin) {
            return new LeftAddMode(node);
        }
        if (mousePoint.x > bounds.x + bounds.width - xMargin) {
            return new RightAddMode(node);
        }
        return new CentreAddMode(node);
    }

    private class CentreAddMode
    extends AddMode {
        public CentreAddMode(Node node) {
            super(node);
        }

        @Override
        public void doAdd(JComponent component, String label) {
            if (this.getNode() instanceof ComponentNode) {
                ((ComponentNode)this.getNode()).add(component, label);
            } else {
                ComponentNode cn = new ComponentNode();
                cn.add(component, label);
                ((SplitterNode)this.getNode()).addChild(cn, 0, 1.0);
            }
            Util.bringToFront(component);
        }

        @Override
        public Rectangle getRect() {
            return this.getInnerBounds();
        }
    }

    private class RightAddMode
    extends AddMode {
        public RightAddMode(Node node) {
            super(node);
        }

        @Override
        public void doAdd(JComponent component, String label) {
            SplitterNode parentNode = this.getNode().getParent();
            ComponentNode cn = new ComponentNode();
            cn.add(component, label);
            parentNode.insertNodeAfter((Node)cn, this.getNode(), 1);
        }

        @Override
        public Rectangle getRect() {
            Rectangle rect = this.getInnerBounds();
            rect.width /= 2;
            rect.x += rect.width;
            return rect;
        }
    }

    private class LeftAddMode
    extends AddMode {
        public LeftAddMode(Node node) {
            super(node);
        }

        @Override
        public Rectangle getRect() {
            Rectangle rect = this.getInnerBounds();
            rect.width /= 2;
            return rect;
        }

        @Override
        public void doAdd(JComponent component, String label) {
            ComponentNode cn = new ComponentNode();
            cn.add(component, label);
            SplitterNode parentNode = this.getNode().getParent();
            parentNode.insertNodeBefore(cn, this.getNode(), 1);
        }
    }

    private class BottomAddMode
    extends AddMode {
        public BottomAddMode(Node node) {
            super(node);
        }

        @Override
        public Rectangle getRect() {
            Rectangle rect = this.getInnerBounds();
            rect.height /= 2;
            rect.y += rect.height;
            return rect;
        }

        @Override
        public void doAdd(JComponent component, String label) {
            SplitterNode parentNode = this.getNode().getParent();
            ComponentNode cn = new ComponentNode();
            cn.add(component, label);
            parentNode.insertNodeAfter((Node)cn, this.getNode(), 0);
        }
    }

    private class TopAddMode
    extends AddMode {
        public TopAddMode(Node node) {
            super(node);
        }

        @Override
        public void doAdd(JComponent component, String label) {
            SplitterNode parentNode = this.getNode().getParent();
            ComponentNode cn = new ComponentNode();
            cn.add(component, label);
            parentNode.insertNodeBefore(cn, this.getNode(), 0);
        }

        @Override
        public Rectangle getRect() {
            Rectangle rect = this.getInnerBounds();
            rect.height /= 2;
            return rect;
        }
    }

    private abstract class AddMode {
        public final Stroke stroke = new BasicStroke(4.0f, 1, 1);
        public final Stroke thinStroke = new BasicStroke(2.0f, 1, 1);
        public static final int ARROW_DIM = 20;
        private Node node;
        private Rectangle bounds;

        public AddMode(Node node) {
            this.node = node;
            this.bounds = Util.getBounds(node, DynamicConfigPanel.this.nodePanel, false);
            this.bounds = SwingUtilities.convertRectangle(DynamicConfigPanel.this.nodePanel, this.bounds, DynamicConfigPanel.this);
        }

        protected Node getNode() {
            return this.node;
        }

        public abstract void doAdd(JComponent var1, String var2);

        public abstract Rectangle getRect();

        public Rectangle getBounds() {
            return this.bounds;
        }

        public Rectangle getInnerBounds() {
            Rectangle smallBounds = new Rectangle(this.bounds);
            smallBounds.grow(-6, -6);
            return smallBounds;
        }

        public void paintRect(Graphics g) {
            Stroke oldStroke = ((Graphics2D)g).getStroke();
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(this.stroke);
            Color oldColor = g.getColor();
            g.setColor(DynamicConfigPanel.this.lineColor);
            Rectangle smallBounds = this.getInnerBounds();
            g.drawRect(smallBounds.x, smallBounds.y, smallBounds.width, smallBounds.height);
            Rectangle posRect = this.getRect();
            posRect.grow(-6, -6);
            DynamicConfigPanel.this.currentComponent.setBounds(posRect);
            DynamicConfigPanel.this.currentComponent.validate();
            Composite oldComp = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            SwingUtilities.paintComponent(g, DynamicConfigPanel.this.currentComponent, DynamicConfigPanel.this, posRect);
            g2.setComposite(oldComp);
            g2.setStroke(oldStroke);
            g.drawRect(posRect.x, posRect.y, posRect.width, posRect.height);
            g.setColor(oldColor);
            g2.setStroke(oldStroke);
        }
    }
}

