/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.messagelocation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.FileConfiguration;
import org.zaproxy.zap.extension.httppanel.HttpPanel;
import org.zaproxy.zap.extension.httppanel.component.HttpPanelComponentInterface;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelDefaultViewSelector;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.utils.ZapXmlConfiguration;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlighter;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlightsManager;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducer;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusEvent;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusListener;

public class SelectMessageLocationsPanel
extends HttpPanel
implements MessageLocationProducer,
MessageLocationHighlighter {
    private static final long serialVersionUID = -1511437565770653938L;
    private final FileConfiguration fileConfiguration = new ZapXmlConfiguration();
    private final Map<MessageLocationProducer, MessageLocationHighlightsManager> highlightsManagers = new HashMap<MessageLocationProducer, MessageLocationHighlightsManager>();
    private FocusListenerCollection focusListeners;
    private MessageLocationProducer selectedProducer;
    private List<HttpPanelView> views = new ArrayList<HttpPanelView>();

    public SelectMessageLocationsPanel() {
        super(false, "");
        this.focusListeners = new FocusListenerCollection();
    }

    @Override
    public void addFocusListener(MessageLocationProducerFocusListener fl) {
        this.focusListeners.addFocusListener(fl);
    }

    @Override
    public void removeFocusListener(MessageLocationProducerFocusListener fl) {
        this.focusListeners.removeFocusListener(fl);
    }

    @Override
    public void addComponent(HttpPanelComponentInterface component, FileConfiguration fileConfiguration) {
        super.addComponent(component, this.fileConfiguration);
    }

    @Override
    public void addView(String componentName, HttpPanelView view, Object options, FileConfiguration fileConfiguration) {
        if (!(view instanceof MessageLocationProducer)) {
            return;
        }
        ((MessageLocationProducer)((Object)view)).addFocusListener(this.focusListeners);
        this.views.add(view);
        super.addView(componentName, view, options, this.fileConfiguration);
    }

    @Override
    public void removeView(String componentName, String viewName, Object options) {
        Iterator<HttpPanelView> it = this.views.iterator();
        while (it.hasNext()) {
            HttpPanelView httpPanelView = it.next();
            if (!viewName.equals(httpPanelView.getName())) continue;
            ((MessageLocationProducer)((Object)httpPanelView)).removeFocusListener(this.focusListeners);
            it.remove();
            break;
        }
        super.removeView(componentName, viewName, options);
    }

    @Override
    public void addDefaultViewSelector(String componentName, HttpPanelDefaultViewSelector defaultViewSelector, Object options) {
    }

    @Override
    public void removeDefaultViewSelector(String componentName, String defaultViewSelectorName, Object options) {
    }

    @Override
    protected void initComponents() {
    }

    @Override
    protected void initSpecial() {
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation location) {
        if (this.getCurrentComponent() instanceof MessageLocationHighlighter) {
            MessageLocationHighlighter highlighter = (MessageLocationHighlighter)((Object)this.getCurrentComponent());
            return highlighter.highlight(location);
        }
        return null;
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation location, MessageLocationHighlight highlight) {
        if (this.getCurrentComponent() instanceof MessageLocationHighlighter) {
            MessageLocationHighlighter highlighter = (MessageLocationHighlighter)((Object)this.getCurrentComponent());
            return highlighter.highlight(location, highlight);
        }
        return null;
    }

    @Override
    public void removeHighlight(MessageLocation location, MessageLocationHighlight highlightReference) {
        if (this.getCurrentComponent() instanceof MessageLocationHighlighter) {
            MessageLocationHighlighter highlighter = (MessageLocationHighlighter)((Object)this.getCurrentComponent());
            highlighter.removeHighlight(location, highlightReference);
        }
    }

    @Override
    public boolean supports(MessageLocation location) {
        for (HttpPanelComponentInterface component : this.getEnabledComponents()) {
            MessageLocationHighlighter highlighter;
            if (!(component instanceof MessageLocationHighlighter) || !(highlighter = (MessageLocationHighlighter)((Object)component)).supports(location)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supports(Class<? extends MessageLocation> classLocation) {
        for (HttpPanelComponentInterface component : this.getEnabledComponents()) {
            MessageLocationHighlighter highlighter;
            if (!(component instanceof MessageLocationHighlighter) || !(highlighter = (MessageLocationHighlighter)((Object)component)).supports(classLocation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<? extends MessageLocation> getMessageLocationClass() {
        if (this.selectedProducer != null) {
            return this.selectedProducer.getMessageLocationClass();
        }
        return null;
    }

    @Override
    public MessageLocation getSelection() {
        if (this.selectedProducer != null) {
            return this.selectedProducer.getSelection();
        }
        return null;
    }

    @Override
    public MessageLocationHighlightsManager create() {
        if (this.selectedProducer != null) {
            MessageLocationHighlightsManager highlightsManager = this.highlightsManagers.get(this.selectedProducer);
            if (highlightsManager == null) {
                highlightsManager = this.selectedProducer.create();
                this.highlightsManagers.put(this.selectedProducer, highlightsManager);
            }
            return highlightsManager;
        }
        return null;
    }

    public boolean setSelectedView(String viewName) {
        if (viewName == null || viewName.isEmpty()) {
            throw new IllegalArgumentException("Parameter containerName must not be null nor empty.");
        }
        for (HttpPanelComponentInterface component : this.getEnabledComponents()) {
            HttpPanelView selectedView = component.setSelectedView(viewName);
            if (selectedView == null) continue;
            this.selectedProducer = (MessageLocationProducer)((Object)selectedView);
            return true;
        }
        return false;
    }

    public void reset() {
    }

    private class FocusListenerCollection
    implements MessageLocationProducerFocusListener {
        private final List<MessageLocationProducerFocusListener> focusListeners = new ArrayList<MessageLocationProducerFocusListener>(5);

        private FocusListenerCollection() {
        }

        private void addFocusListener(MessageLocationProducerFocusListener focusListener) {
            this.focusListeners.add(focusListener);
        }

        private void removeFocusListener(MessageLocationProducerFocusListener focusListener) {
            this.focusListeners.remove(focusListener);
        }

        @Override
        public void focusGained(MessageLocationProducerFocusEvent e) {
            SelectMessageLocationsPanel.this.selectedProducer = e.getSource();
            for (MessageLocationProducerFocusListener focusListener : this.focusListeners) {
                focusListener.focusGained(e);
            }
        }

        @Override
        public void focusLost(MessageLocationProducerFocusEvent e) {
            for (MessageLocationProducerFocusListener focusListener : this.focusListeners) {
                focusListener.focusLost(e);
            }
        }
    }
}

