/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.data.gpx.GpxConstants;
import org.openstreetmap.josm.data.gpx.GpxExtension;
import org.openstreetmap.josm.data.gpx.GpxExtensionCollection;
import org.openstreetmap.josm.data.gpx.IGpxTrack;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.gpx.ConvertToDataLayerAction;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.date.DateUtils;

public class ConvertFromGpxLayerAction
extends ConvertToDataLayerAction<GpxLayer> {
    private static final String GPX_SETTING = "gpx.convert-tags";

    public ConvertFromGpxLayerAction(GpxLayer layer) {
        super(layer);
    }

    @Override
    public DataSet convert() {
        DataSet ds = new DataSet();
        ds.setGPXNamespaces(((GpxLayer)this.layer).data.getNamespaces());
        ArrayList<String> keys = new ArrayList<String>();
        String convertTags = Config.getPref().get(GPX_SETTING, "ask");
        boolean check = "list".equals(convertTags) || "ask".equals(convertTags);
        boolean none = "no".equals(convertTags);
        for (IGpxTrack trk : ((GpxLayer)this.layer).data.getTracks()) {
            for (IGpxTrackSegment segment : trk.getSegments()) {
                ArrayList<Node> nodes = new ArrayList<Node>();
                for (WayPoint p : segment.getWayPoints()) {
                    Node n = new Node(p.getCoor());
                    ConvertFromGpxLayerAction.addAttributes(p.getAttributes(), n, keys, check, none);
                    if (!none) {
                        ConvertFromGpxLayerAction.addExtensions(p.getExtensions(), n, false, keys, check);
                    }
                    ds.addPrimitive(n);
                    nodes.add(n);
                }
                Way w = new Way();
                w.setNodes((List<Node>)nodes);
                ConvertFromGpxLayerAction.addAttributes(trk.getAttributes(), w, keys, check, none);
                ConvertFromGpxLayerAction.addAttributes(segment.getAttributes(), w, keys, check, none);
                if (!none) {
                    ConvertFromGpxLayerAction.addExtensions(trk.getExtensions(), w, false, keys, check);
                    ConvertFromGpxLayerAction.addExtensions(segment.getExtensions(), w, true, keys, check);
                }
                ds.addPrimitive(w);
            }
        }
        List<String> listPos = Config.getPref().getList("gpx.convert-tags.list.yes");
        List<String> listNeg = Config.getPref().getList("gpx.convert-tags.list.no");
        if (check && !keys.isEmpty()) {
            ArrayList<String> allTags = new ArrayList<String>(listPos);
            allTags.addAll(listNeg);
            if (!allTags.containsAll(keys) || "ask".equals(convertTags)) {
                TagConversionDialogResponse res = ConvertFromGpxLayerAction.showTagConversionDialog(keys, listPos, listNeg);
                if (res.sel == null) {
                    return null;
                }
                listPos = res.listPos;
                if ("no".equals(res.sel)) {
                    return this.filterDataSet(ds, null);
                }
                if ("all".equals(res.sel)) {
                    return ds;
                }
            }
            if (!listPos.containsAll(keys)) {
                return this.filterDataSet(ds, listPos);
            }
        }
        return ds;
    }

    private static void addAttributes(Map<String, Object> attr, OsmPrimitive p, List<String> keys, boolean check, boolean none) {
        for (Map.Entry<String, Object> entry : attr.entrySet()) {
            String key = entry.getKey();
            Object obj = entry.getValue();
            if (check && !keys.contains(key) && (obj instanceof String || obj instanceof Number || obj instanceof Date)) {
                keys.add(key);
            }
            if (!none && (obj instanceof String || obj instanceof Number)) {
                p.put("gpx:" + key, obj.toString());
                continue;
            }
            if (!(obj instanceof Date) || !"time".equals(key)) continue;
            Date date = (Date)obj;
            if (!none) {
                p.put("gpx:" + key, DateUtils.fromDate(date));
            }
            p.setTimestamp(date);
        }
    }

    private static void addExtensions(GpxExtensionCollection exts, OsmPrimitive p, boolean seg, List<String> keys, boolean check) {
        for (GpxExtension ext : exts) {
            String value = ext.getValue();
            if (value != null && !value.isEmpty()) {
                String extpre = "extension:";
                String pre = ext.getPrefix();
                if (pre == null || pre.isEmpty()) {
                    pre = "other";
                }
                String segpre = seg ? "segment:" : "";
                String key = ext.getFlatKey();
                String fullkey = "gpx:" + extpre + pre + ":" + segpre + key;
                if (GpxConstants.EXTENSION_ABBREVIATIONS.containsKey(fullkey)) {
                    fullkey = GpxConstants.EXTENSION_ABBREVIATIONS.get(fullkey);
                }
                if (check && !keys.contains(fullkey)) {
                    keys.add(fullkey);
                }
                p.put(fullkey, value);
            }
            ConvertFromGpxLayerAction.addExtensions(ext.getExtensions(), p, seg, keys, check);
        }
    }

    public DataSet filterDataSet(DataSet ds, List<String> listPos) {
        for (OsmPrimitive p2 : ds.getPrimitives((Predicate<? super OsmPrimitive>)((Predicate<OsmPrimitive>)p -> p instanceof Node || p instanceof Way))) {
            p2.visitKeys((primitive, key, value) -> {
                String listkey = listPos != null && key.startsWith("gpx:") ? key.substring("gpx:".length()) : key;
                if (listPos == null || !listPos.contains(listkey)) {
                    p2.put(key, null);
                }
            });
        }
        return ds;
    }

    private static TagConversionDialogResponse showTagConversionDialog(List<String> keys, List<String> listPos, List<String> listNeg) {
        TagConversionDialogResponse res = new TagConversionDialogResponse(listPos, listNeg);
        String lSel = Config.getPref().get("gpx.convert-tags.last", "all");
        JPanel p = new JPanel(new GridBagLayout());
        ButtonGroup r = new ButtonGroup();
        p.add((Component)new JLabel(I18n.tr("The GPX layer contains fields that can be converted to OSM tags. How would you like to proceed?", new Object[0])), GBC.eol());
        JRadioButton rAll = new JRadioButton(I18n.tr("Convert all fields", new Object[0]), "all".equals(lSel));
        r.add(rAll);
        p.add((Component)rAll, GBC.eol());
        JRadioButton rList = new JRadioButton(I18n.tr("Only convert the following fields:", new Object[0]), "list".equals(lSel));
        r.add(rList);
        p.add((Component)rList, GBC.eol());
        JPanel q = new JPanel();
        ArrayList<JCheckBox> checkList = new ArrayList<JCheckBox>();
        Iterator<String> iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key;
            JCheckBox cTmp = new JCheckBox(key, !listNeg.contains(key = iterator.next()));
            checkList.add(cTmp);
            q.add(cTmp);
        }
        q.setBorder(BorderFactory.createEmptyBorder(0, 20, 5, 0));
        p.add((Component)q, GBC.eol());
        JRadioButton rNone = new JRadioButton(I18n.tr("Do not convert any fields", new Object[0]), "no".equals(lSel));
        r.add(rNone);
        p.add((Component)rNone, GBC.eol());
        TagConversionDialogRadioButtonActionListener enabler = new TagConversionDialogRadioButtonActionListener(checkList, true);
        TagConversionDialogRadioButtonActionListener disabler = new TagConversionDialogRadioButtonActionListener(checkList, false);
        if (!"list".equals(lSel)) {
            disabler.actionPerformed(null);
        }
        rAll.addActionListener(disabler);
        rList.addActionListener(enabler);
        rNone.addActionListener(disabler);
        ExtendedDialog ed = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Options", new Object[0]), I18n.tr("Convert", new Object[0]), I18n.tr("Convert and remember selection", new Object[0]), I18n.tr("Cancel", new Object[0])).setButtonIcons("exportgpx", "exportgpx", "cancel").setContent(p);
        int ret = ed.showDialog().getValue();
        if (ret == 1 || ret == 2) {
            for (JCheckBox cItem : checkList) {
                String key = cItem.getText();
                if (cItem.isSelected()) {
                    if (!res.listPos.contains(key)) {
                        res.listPos.add(key);
                    }
                    res.listNeg.remove(key);
                    continue;
                }
                if (!res.listNeg.contains(key)) {
                    res.listNeg.add(key);
                }
                res.listPos.remove(key);
            }
            if (rAll.isSelected()) {
                res.sel = "all";
            } else if (rNone.isSelected()) {
                res.sel = "no";
            }
            Config.getPref().put("gpx.convert-tags.last", res.sel);
            if (ret == 2) {
                Config.getPref().put(GPX_SETTING, res.sel);
            } else {
                Config.getPref().put(GPX_SETTING, "ask");
            }
            Config.getPref().putList("gpx.convert-tags.list.yes", res.listPos);
            Config.getPref().putList("gpx.convert-tags.list.no", res.listNeg);
        } else {
            res.sel = null;
        }
        return res;
    }

    private static class TagConversionDialogRadioButtonActionListener
    implements ActionListener {
        private final boolean enable;
        private final List<JCheckBox> checkList;

        TagConversionDialogRadioButtonActionListener(List<JCheckBox> chks, boolean en) {
            this.enable = en;
            this.checkList = chks;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            for (JCheckBox ch : this.checkList) {
                ch.setEnabled(this.enable);
            }
        }
    }

    private static class TagConversionDialogResponse {
        final List<String> listPos;
        final List<String> listNeg;
        String sel = "list";

        TagConversionDialogResponse(List<String> p, List<String> n) {
            this.listPos = new ArrayList<String>(p);
            this.listNeg = new ArrayList<String>(n);
        }
    }
}

