/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Function;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Joiner;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Predicates;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Reflection;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types$ClassOwnership;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types$JavaVersion;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types$ParameterizedTypeImpl;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types$TypeVariableImpl;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types$TypeVariableInvocationHandler;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types$WildcardTypeImpl;
import java.lang.reflect.Array;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class Types {
    private static final Function TYPE_NAME = new Types$1();
    private static final Joiner COMMA_JOINER = Joiner.on(", ").useForNull("null");

    static Type newArrayType(Type type) {
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] typeArray = wildcardType.getLowerBounds();
            Preconditions.checkArgument(typeArray.length <= 1, "Wildcard cannot have more than one lower bounds.");
            if (typeArray.length == 1) {
                return Types.supertypeOf(Types.newArrayType(typeArray[0]));
            }
            Type[] typeArray2 = wildcardType.getUpperBounds();
            Preconditions.checkArgument(typeArray2.length == 1, "Wildcard should have only one upper bound.");
            return Types.subtypeOf(Types.newArrayType(typeArray2[0]));
        }
        return Types$JavaVersion.CURRENT.newArrayType(type);
    }

    static ParameterizedType newParameterizedTypeWithOwner(@NullableDecl Type type, Class clazz, Type ... typeArray) {
        if (type == null) {
            return Types.newParameterizedType(clazz, typeArray);
        }
        Preconditions.checkNotNull(typeArray);
        Preconditions.checkArgument(clazz.getEnclosingClass() != null, "Owner type for unenclosed %s", clazz);
        return new Types$ParameterizedTypeImpl(type, clazz, typeArray);
    }

    static ParameterizedType newParameterizedType(Class clazz, Type ... typeArray) {
        return new Types$ParameterizedTypeImpl(Types$ClassOwnership.JVM_BEHAVIOR.getOwnerType(clazz), clazz, typeArray);
    }

    static TypeVariable newArtificialTypeVariable(GenericDeclaration genericDeclaration, String string, Type ... typeArray) {
        Type[] typeArray2;
        if (typeArray.length == 0) {
            Type[] typeArray3 = new Type[1];
            typeArray2 = typeArray3;
            typeArray3[0] = Object.class;
        } else {
            typeArray2 = typeArray;
        }
        return Types.newTypeVariableImpl(genericDeclaration, string, typeArray2);
    }

    static WildcardType subtypeOf(Type type) {
        return new Types$WildcardTypeImpl(new Type[0], new Type[]{type});
    }

    static WildcardType supertypeOf(Type type) {
        return new Types$WildcardTypeImpl(new Type[]{type}, new Type[]{Object.class});
    }

    static String toString(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    @NullableDecl
    static Type getComponentType(Type type) {
        Preconditions.checkNotNull(type);
        AtomicReference atomicReference = new AtomicReference();
        new Types$2(atomicReference).visit(type);
        return (Type)atomicReference.get();
    }

    @NullableDecl
    private static Type subtypeOfComponentType(Type[] typeArray) {
        for (Type type : typeArray) {
            Class clazz;
            Type type2 = Types.getComponentType(type);
            if (type2 == null) continue;
            if (type2 instanceof Class && (clazz = (Class)type2).isPrimitive()) {
                return clazz;
            }
            return Types.subtypeOf(type2);
        }
        return null;
    }

    private static TypeVariable newTypeVariableImpl(GenericDeclaration genericDeclaration, String string, Type[] typeArray) {
        Types$TypeVariableImpl types$TypeVariableImpl = new Types$TypeVariableImpl(genericDeclaration, string, typeArray);
        TypeVariable typeVariable = (TypeVariable)Reflection.newProxy(TypeVariable.class, new Types$TypeVariableInvocationHandler(types$TypeVariableImpl));
        return typeVariable;
    }

    private static Type[] toArray(Collection collection) {
        return collection.toArray(new Type[collection.size()]);
    }

    private static Iterable filterUpperBounds(Iterable iterable) {
        return Iterables.filter(iterable, Predicates.not(Predicates.equalTo(Object.class)));
    }

    private static void disallowPrimitiveType(Type[] typeArray, String string) {
        for (Type type : typeArray) {
            if (!(type instanceof Class)) continue;
            Class clazz = (Class)type;
            Preconditions.checkArgument(!clazz.isPrimitive(), "Primitive type '%s' used as %s", (Object)clazz, string);
        }
    }

    static Class getArrayClass(Class clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }

    static /* synthetic */ Type access$100(Type[] typeArray) {
        return Types.subtypeOfComponentType(typeArray);
    }

    static /* synthetic */ void access$200(Type[] typeArray, String string) {
        Types.disallowPrimitiveType(typeArray, string);
    }

    static /* synthetic */ Type[] access$300(Collection collection) {
        return Types.toArray(collection);
    }

    static /* synthetic */ Function access$400() {
        return TYPE_NAME;
    }

    static /* synthetic */ Joiner access$500() {
        return COMMA_JOINER;
    }

    static /* synthetic */ Iterable access$700(Iterable iterable) {
        return Types.filterUpperBounds(iterable);
    }
}

